/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.runtime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.admin.runtime.SimplifiedBundleInfo;
import org.nuxeo.ecm.admin.runtime.SimplifiedServerInfo;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.osgi.JarBundleFile;
import org.nuxeo.runtime.RuntimeMessageHandler;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class RuntimeInstrospection {
    protected static final Log log = LogFactory.getLog(RuntimeInstrospection.class);
    protected static SimplifiedServerInfo info;
    protected static List<String> bundleIds;

    public static synchronized SimplifiedServerInfo getInfo() {
        if (info == null) {
            RuntimeService runtime = Framework.getRuntime();
            Collection registrations = runtime.getComponentManager().getRegistrations();
            bundleIds = new ArrayList<String>();
            ArrayList<SimplifiedBundleInfo> bundles = new ArrayList<SimplifiedBundleInfo>();
            for (RegistrationInfo ri : registrations) {
                Bundle bundle = ri.getContext().getBundle();
                if (bundle == null || bundleIds.contains(bundle.getSymbolicName())) continue;
                SimplifiedBundleInfo bi = RuntimeInstrospection.getBundleSimplifiedInfo(bundle);
                bundleIds.add(bundle.getSymbolicName());
                if (bi == null) continue;
                bundles.add(bi);
            }
            Collections.sort(bundles);
            info = new SimplifiedServerInfo();
            info.setBundleInfos(bundles);
            info.setRuntimeVersion(runtime.getVersion().toString());
            RuntimeMessageHandler runtimeMessageHandler = runtime.getMessageHandler();
            info.setWarnings(runtimeMessageHandler.getWarnings());
            info.setErrors(runtimeMessageHandler.getErrors());
        }
        return info;
    }

    public static List<String> getBundleIds() {
        if (bundleIds == null) {
            RuntimeInstrospection.getInfo();
        }
        return bundleIds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static SimplifiedBundleInfo getBundleSimplifiedInfo(Bundle bundle) {
        Version version;
        if (!(bundle instanceof BundleImpl)) {
            return null;
        }
        BundleImpl nxBundle = (BundleImpl)bundle;
        BundleFile file = nxBundle.getBundleFile();
        File jarFile = null;
        if (file instanceof JarBundleFile) {
            JarBundleFile jar = (JarBundleFile)file;
            jarFile = jar.getFile();
        }
        if (jarFile == null) return null;
        if (jarFile.isDirectory()) {
            return null;
        }
        SimplifiedBundleInfo result = null;
        try (ZipFile zFile = new ZipFile(jarFile);){
            Enumeration<? extends ZipEntry> entries = zFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().endsWith("pom.properties")) continue;
                try (InputStream pomStream = zFile.getInputStream(entry);){
                    PropertyResourceBundle prb = new PropertyResourceBundle(pomStream);
                    String version2 = prb.getString("version");
                    result = new SimplifiedBundleInfo(bundle.getSymbolicName(), version2);
                    break;
                }
            }
        }
        catch (IOException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
        if (result == null) {
            try {
                version = new org.nuxeo.connect.update.Version(jarFile.getName());
                result = new SimplifiedBundleInfo(bundle.getSymbolicName(), version.toString());
            }
            catch (NumberFormatException e) {
                log.debug((Object)e.getMessage());
            }
        }
        if (result != null) return result;
        try {
            version = bundle.getVersion();
            return new SimplifiedBundleInfo(bundle.getSymbolicName(), version.toString());
        }
        catch (RuntimeException e) {
            log.debug((Object)e.getMessage());
            return new SimplifiedBundleInfo(bundle.getSymbolicName(), "unknown");
        }
    }
}

