/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.connect;

import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.common.Environment;
import org.nuxeo.connect.CallbackHolder;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.packages.LocalPackageAsDownloadablePackage;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.packages.dependencies.CUDFHelper;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageUtils;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.Version;
import org.nuxeo.connect.update.model.PackageDefinition;
import org.nuxeo.connect.update.standalone.StandaloneUpdateService;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.launcher.connect.LauncherRestartException;
import org.nuxeo.launcher.connect.StandaloneCallbackHolder;
import org.nuxeo.launcher.info.CommandInfo;
import org.nuxeo.launcher.info.CommandSetInfo;
import org.nuxeo.launcher.info.PackageInfo;

public class ConnectBroker {
    private static final Logger log = LogManager.getLogger(ConnectBroker.class);
    public static final String[] POSITIVE_ANSWERS = new String[]{"true", "yes", "y"};
    protected static final String LAUNCHER_CHANGED_PROPERTY = "launcher.changed";
    private Environment env;
    private StandaloneUpdateService service;
    private CallbackHolder cbHolder;
    private CommandSetInfo cset = new CommandSetInfo();
    private String targetPlatform;
    private String relax = "ask";
    public static final String OPTION_RELAX_DEFAULT = "ask";
    private String accept = "ask";
    private boolean allowSNAPSHOT = CUDFHelper.defaultAllowSNAPSHOT;
    private Path pendingFile;
    public static final String OPTION_ACCEPT_DEFAULT = "ask";

    public ConnectBroker(Environment env) throws IOException, PackageException {
        this.env = env;
        this.service = new StandaloneUpdateService(env);
        this.service.initialize();
        this.cbHolder = new StandaloneCallbackHolder(env, this.service);
        NuxeoConnectClient.setCallBackHolder((CallbackHolder)this.cbHolder);
        this.targetPlatform = env.getProperty("org.nuxeo.distribution.name") + "-" + env.getProperty("org.nuxeo.distribution.version");
    }

    public Path getPendingFile() {
        return this.pendingFile;
    }

    public void setPendingFile(Path pendingFile) {
        this.pendingFile = pendingFile;
    }

    public String getCLID() throws LogicalInstanceIdentifier.NoCLID {
        return LogicalInstanceIdentifier.instance().getCLID();
    }

    public void setCLID(String file) throws LogicalInstanceIdentifier.NoCLID {
        try {
            LogicalInstanceIdentifier.load((String)file);
        }
        catch (IOException | LogicalInstanceIdentifier.InvalidCLID e) {
            throw new LogicalInstanceIdentifier.NoCLID("can not load CLID", (Exception)e);
        }
    }

    public void saveCLID() throws IOException, LogicalInstanceIdentifier.NoCLID {
        LogicalInstanceIdentifier.instance().save();
    }

    public StandaloneUpdateService getUpdateService() {
        return this.service;
    }

    public PackageManager getPackageManager() {
        return NuxeoConnectClient.getPackageManager((String)this.targetPlatform);
    }

    public void refreshCache() {
        this.getPackageManager().flushCache();
        this.getPackageManager().listAllPackages();
    }

    public CommandSetInfo getCommandSet() {
        return this.cset;
    }

    protected LocalPackage getInstalledPackageByName(String pkgName) {
        try {
            return this.service.getPersistence().getActivePackage(pkgName);
        }
        catch (PackageException e) {
            log.error((Object)e);
            return null;
        }
    }

    protected boolean isInstalledPackage(String pkgName) {
        try {
            return this.service.getPersistence().getActivePackageId(pkgName) != null;
        }
        catch (PackageException e) {
            log.error("Error checking installation of package {}", (Object)pkgName, (Object)e);
            return false;
        }
    }

    protected boolean isLocalPackageId(String pkgId) {
        try {
            return this.service.getPackage(pkgId) != null;
        }
        catch (PackageException e) {
            log.error("Error looking for local package {}", (Object)pkgId, (Object)e);
            return false;
        }
    }

    protected boolean isRemotePackageId(String pkgId) {
        return PackageUtils.isValidPackageId((String)pkgId) && this.getPackageManager().getRemotePackage(pkgId) != null;
    }

    protected String getBestIdForNameInList(String pkgName, List<? extends Package> pkgList) {
        String foundId = null;
        TreeMap<Version, String> foundPkgs = new TreeMap<Version, String>();
        TreeMap<Version, String> matchingPkgs = new TreeMap<Version, String>();
        for (Package package_ : pkgList) {
            if (!package_.getName().equals(pkgName)) continue;
            foundPkgs.put(package_.getVersion(), package_.getId());
            if (!Arrays.asList(package_.getTargetPlatforms()).contains(this.targetPlatform)) continue;
            matchingPkgs.put(package_.getVersion(), package_.getId());
        }
        if (matchingPkgs.size() != 0) {
            foundId = (String)matchingPkgs.get(matchingPkgs.lastKey());
        } else if (foundPkgs.size() != 0) {
            foundId = (String)foundPkgs.get(foundPkgs.lastKey());
        }
        return foundId;
    }

    protected String getLocalPackageIdFromName(String pkgName) {
        return this.getBestIdForNameInList(pkgName, this.getPkgList());
    }

    protected List<String> getAllLocalPackageIdsFromName(String pkgName) {
        ArrayList<String> foundIds = new ArrayList<String>();
        for (Package package_ : this.getPkgList()) {
            if (!package_.getName().equals(pkgName)) continue;
            foundIds.add(package_.getId());
        }
        return foundIds;
    }

    protected String getInstalledPackageIdFromName(String pkgName) {
        List<LocalPackage> localPackages = this.getPkgList();
        ArrayList<LocalPackage> installedPackages = new ArrayList<LocalPackage>();
        for (LocalPackage pkg : localPackages) {
            if (!pkg.getPackageState().isInstalled()) continue;
            installedPackages.add(pkg);
        }
        return this.getBestIdForNameInList(pkgName, installedPackages);
    }

    protected String getRemotePackageIdFromName(String pkgName) {
        return this.getBestIdForNameInList(pkgName, this.getPackageManager().findRemotePackages(pkgName));
    }

    protected String getRemotePackageId(String pkgNameOrId) {
        String pkgId = this.isRemotePackageId(pkgNameOrId) ? pkgNameOrId : this.getRemotePackageIdFromName(pkgNameOrId);
        return pkgId;
    }

    protected LocalPackage getLocalPackage(String pkgIdOrName) throws PackageException {
        String pkgId;
        LocalPackage pkg = this.service.getPackage(pkgIdOrName);
        if (pkg == null && (pkgId = this.getLocalPackageIdFromName(pkgIdOrName)) != null) {
            pkg = this.service.getPackage(pkgId);
        }
        return pkg;
    }

    protected File getLocalPackageFile(String pkgFile) {
        File fileToCheck;
        if (pkgFile.startsWith("file:")) {
            pkgFile = pkgFile.substring(5);
        }
        if (!(fileToCheck = new File(pkgFile)).exists()) {
            fileToCheck = new File(this.env.getServerHome(), pkgFile);
        }
        if (fileToCheck.exists()) {
            return fileToCheck;
        }
        return null;
    }

    protected String getLocalPackageFileId(File pkgFile) {
        PackageDefinition packageDefinition;
        block4: {
            try {
                if (pkgFile.isFile()) {
                    packageDefinition = this.service.loadPackageFromZip(pkgFile);
                    break block4;
                }
                if (pkgFile.isDirectory()) {
                    File manifest = new File(pkgFile, "package.xml");
                    packageDefinition = this.service.loadPackage(manifest);
                    break block4;
                }
                throw new PackageException("Unknown file type (not a file and not a directory) for " + pkgFile);
            }
            catch (PackageException e) {
                log.error("Error trying to load package id from {}", (Object)pkgFile, (Object)e);
                return null;
            }
        }
        return packageDefinition == null ? null : packageDefinition.getId();
    }

    protected boolean isLocalPackageFile(String pkgFile) {
        return this.getLocalPackageFile(pkgFile) != null;
    }

    public List<LocalPackage> getPkgList() {
        try {
            return this.service.getPackages();
        }
        catch (PackageException e) {
            log.error("Could not read package list", (Throwable)e);
            return null;
        }
    }

    public void pkgList() {
        log.info("Local packages:");
        this.pkgList(this.getPkgList().stream().map(LocalPackageAsDownloadablePackage::new).collect(Collectors.toList()));
    }

    public void pkgListAll() {
        if (Boolean.parseBoolean(this.relax)) {
            log.info("All packages (all platforms):");
            this.pkgList(this.getPackageManager().getAllPackages(this.getPackageManager().getAllSources(), null, null));
        } else {
            log.info("All packages:");
            this.pkgList(this.getPackageManager().listAllPackages());
        }
    }

    private String getPrivateOrSubscriptionTag(DownloadablePackage pkg) {
        Object tag = "";
        if (pkg.getOwner() != null) {
            tag = "[PRIVATE (Owner: " + pkg.getOwner() + ")]";
        } else if (pkg.getPackageState() == PackageState.REMOTE && pkg.getType() != PackageType.STUDIO && pkg.hasSubscriptionRequired() && !LogicalInstanceIdentifier.isRegistered()) {
            tag = "[REGISTRATION REQUIRED]";
        }
        return tag;
    }

    public void pkgList(List<? extends DownloadablePackage> packagesList) {
        CommandInfo cmdInfo = this.cset.newCommandInfo("list");
        try {
            if (packagesList.isEmpty()) {
                log.info("None");
            } else {
                this.getPackageManager().sort(packagesList);
                StringBuilder sb = new StringBuilder();
                for (DownloadablePackage downloadablePackage : packagesList) {
                    this.newPackageInfo(cmdInfo, (Package)downloadablePackage);
                    String packageDescription = String.format("%6s %11s\t%s (id: %s) %s\n", downloadablePackage.getType(), downloadablePackage.getPackageState().getLabel(), downloadablePackage.getName(), downloadablePackage.getId(), this.getPrivateOrSubscriptionTag(downloadablePackage));
                    sb.append(packageDescription);
                }
                log.info(sb::toString);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            cmdInfo.exitCode = 1;
        }
    }

    protected void performTask(Task task) throws PackageException {
        ValidationStatus validationStatus = task.validate();
        if (validationStatus.hasErrors()) {
            throw new PackageException("Failed to validate package " + task.getPackage().getId() + " -> " + validationStatus.getErrors());
        }
        if (validationStatus.hasWarnings()) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> task.getPackage().getId();
            supplierArray[1] = () -> ((ValidationStatus)validationStatus).getWarnings();
            log.warn("Got warnings on package validation {} -> {}", supplierArray);
        }
        task.run(null);
    }

    public boolean pkgReset() {
        CommandInfo cmdInfo = this.cset.newCommandInfo("reset");
        if ("ask".equalsIgnoreCase(this.accept)) {
            this.accept = this.readConsole("The reset will erase the Nuxeo Packages history.\nDo you want to continue (yes/no)? [yes] ", "yes", new Object[0]);
        }
        if (!Boolean.parseBoolean(this.accept)) {
            cmdInfo.exitCode = 1;
            return false;
        }
        try {
            this.service.reset();
            log.info("Packages reset done: all packages were marked as DOWNLOADED");
            List<LocalPackage> localPackages = this.service.getPackages();
            for (LocalPackage localPackage : localPackages) {
                localPackage.getUninstallFile().delete();
                FileUtils.deleteDirectory((File)localPackage.getData().getEntry("backup"));
                this.newPackageInfo(cmdInfo, (Package)localPackage);
            }
            this.service.getRegistry().delete();
            FileUtils.deleteDirectory((File)this.service.getBackupDir());
        }
        catch (IOException | PackageException e) {
            log.error((Object)e);
            cmdInfo.exitCode = 1;
        }
        return cmdInfo.exitCode == 0;
    }

    public boolean pkgPurge() throws PackageException {
        ArrayList<String> localNames = new ArrayList<String>();
        for (LocalPackage pkg : this.service.getPackages()) {
            if (pkg.getPackageState() != PackageState.DOWNLOADED) continue;
            this.pkgRemove(pkg.getId());
        }
        for (LocalPackage pkg : this.service.getPackages()) {
            localNames.add(pkg.getName());
        }
        return this.pkgRequest(null, null, null, localNames, true, false);
    }

    public boolean pkgUninstall(List<String> packageIdsToRemove) {
        log.debug("Uninstalling: {}", packageIdsToRemove);
        LinkedList<String> remaining = new LinkedList<String>(packageIdsToRemove);
        while (!remaining.isEmpty()) {
            String pkgId = (String)remaining.poll();
            if (this.pkgUninstall(pkgId) == null) {
                log.error("Unable to uninstall {}", (Object)pkgId);
                return false;
            }
            if (!this.isRestartRequired()) continue;
            remaining.forEach(pkg -> this.persistCommand("uninstall " + pkg));
            throw new LauncherRestartException();
        }
        return true;
    }

    public LocalPackage pkgUninstall(String pkgId) {
        CommandInfo cmdInfo = this.cset.newCommandInfo("uninstall");
        cmdInfo.param = pkgId;
        try {
            String realPkgId;
            LocalPackage pkg = this.service.getPackage(pkgId);
            if (pkg == null && (realPkgId = this.getInstalledPackageIdFromName(pkgId)) != null) {
                pkgId = realPkgId;
                pkg = this.service.getPackage(realPkgId);
            }
            if (pkg == null) {
                throw new PackageException("Package not found: " + pkgId);
            }
            log.info("Uninstalling {}", (Object)pkgId);
            Task uninstallTask = pkg.getUninstallTask();
            try {
                this.performTask(uninstallTask);
            }
            catch (PackageException e) {
                uninstallTask.rollback();
                throw e;
            }
            pkg = this.service.getPackage(pkgId);
            this.newPackageInfo(cmdInfo, (Package)pkg);
            return pkg;
        }
        catch (Exception e) {
            log.error("Failed to uninstall package: {}", (Object)pkgId, (Object)e);
            cmdInfo.exitCode = 1;
            return null;
        }
    }

    public boolean pkgRemove(List<String> pkgsToRemove) {
        boolean cmdOk = true;
        if (pkgsToRemove != null) {
            log.debug("Removing: {}", pkgsToRemove);
            for (String pkgNameOrId : pkgsToRemove) {
                List<Object> allIds;
                if (this.isLocalPackageId(pkgNameOrId)) {
                    allIds = new ArrayList();
                    allIds.add(pkgNameOrId);
                } else {
                    allIds = this.getAllLocalPackageIdsFromName(pkgNameOrId);
                }
                for (String string : allIds) {
                    if (this.pkgRemove(string) != null) continue;
                    log.warn("Unable to remove {}", (Object)string);
                    cmdOk = false;
                }
            }
        }
        return cmdOk;
    }

    public LocalPackage pkgRemove(String pkgId) {
        CommandInfo cmdInfo = this.cset.newCommandInfo("remove");
        cmdInfo.param = pkgId;
        try {
            String realPkgId;
            LocalPackage pkg = this.service.getPackage(pkgId);
            if (pkg == null && (realPkgId = this.getLocalPackageIdFromName(pkgId)) != null) {
                pkgId = realPkgId;
                pkg = this.service.getPackage(realPkgId);
            }
            if (pkg == null) {
                throw new PackageException("Package not found: " + pkgId);
            }
            if (pkg.getPackageState().isInstalled()) {
                this.pkgUninstall(pkgId);
                pkg = this.service.getPackage(pkgId);
            }
            if (pkg.getPackageState() != PackageState.DOWNLOADED) {
                throw new PackageException("Can only remove packages in DOWNLOADED, INSTALLED or STARTED state");
            }
            this.service.removePackage(pkgId);
            log.info("Removed {}", (Object)pkgId);
            this.newPackageInfo((CommandInfo)cmdInfo, (Package)pkg).state = PackageState.REMOTE;
            return pkg;
        }
        catch (Exception e) {
            log.error("Failed to remove package: {}", (Object)pkgId, (Object)e);
            cmdInfo.exitCode = 1;
            return null;
        }
    }

    public boolean pkgAdd(List<String> pkgsToAdd, boolean ignoreMissing) {
        boolean cmdOk = true;
        if (pkgsToAdd == null || pkgsToAdd.isEmpty()) {
            return cmdOk;
        }
        ArrayList<String> pkgIdsToDownload = new ArrayList<String>();
        for (String pkgToAdd : pkgsToAdd) {
            CommandInfo cmdInfo = this.cset.newCommandInfo("add");
            cmdInfo.param = pkgToAdd;
            try {
                File fileToAdd = this.getLocalPackageFile(pkgToAdd);
                if (fileToAdd == null) {
                    String pkgId = this.getRemotePackageId(pkgToAdd);
                    if (pkgId == null) {
                        if (ignoreMissing) {
                            log.warn("Could not add package: {}", (Object)pkgToAdd);
                            cmdInfo.newMessage(3, "Could not add package.");
                            continue;
                        }
                        throw new PackageException("Could not find a remote or local (relative to current directory or to NUXEO_HOME) package with name or ID " + pkgToAdd);
                    }
                    cmdInfo.newMessage(3, "Waiting for download...");
                    pkgIdsToDownload.add(pkgId);
                    continue;
                }
                LocalPackage pkg = this.service.addPackage(fileToAdd);
                log.info("Added {}", (Object)pkg);
                this.newPackageInfo(cmdInfo, (Package)pkg);
            }
            catch (PackageException e) {
                cmdOk = false;
                cmdInfo.exitCode = 1;
                cmdInfo.newMessage((Exception)((Object)e));
            }
        }
        cmdOk = this.downloadPackages(pkgIdsToDownload) && cmdOk;
        return cmdOk;
    }

    public LocalPackage pkgAdd(String packageFileName, boolean ignoreMissing) {
        CommandInfo cmdInfo = this.cset.newCommandInfo("add");
        cmdInfo.param = packageFileName;
        LocalPackage pkg = null;
        try {
            File fileToAdd = this.getLocalPackageFile(packageFileName);
            if (fileToAdd == null) {
                String pkgId = this.getRemotePackageId(packageFileName);
                if (pkgId == null) {
                    if (ignoreMissing) {
                        log.warn("Could not add package: {}", (Object)packageFileName);
                        cmdInfo.newMessage(3, "Could not add package.");
                        return null;
                    }
                    throw new PackageException("Could not find a remote or local (relative to current directory or to NUXEO_HOME) package with name or ID " + packageFileName);
                }
                if (!this.downloadPackages(new ArrayList<String>(Collections.singleton(pkgId)))) {
                    throw new PackageException("Could not download package " + pkgId);
                }
                pkg = this.service.getPackage(pkgId);
                if (pkg == null) {
                    throw new PackageException("Could not find downloaded package in cache " + pkgId);
                }
            } else {
                pkg = this.service.addPackage(fileToAdd);
                log.info("Added {}", (Object)packageFileName);
            }
            this.newPackageInfo(cmdInfo, (Package)pkg);
        }
        catch (PackageException e) {
            cmdInfo.exitCode = 1;
            cmdInfo.newMessage((Exception)((Object)e));
        }
        return pkg;
    }

    public boolean pkgInstall(List<String> packageIdsToInstall, boolean ignoreMissing) {
        log.debug("Installing: {}", packageIdsToInstall);
        LinkedList<String> remaining = new LinkedList<String>(packageIdsToInstall);
        while (!remaining.isEmpty()) {
            String pkgId = (String)remaining.poll();
            if (this.pkgInstall(pkgId, ignoreMissing) == null && !ignoreMissing) {
                return false;
            }
            if (!this.isRestartRequired()) continue;
            remaining.forEach(pkg -> this.persistCommand("install " + pkg));
            throw new LauncherRestartException();
        }
        return true;
    }

    protected void persistCommand(String command) {
        if (command.isEmpty()) {
            return;
        }
        try {
            Files.write(this.pendingFile, Collections.singletonList(command), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot write to file " + this.pendingFile, e);
        }
    }

    protected boolean isRestartRequired() {
        return "true".equals(this.env.getProperty(LAUNCHER_CHANGED_PROPERTY));
    }

    public LocalPackage pkgInstall(String pkgId, boolean ignoreMissing) {
        CommandInfo cmdInfo = this.cset.newCommandInfo("install");
        cmdInfo.param = pkgId;
        try {
            LocalPackage pkg = this.getLocalPackage(pkgId);
            if (pkg != null && pkg.getPackageState().isInstalled()) {
                if (pkg.getVersion().isSnapshot()) {
                    log.info("Updating package {}...", (Object)pkg);
                    this.pkgRemove(pkgId);
                    pkg = null;
                } else {
                    log.info("Package {} is already installed.", (Object)pkg);
                    return pkg;
                }
            }
            if (pkg == null) {
                pkg = this.pkgAdd(pkgId, ignoreMissing);
            }
            if (pkg == null) {
                if (ignoreMissing) {
                    log.warn("Unable to install package: {}", (Object)pkgId);
                    return null;
                }
                throw new PackageException("Package not found: " + pkgId);
            }
            cmdInfo.param = pkgId = pkg.getId();
            log.info("Installing {}", (Object)pkgId);
            Task installTask = pkg.getInstallTask();
            try {
                this.performTask(installTask);
            }
            catch (PackageException e) {
                installTask.rollback();
                throw e;
            }
            pkg = this.service.getPackage(pkgId);
            this.newPackageInfo(cmdInfo, (Package)pkg);
            return pkg;
        }
        catch (PackageException e) {
            log.error("Failed to install package: {} ({})", (Object)pkgId, (Object)e.getMessage());
            log.debug((Object)e, (Throwable)e);
            cmdInfo.exitCode = 1;
            cmdInfo.newMessage((Exception)((Object)e));
            return null;
        }
    }

    public boolean listPending(File commandsFile) {
        return this.executePending(commandsFile, false, false, false);
    }

    public boolean executePending(File commandsFile, boolean doExecute, boolean useResolver, boolean ignoreMissing) {
        Path commandsPath;
        int errorValue = 0;
        if (!commandsFile.isFile()) {
            return false;
        }
        ArrayList<String> pkgsToAdd = new ArrayList<String>();
        ArrayList<String> pkgsToInstall = new ArrayList<String>();
        ArrayList<String> pkgsToUninstall = new ArrayList<String>();
        ArrayList<String> pkgsToRemove = new ArrayList<String>();
        this.pendingFile = commandsPath = commandsFile.toPath();
        Path backup = commandsPath.resolveSibling(commandsFile.getName() + ".bak");
        try {
            LinkedList<String> remainingCmds = new LinkedList<String>(Files.readAllLines(commandsFile.toPath()));
            if (doExecute) {
                Files.move(commandsPath, backup, StandardCopyOption.REPLACE_EXISTING);
            }
            while (!remainingCmds.isEmpty()) {
                CommandInfo cmdInfo;
                String line = ((String)remainingCmds.poll()).trim();
                String[] split = line.split("\\s+", 2);
                if (split.length == 2) {
                    if (split[0].equals("install")) {
                        if (doExecute) {
                            if (useResolver) {
                                pkgsToInstall.add(split[1]);
                            } else {
                                this.pkgInstall(split[1], ignoreMissing);
                            }
                        } else {
                            cmdInfo = this.cset.newCommandInfo("install");
                            cmdInfo.param = split[1];
                            cmdInfo.pending = true;
                        }
                    } else if (split[0].equals("add")) {
                        if (doExecute) {
                            if (useResolver) {
                                pkgsToAdd.add(split[1]);
                            } else {
                                this.pkgAdd(split[1], ignoreMissing);
                            }
                        } else {
                            cmdInfo = this.cset.newCommandInfo("add");
                            cmdInfo.param = split[1];
                            cmdInfo.pending = true;
                        }
                    } else if (split[0].equals("uninstall")) {
                        if (doExecute) {
                            if (useResolver) {
                                pkgsToUninstall.add(split[1]);
                            } else {
                                this.pkgUninstall(split[1]);
                            }
                        } else {
                            cmdInfo = this.cset.newCommandInfo("uninstall");
                            cmdInfo.param = split[1];
                            cmdInfo.pending = true;
                        }
                    } else if (split[0].equals("remove")) {
                        if (doExecute) {
                            if (useResolver) {
                                pkgsToRemove.add(split[1]);
                            } else {
                                this.pkgRemove(split[1]);
                            }
                        } else {
                            cmdInfo = this.cset.newCommandInfo("remove");
                            cmdInfo.param = split[1];
                            cmdInfo.pending = true;
                        }
                    } else {
                        errorValue = 1;
                    }
                } else if (split.length == 1 && line.length() > 0 && !line.startsWith("#")) {
                    if (doExecute) {
                        if (useResolver) {
                            pkgsToInstall.add(line);
                        } else {
                            this.pkgInstall(line, ignoreMissing);
                        }
                    } else if ("init".equals(line)) {
                        cmdInfo = this.cset.newCommandInfo("init");
                        cmdInfo.pending = true;
                    } else {
                        cmdInfo = this.cset.newCommandInfo("install");
                        cmdInfo.param = line;
                        cmdInfo.pending = true;
                    }
                }
                if (errorValue != 0) {
                    log.error("Error processing pending package/command: {}", (Object)line);
                }
                if (!doExecute || useResolver || !this.isRestartRequired()) continue;
                remainingCmds.forEach(this::persistCommand);
                throw new LauncherRestartException();
            }
            if (doExecute) {
                if (useResolver) {
                    String oldAccept = this.accept;
                    String oldRelax = this.relax;
                    this.accept = "true";
                    if ("ask".equalsIgnoreCase(this.relax)) {
                        log.info("Relax mode changed from 'ask' to 'false' for executing the pending actions.");
                        this.relax = "false";
                    }
                    boolean success = this.pkgRequest(pkgsToAdd, pkgsToInstall, pkgsToUninstall, pkgsToRemove, true, ignoreMissing);
                    this.accept = oldAccept;
                    this.relax = oldRelax;
                    if (!success) {
                        errorValue = 2;
                    }
                }
                if (errorValue != 0) {
                    log.error("Pending actions execution failed. The commands file has been moved to: {}", (Object)backup);
                }
            } else {
                this.cset.log(true);
            }
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
        return errorValue == 0;
    }

    protected boolean downloadPackages(List<String> packagesToDownload) {
        boolean isRegistered = LogicalInstanceIdentifier.isRegistered();
        ArrayList<String> packagesAlreadyDownloaded = new ArrayList<String>();
        for (String pkg : packagesToDownload) {
            LocalPackage localPackage;
            try {
                localPackage = this.getLocalPackage(pkg);
            }
            catch (PackageException e) {
                log.error("Looking for package '{}' in local cache raised an error. Aborting.", (Object)pkg, (Object)e);
                return false;
            }
            if (localPackage == null) continue;
            if (localPackage.getPackageState().isInstalled()) {
                log.error("Package '{}' is installed. Download skipped.", (Object)pkg);
                packagesAlreadyDownloaded.add(pkg);
                continue;
            }
            if (localPackage.getVersion().isSnapshot()) {
                DownloadablePackage downloadablePkg = this.getPackageManager().findRemotePackageById(pkg);
                if (downloadablePkg != null && downloadablePkg.hasSubscriptionRequired() && !isRegistered) {
                    log.info("Registration is required for package '{}'. Download skipped.", (Object)pkg);
                    packagesAlreadyDownloaded.add(pkg);
                    continue;
                }
                log.info("Download of '{}' will replace the one already in local cache.", (Object)pkg);
                continue;
            }
            log.info("Package '{}' is already in local cache.", (Object)pkg);
            packagesAlreadyDownloaded.add(pkg);
        }
        packagesToDownload.removeAll(packagesAlreadyDownloaded);
        if (packagesToDownload.isEmpty()) {
            return true;
        }
        log.info("Downloading {}...", packagesToDownload);
        boolean downloadOk = true;
        ArrayList<DownloadingPackage> pkgs = new ArrayList<DownloadingPackage>();
        for (String pkg : packagesToDownload) {
            CommandInfo cmdInfo = this.cset.newCommandInfo("download");
            cmdInfo.param = pkg;
            DownloadablePackage downloadablePkg = this.getPackageManager().findRemotePackageById(pkg);
            if (downloadablePkg != null && downloadablePkg.hasSubscriptionRequired() && !isRegistered) {
                downloadOk = false;
                cmdInfo.exitCode = 1;
                cmdInfo.newMessage(5, "Registration required.");
                continue;
            }
            try {
                DownloadingPackage download = this.getPackageManager().download(pkg);
                if (download != null) {
                    pkgs.add(download);
                    cmdInfo.param = download.getId();
                    cmdInfo.newMessage(2, "Downloading...");
                    continue;
                }
                downloadOk = false;
                cmdInfo.exitCode = 1;
                cmdInfo.newMessage(5, "Download failed (not found).");
            }
            catch (ConnectServerError e) {
                log.debug((Object)e, (Throwable)e);
                downloadOk = false;
                cmdInfo.exitCode = 1;
                cmdInfo.newMessage(5, "Download failed: " + e.getMessage());
            }
        }
        String progress = "|/-\\";
        int x = 0;
        boolean stopDownload = false;
        do {
            System.out.print("|/-\\".charAt(x++ % "|/-\\".length()) + "\r");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            ArrayList<DownloadingPackage> pkgsCompleted = new ArrayList<DownloadingPackage>();
            for (DownloadingPackage pkg : pkgs) {
                if (!pkg.isCompleted()) continue;
                pkgsCompleted.add(pkg);
                CommandInfo cmdInfo = this.cset.newCommandInfo("download");
                cmdInfo.param = pkg.getId();
                if (pkg.getPackageState() == PackageState.DOWNLOADED) {
                    cmdInfo.newMessage(2, "Downloaded.");
                    continue;
                }
                downloadOk = false;
                cmdInfo.exitCode = 1;
                cmdInfo.newMessage(5, "Download failed: " + pkg.getErrorMessage());
                if (!pkg.isServerError()) continue;
                stopDownload = true;
            }
            pkgs.removeAll(pkgsCompleted);
        } while (!stopDownload && !pkgs.isEmpty());
        if (!pkgs.isEmpty()) {
            downloadOk = false;
            log.error("Packages download was interrupted");
            for (DownloadingPackage pkg : pkgs) {
                CommandInfo cmdInfo = this.cset.newCommandInfo("add");
                cmdInfo.param = pkg.getId();
                cmdInfo.exitCode = 1;
                cmdInfo.newMessage(5, "Download interrupted.");
            }
        }
        return downloadOk;
    }

    public boolean pkgRequest(List<String> pkgsToAdd, List<String> pkgsToInstall, List<String> pkgsToUninstall, List<String> pkgsToRemove, boolean keepExisting, boolean ignoreMissing) {
        return this.pkgRequest(pkgsToAdd, pkgsToInstall, pkgsToUninstall, pkgsToRemove, keepExisting, ignoreMissing, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pkgRequest(List<String> pkgsToAdd, List<String> pkgsToInstall, List<String> pkgsToUninstall, List<String> pkgsToRemove, boolean keepExisting, boolean ignoreMissing, boolean upgradeMode) {
        String actualTargetPlatform = this.targetPlatform;
        try {
            if (Boolean.parseBoolean(this.relax)) {
                this.targetPlatform = null;
            }
            boolean cmdOk = this.pkgAdd(pkgsToAdd, ignoreMissing);
            ArrayList<String> solverInstall = new ArrayList<String>();
            ArrayList<String> solverRemove = new ArrayList<String>();
            ArrayList<String> solverUpgrade = new ArrayList<String>();
            HashSet<String> localSnapshotsToMaybeReplace = new HashSet<String>();
            if (pkgsToInstall != null) {
                ArrayList<String> namesOrIdsToInstall = new ArrayList<String>();
                HashSet<String> localSnapshotsToUninstall = new HashSet<String>();
                HashSet<String> localSnapshotsToReplace = new HashSet<String>();
                cmdOk = this.checkLocalPackagesAndAddLocalFiles(pkgsToInstall, upgradeMode, ignoreMissing, namesOrIdsToInstall, localSnapshotsToUninstall, localSnapshotsToReplace, localSnapshotsToMaybeReplace);
                if (CollectionUtils.isNotEmpty(localSnapshotsToReplace)) {
                    log.info("The following SNAPSHOT package(s) will be replaced in local cache (if available): {}", localSnapshotsToReplace);
                    String initialAccept = this.accept;
                    if ("ask".equalsIgnoreCase(this.accept)) {
                        this.accept = this.readConsole("Do you want to continue (yes/no)? [yes] ", "yes", new Object[0]);
                    }
                    if (!Boolean.parseBoolean(this.accept)) {
                        log.warn("Exit");
                        boolean bl = false;
                        return bl;
                    }
                    this.accept = initialAccept;
                    for (String pkgId : localSnapshotsToUninstall) {
                        LocalPackage uninstalledPkg = this.pkgUninstall(pkgId);
                        if (uninstalledPkg != null) continue;
                        cmdOk = false;
                    }
                    for (String pkgIdOrFileName : localSnapshotsToReplace) {
                        if (this.isLocalPackageFile(pkgIdOrFileName) || this.isRemotePackageId(pkgIdOrFileName)) {
                            LocalPackage addedPkg = this.pkgAdd(pkgIdOrFileName, ignoreMissing);
                            if (addedPkg != null) continue;
                            cmdOk = false;
                            continue;
                        }
                        log.info("The SNAPSHOT package {} is not available remotely, local cache will be used.", (Object)pkgIdOrFileName);
                    }
                }
                if (upgradeMode) {
                    solverUpgrade.addAll(namesOrIdsToInstall);
                } else {
                    solverInstall.addAll(namesOrIdsToInstall);
                }
            }
            if (pkgsToUninstall != null) {
                solverRemove.addAll(pkgsToUninstall);
            }
            if (pkgsToRemove != null) {
                solverRemove.addAll(pkgsToRemove);
            }
            if (!(solverInstall.isEmpty() && solverRemove.isEmpty() && solverUpgrade.isEmpty())) {
                List nonCompliantPkg;
                String requestPlatform = actualTargetPlatform;
                ArrayList<String> requestPackages = new ArrayList<String>();
                requestPackages.addAll(solverInstall);
                requestPackages.addAll(solverRemove);
                requestPackages.addAll(solverUpgrade);
                if (ignoreMissing) {
                    Map knownNames = this.getPackageManager().getAllPackagesByName();
                    ArrayList solverInstallCopy = new ArrayList(solverInstall);
                    Iterator iterator = solverInstallCopy.iterator();
                    while (iterator.hasNext()) {
                        String pkgToInstall = (String)iterator.next();
                        if (knownNames.containsKey(pkgToInstall)) continue;
                        log.warn("Unable to install unknown package: {}", (Object)pkgToInstall);
                        solverInstall.remove(pkgToInstall);
                        requestPackages.remove(pkgToInstall);
                    }
                }
                if (!(nonCompliantPkg = this.getPackageManager().getNonCompliantList(requestPackages, actualTargetPlatform)).isEmpty()) {
                    requestPlatform = null;
                    if ("ask".equalsIgnoreCase(this.relax)) {
                        this.relax = this.readConsole("Package(s) %s not available on platform version %s.\nDo you want to relax the constraint (yes/no)? [no] ", "no", StringUtils.join((Iterable)nonCompliantPkg, (String)", "), actualTargetPlatform);
                    }
                    if (Boolean.parseBoolean(this.relax)) {
                        log.warn("Relax restriction to target platform {} because of package(s) {}", new Supplier[]{() -> actualTargetPlatform, () -> String.join((CharSequence)", ", nonCompliantPkg)});
                    } else if (ignoreMissing) {
                        for (String pkgToInstall : nonCompliantPkg) {
                            log.warn("Unable to install package: {}", (Object)pkgToInstall);
                            solverInstall.remove(pkgToInstall);
                        }
                    } else {
                        throw new PackageException(String.format("Package(s) %s not available on platform version %s (relax is not allowed)", StringUtils.join((Iterable)nonCompliantPkg, (String)", "), actualTargetPlatform));
                    }
                }
                log.debug("solverInstall: {}", new Supplier[]{() -> solverInstall});
                log.debug("solverRemove: {}", new Supplier[]{() -> solverRemove});
                log.debug("solverUpgrade: {}", new Supplier[]{() -> solverUpgrade});
                DependencyResolution resolution = this.getPackageManager().resolveDependencies(solverInstall, solverRemove, solverUpgrade, requestPlatform, this.allowSNAPSHOT, keepExisting);
                log.info((Object)resolution);
                if (resolution.isFailed()) {
                    boolean pkgToInstall = false;
                    return pkgToInstall;
                }
                if (resolution.isEmpty()) {
                    this.pkgRemove(pkgsToRemove);
                    boolean pkgToInstall = cmdOk;
                    return pkgToInstall;
                }
                if ("ask".equalsIgnoreCase(this.accept)) {
                    this.accept = this.readConsole("Do you want to continue (yes/no)? [yes] ", "yes", new Object[0]);
                }
                if (!Boolean.parseBoolean(this.accept)) {
                    log.warn("Exit");
                    boolean pkgToInstall = false;
                    return pkgToInstall;
                }
                LinkedList packageIdsToRemove = new LinkedList(resolution.getOrderedPackageIdsToRemove());
                LinkedList packageIdsToUpgrade = new LinkedList(resolution.getUpgradePackageIds());
                LinkedList<String> packageIdsToInstall = new LinkedList<String>(resolution.getOrderedPackageIdsToInstall());
                LinkedList packagesIdsToReInstall = new LinkedList();
                if (CollectionUtils.containsAny(packageIdsToInstall, localSnapshotsToMaybeReplace)) {
                    for (Object pkgIdObj : CollectionUtils.intersection(packageIdsToInstall, localSnapshotsToMaybeReplace)) {
                        String pkgId = (String)pkgIdObj;
                        LocalPackage addedPkg = this.pkgAdd(pkgId, ignoreMissing);
                        if (addedPkg != null) continue;
                        cmdOk = false;
                    }
                }
                if (!this.downloadPackages(resolution.getDownloadPackageIds())) {
                    log.error("Aborting packages change request");
                    boolean bl = false;
                    return bl;
                }
                if (!packageIdsToUpgrade.isEmpty()) {
                    packageIdsToRemove.addAll(resolution.getLocalPackagesToUpgrade().keySet());
                    DependencyResolution uninstallResolution = this.getPackageManager().resolveDependencies(null, packageIdsToRemove, null, requestPlatform, this.allowSNAPSHOT, keepExisting, true);
                    log.debug("Sub-resolution (uninstall) {}", (Object)uninstallResolution);
                    if (uninstallResolution.isFailed()) {
                        boolean pkgIdObj = false;
                        return pkgIdObj;
                    }
                    LinkedList newPackageIdsToRemove = new LinkedList(uninstallResolution.getOrderedPackageIdsToRemove());
                    packagesIdsToReInstall = new LinkedList(newPackageIdsToRemove);
                    packagesIdsToReInstall.removeAll(packageIdsToRemove);
                    packagesIdsToReInstall.removeAll(packageIdsToUpgrade);
                    packageIdsToRemove = newPackageIdsToRemove;
                }
                log.debug("Uninstalling: {}", packageIdsToRemove);
                while (!packageIdsToRemove.isEmpty()) {
                    String pkgId = (String)packageIdsToRemove.poll();
                    if (this.pkgUninstall(pkgId) == null) {
                        log.error("Unable to uninstall {}", (Object)pkgId);
                        boolean bl = false;
                        return bl;
                    }
                    if (!this.isRestartRequired()) continue;
                    packageIdsToRemove.forEach(pkg -> this.persistCommand("uninstall " + pkg));
                    packageIdsToInstall.forEach(pkg -> this.persistCommand("install " + pkg));
                    throw new LauncherRestartException();
                }
                if (!packagesIdsToReInstall.isEmpty()) {
                    packageIdsToInstall.addAll(packagesIdsToReInstall);
                    DependencyResolution installResolution = this.getPackageManager().resolveDependencies(packageIdsToInstall, null, null, requestPlatform, this.allowSNAPSHOT, keepExisting, true);
                    log.debug("Sub-resolution (install) {}", (Object)installResolution);
                    if (installResolution.isFailed()) {
                        boolean bl = false;
                        return bl;
                    }
                    packageIdsToInstall = new LinkedList(installResolution.getOrderedPackageIdsToInstall());
                }
                if (!this.pkgInstall(packageIdsToInstall, ignoreMissing)) {
                    boolean bl = false;
                    return bl;
                }
                this.pkgRemove(pkgsToRemove);
            }
            boolean bl = cmdOk;
            return bl;
        }
        catch (PackageException e) {
            log.error((Object)e);
            log.debug((Object)e, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.targetPlatform = actualTargetPlatform;
        }
    }

    private boolean checkLocalPackagesAndAddLocalFiles(List<String> pkgsToInstall, boolean upgradeMode, boolean ignoreMissing, List<String> namesOrIdsToInstall, Set<String> localSnapshotsToUninstall, Set<String> localSnapshotsToReplace, Set<String> localSnapshotsToMaybeReplace) throws PackageException {
        boolean cmdOk = true;
        Iterator<String> iterator = pkgsToInstall.iterator();
        while (iterator.hasNext()) {
            String pkgToInstall;
            String nameOrIdToInstall = pkgToInstall = iterator.next();
            if (!upgradeMode) {
                LocalPackage addedPkg;
                LocalPackage localPackage;
                boolean isLocalPackageFile = this.isLocalPackageFile(pkgToInstall);
                if (isLocalPackageFile) {
                    nameOrIdToInstall = this.getLocalPackageFileId(this.getLocalPackageFile(pkgToInstall));
                }
                if ((localPackage = this.getInstalledPackageByName(nameOrIdToInstall)) != null) {
                    nameOrIdToInstall = localPackage.getId();
                } else if (this.isLocalPackageId(nameOrIdToInstall)) {
                    localPackage = this.getLocalPackage(nameOrIdToInstall);
                } else {
                    LocalPackage potentialMatchingPackage = this.getLocalPackage(nameOrIdToInstall);
                    if (potentialMatchingPackage != null && potentialMatchingPackage.getVersion().isSnapshot()) {
                        localSnapshotsToMaybeReplace.add(potentialMatchingPackage.getId());
                    }
                }
                if (localPackage == null && isLocalPackageFile && (addedPkg = this.pkgAdd(pkgToInstall, ignoreMissing)) == null) {
                    cmdOk = false;
                }
                if (localPackage != null && localPackage.getVersion().isSnapshot()) {
                    if (localPackage.getPackageState().isInstalled()) {
                        localSnapshotsToUninstall.add(nameOrIdToInstall);
                    }
                    String pkgToAdd = isLocalPackageFile ? pkgToInstall : localPackage.getId();
                    localSnapshotsToReplace.add(pkgToAdd);
                }
            }
            namesOrIdsToInstall.add(nameOrIdToInstall);
        }
        return cmdOk;
    }

    public boolean pkgSet(List<String> pkgList, boolean ignoreMissing) {
        boolean cmdOK = this.pkgInstall(pkgList, ignoreMissing);
        List installedPkgs = this.getPackageManager().listInstalledPackages();
        ArrayList<String> pkgsToUninstall = new ArrayList<String>();
        for (DownloadablePackage pkg : installedPkgs) {
            if (pkgList.contains(pkg.getName()) || pkgList.contains(pkg.getId())) continue;
            pkgsToUninstall.add(pkg.getId());
        }
        if (!pkgsToUninstall.isEmpty()) {
            cmdOK = cmdOK && this.pkgUninstall(pkgsToUninstall);
        }
        return cmdOK;
    }

    protected String readConsole(String message, String defaultValue, Object ... objects) {
        String answer;
        Console console = System.console();
        if (console == null || StringUtils.isEmpty((CharSequence)(answer = console.readLine(message, objects)))) {
            answer = defaultValue;
        }
        answer = answer.trim().toLowerCase();
        return ConnectBroker.parseAnswer(answer);
    }

    public static String parseAnswer(String answer) {
        if ("ask".equalsIgnoreCase(answer)) {
            return "ask";
        }
        if ("false".equalsIgnoreCase(answer)) {
            return "false";
        }
        for (String positive : POSITIVE_ANSWERS) {
            if (!positive.equalsIgnoreCase(answer)) continue;
            return "true";
        }
        return "false";
    }

    public boolean pkgHotfix() {
        List lastHotfixes = this.getPackageManager().listLastHotfixes(this.targetPlatform, this.allowSNAPSHOT);
        return this.pkgRequest(null, lastHotfixes, null, null, true, false);
    }

    public boolean pkgUpgrade() {
        List upgradeNames = this.getPackageManager().listInstalledPackagesNames(null);
        return this.pkgRequest(null, upgradeNames, null, null, true, false, true);
    }

    public void setRelax(String relaxValue) {
        if (relaxValue != null) {
            this.relax = ConnectBroker.parseAnswer(relaxValue);
        }
    }

    public void setAccept(String acceptValue) {
        if (acceptValue != null) {
            this.accept = ConnectBroker.parseAnswer(acceptValue);
            if ("ask".equals(this.accept) || "true".equals(this.accept)) {
                this.setRelax(acceptValue);
            }
        }
    }

    private PackageInfo newPackageInfo(CommandInfo cmdInfo, Package pkg) {
        PackageInfo packageInfo = new PackageInfo(pkg);
        cmdInfo.packages.add(packageInfo);
        return packageInfo;
    }

    public boolean pkgShow(List<String> packages) {
        boolean cmdOk = true;
        if (packages == null || packages.isEmpty()) {
            return cmdOk;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("****************************************");
        for (String pkgId : packages) {
            CommandInfo cmdInfo = this.cset.newCommandInfo("show");
            cmdInfo.param = pkgId;
            try {
                Package pkg = this.findPackage(pkgId);
                PackageInfo packageInfo = this.newPackageInfo(cmdInfo, pkg);
                sb.append("\nPackage: ").append(packageInfo.id);
                sb.append("\nState: ").append(packageInfo.state);
                if (pkg instanceof DownloadablePackage) {
                    sb.append(" " + this.getPrivateOrSubscriptionTag((DownloadablePackage)pkg));
                }
                sb.append("\nVersion: ").append(packageInfo.version);
                sb.append("\nName: ").append(packageInfo.name);
                sb.append("\nType: ").append(packageInfo.type);
                sb.append("\nTarget platforms: ").append(ArrayUtils.toString((Object)packageInfo.targetPlatforms));
                this.appendIfNotEmpty(sb, "\nVendor: ", packageInfo.vendor);
                sb.append("\nSupports hot-reload: ").append(packageInfo.supportsHotReload);
                this.appendIfNotEmpty(sb, "\nProvides: ", packageInfo.provides);
                this.appendIfNotEmpty(sb, "\nDepends: ", packageInfo.dependencies);
                this.appendIfNotEmpty(sb, "\nConflicts: ", packageInfo.conflicts);
                this.appendIfNotEmpty(sb, "\nTitle: ", packageInfo.title);
                this.appendIfNotEmpty(sb, "\nDescription: ", packageInfo.description);
                this.appendIfNotEmpty(sb, "\nLicense: ", packageInfo.licenseType);
                this.appendIfNotEmpty(sb, "\nLicense URL: ", packageInfo.licenseUrl);
                sb.append("\n****************************************");
            }
            catch (PackageException e) {
                cmdOk = false;
                cmdInfo.exitCode = 1;
                cmdInfo.newMessage((Exception)((Object)e));
            }
        }
        log.info(sb::toString);
        return cmdOk;
    }

    private void appendIfNotEmpty(StringBuilder sb, String label, Object[] array) {
        if (ArrayUtils.isNotEmpty((Object[])array)) {
            sb.append(label).append(ArrayUtils.toString((Object)array));
        }
    }

    private void appendIfNotEmpty(StringBuilder sb, String label, String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            sb.append(label).append(value);
        }
    }

    protected Package findPackage(String pkg) throws PackageException {
        File localPackageFile = this.getLocalPackageFile(pkg);
        if (localPackageFile != null) {
            return this.service.loadPackageFromZip(localPackageFile);
        }
        LocalPackage localPackage = this.getLocalPackage(pkg);
        if (localPackage != null) {
            return localPackage;
        }
        String pkgId = this.getRemotePackageId(pkg);
        if (pkgId != null) {
            return this.getPackageManager().findPackageById(pkgId);
        }
        throw new PackageException("Could not find a remote or local (relative to current directory or to NUXEO_HOME) package with name or ID " + pkg);
    }

    public void setAllowSNAPSHOT(boolean allow) {
        CUDFHelper.defaultAllowSNAPSHOT = allow;
        this.allowSNAPSHOT = allow;
    }
}

