/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.mongodb.kv;

import com.mongodb.Block;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoWriteException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.kv.AbstractKeyValueStoreProvider;
import org.nuxeo.runtime.kv.KeyValueStoreDescriptor;
import org.nuxeo.runtime.mongodb.MongoDBConnectionService;

public class MongoDBKeyValueStore
extends AbstractKeyValueStoreProvider {
    private static final Log log = LogFactory.getLog(MongoDBKeyValueStore.class);
    public static final String KEYVALUE_CONNECTION_ID = "keyvalue";
    public static final String COLLECTION_PROP = "collection";
    public static final String COLLECTION_DEFAULT = "kv";
    public static final String ID_KEY = "_id";
    public static final String VALUE_KEY = "v";
    public static final String TTL_KEY = "ttl";
    public static final Double ONE = 1.0;
    protected MongoCollection<Document> coll;

    public void initialize(KeyValueStoreDescriptor descriptor) {
        super.initialize(descriptor);
        Map properties = descriptor.properties;
        Object collectionName = (String)properties.get(COLLECTION_PROP);
        if (StringUtils.isBlank((CharSequence)collectionName)) {
            collectionName = COLLECTION_DEFAULT;
        }
        collectionName = (String)collectionName + "." + this.name;
        MongoDBConnectionService mongoService = (MongoDBConnectionService)Framework.getService(MongoDBConnectionService.class);
        MongoDatabase database = mongoService.getDatabase(KEYVALUE_CONNECTION_ID);
        this.coll = database.getCollection((String)collectionName);
        IndexOptions indexOptions = new IndexOptions().expireAfter(Long.valueOf(0L), TimeUnit.SECONDS);
        this.coll.createIndex((Bson)new Document(TTL_KEY, (Object)ONE), indexOptions);
    }

    public Stream<String> keyStream() {
        return StreamSupport.stream(this.coll.find().projection(Projections.include((String[])new String[]{ID_KEY})).spliterator(), false).map(doc -> doc.getString((Object)ID_KEY));
    }

    public Stream<String> keyStream(String prefix) {
        Document filter = new Document(ID_KEY, (Object)Pattern.compile("^" + Pattern.quote(prefix)));
        return StreamSupport.stream(this.coll.find((Bson)filter).projection(Projections.include((String[])new String[]{ID_KEY})).spliterator(), false).map(doc -> doc.getString((Object)ID_KEY));
    }

    public void close() {
        if (this.coll != null) {
            this.coll = null;
        }
    }

    public void clear() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"MongoDB: CLEAR");
        }
        this.coll.deleteMany((Bson)new Document());
    }

    protected static Object toStorage(byte[] bytes) {
        try {
            return MongoDBKeyValueStore.bytesToString((byte[])bytes);
        }
        catch (CharacterCodingException e) {
            return new Binary(bytes);
        }
    }

    protected byte[] toBytes(Object value) {
        if (value instanceof String) {
            return ((String)value).getBytes(StandardCharsets.UTF_8);
        }
        if (value instanceof Long) {
            return ((Long)value).toString().getBytes(StandardCharsets.UTF_8);
        }
        if (value instanceof Binary) {
            return ((Binary)value).getData();
        }
        return null;
    }

    protected String toString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Long) {
            return ((Long)value).toString();
        }
        if (value instanceof Binary) {
            byte[] bytes = ((Binary)value).getData();
            try {
                return MongoDBKeyValueStore.bytesToString((byte[])bytes);
            }
            catch (CharacterCodingException e) {
                return null;
            }
        }
        return null;
    }

    protected Long toLong(Object value) throws NumberFormatException {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        if (value instanceof Binary) {
            byte[] bytes = ((Binary)value).getData();
            return MongoDBKeyValueStore.bytesToLong((byte[])bytes);
        }
        return null;
    }

    public byte[] get(String key) {
        Object value = this.getObject(key);
        if (value == null) {
            return null;
        }
        byte[] bytes = this.toBytes(value);
        if (bytes != null) {
            return bytes;
        }
        throw new UnsupportedOperationException(value.getClass().getName());
    }

    public String getString(String key) {
        Object value = this.getObject(key);
        if (value == null) {
            return null;
        }
        String stringValue = this.toString(value);
        if (stringValue != null) {
            return stringValue;
        }
        throw new IllegalArgumentException("Value is not a String for key: " + key);
    }

    public Long getLong(String key) throws NumberFormatException {
        Object value = this.getObject(key);
        if (value == null) {
            return null;
        }
        Long longValue = this.toLong(value);
        if (longValue != null) {
            return longValue;
        }
        throw new NumberFormatException("Value is not a Long for key: " + key);
    }

    protected Object getObject(String key) {
        Bson filter = Filters.eq((String)ID_KEY, (Object)key);
        Document doc = (Document)this.coll.find(filter).first();
        if (doc == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("MongoDB: GET " + key + " = null"));
            }
            return null;
        }
        Object value = doc.get((Object)VALUE_KEY);
        if (log.isTraceEnabled()) {
            log.trace((Object)("MongoDB: GET " + key + " = " + value));
        }
        return value;
    }

    public Map<String, byte[]> get(Collection<String> keys) {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>(keys.size());
        Block block = doc -> {
            String key = doc.getString((Object)ID_KEY);
            Object value = doc.get((Object)VALUE_KEY);
            if (value != null) {
                byte[] bytes = this.toBytes(value);
                if (bytes == null) {
                    throw new UnsupportedOperationException(String.format("Value of class %s is not supported for key: %s", value.getClass().getName(), key));
                }
                map.put(key, bytes);
            }
        };
        this.findByKeys(keys, (Block<Document>)block);
        return map;
    }

    public Map<String, String> getStrings(Collection<String> keys) {
        HashMap<String, String> map = new HashMap<String, String>(keys.size());
        Block block = doc -> {
            String key = doc.getString((Object)ID_KEY);
            Object value = doc.get((Object)VALUE_KEY);
            if (value != null) {
                String strValue = this.toString(value);
                if (strValue == null) {
                    throw new IllegalArgumentException("Value is not a String for key: " + key);
                }
                map.put(key, strValue);
            }
        };
        this.findByKeys(keys, (Block<Document>)block);
        return map;
    }

    public Map<String, Long> getLongs(Collection<String> keys) throws NumberFormatException {
        HashMap<String, Long> map = new HashMap<String, Long>(keys.size());
        Block block = doc -> {
            String key = doc.getString((Object)ID_KEY);
            Object value = doc.get((Object)VALUE_KEY);
            if (value != null) {
                Long longValue = this.toLong(value);
                if (longValue == null) {
                    throw new IllegalArgumentException("Value is not a Long for key: " + key);
                }
                map.put(key, longValue);
            }
        };
        this.findByKeys(keys, (Block<Document>)block);
        return map;
    }

    protected void findByKeys(Collection<String> keys, Block<Document> block) {
        this.coll.find(Filters.in((String)ID_KEY, keys)).projection(Projections.include((String[])new String[]{ID_KEY, VALUE_KEY})).forEach(block);
    }

    protected Date getDateFromTTL(long ttl) {
        return new Date(System.currentTimeMillis() + ttl * 1000L);
    }

    public void put(String key, byte[] bytes, long ttl) {
        this.put(key, MongoDBKeyValueStore.toStorage(bytes), ttl);
    }

    public void put(String key, String string) {
        this.put(key, (Object)string, 0L);
    }

    public void put(String key, String string, long ttl) {
        this.put(key, (Object)string, ttl);
    }

    public void put(String key, Long value) {
        this.put(key, (Object)value, 0L);
    }

    public void put(String key, Long value, long ttl) {
        this.put(key, (Object)value, ttl);
    }

    protected void put(String key, Object value, long ttl) {
        Bson filter = Filters.eq((String)ID_KEY, (Object)key);
        if (value == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("MongoDB: DEL " + key));
            }
            this.coll.deleteOne(filter);
        } else {
            Document doc = new Document(VALUE_KEY, value);
            this.addTTL(doc, ttl);
            if (log.isTraceEnabled()) {
                log.trace((Object)("MongoDB: PUT " + key + " = " + value + (String)(ttl == 0L ? "" : " (TTL " + ttl + ")")));
            }
            try {
                this.coll.replaceOne(filter, (Object)doc, new ReplaceOptions().upsert(true));
            }
            catch (MongoWriteException e) {
                if (ErrorCategory.fromErrorCode((int)e.getCode()) != ErrorCategory.DUPLICATE_KEY) {
                    throw e;
                }
                this.coll.replaceOne(filter, (Object)doc, new ReplaceOptions().upsert(true));
            }
        }
    }

    protected void addTTL(Document doc, long ttl) {
        if (ttl != 0L) {
            doc.append(TTL_KEY, (Object)this.getDateFromTTL(ttl));
        }
    }

    public boolean setTTL(String key, long ttl) {
        UpdateResult res;
        Bson filter = Filters.eq((String)ID_KEY, (Object)key);
        Bson update = ttl == 0L ? Updates.unset((String)TTL_KEY) : Updates.set((String)TTL_KEY, (Object)this.getDateFromTTL(ttl));
        if (log.isTraceEnabled()) {
            log.trace((Object)("MongoDB: SETTTL " + key + " = " + ttl));
        }
        return (res = this.coll.updateOne(filter, update)).getModifiedCount() == 1L;
    }

    public boolean compareAndSet(String key, byte[] expected, byte[] value, long ttl) {
        return this.compareAndSet(key, MongoDBKeyValueStore.toStorage(expected), MongoDBKeyValueStore.toStorage(value), ttl);
    }

    public boolean compareAndSet(String key, String expected, String value, long ttl) {
        return this.compareAndSet(key, (Object)expected, (Object)value, ttl);
    }

    protected boolean compareAndSet(String key, Object expected, Object value, long ttl) {
        boolean set;
        Bson filter = Filters.eq((String)ID_KEY, (Object)key);
        if (expected == null && value == null) {
            boolean set2;
            Document doc = (Document)this.coll.find(filter).first();
            boolean bl = set2 = doc == null;
            if (log.isTraceEnabled()) {
                if (set2) {
                    log.trace((Object)("MongoDB: TEST " + key + " = null ? NOP"));
                } else {
                    log.trace((Object)("MongoDB: TEST " + key + " = null ? FAILED"));
                }
            }
            return set2;
        }
        if (expected == null) {
            boolean set3;
            Document doc = new Document(ID_KEY, (Object)key).append(VALUE_KEY, value);
            this.addTTL(doc, ttl);
            try {
                this.coll.insertOne((Object)doc);
                set3 = true;
            }
            catch (MongoWriteException e) {
                if (ErrorCategory.fromErrorCode((int)e.getCode()) != ErrorCategory.DUPLICATE_KEY) {
                    throw e;
                }
                set3 = false;
            }
            if (log.isTraceEnabled()) {
                if (set3) {
                    log.trace((Object)("MongoDB: TEST " + key + " = null ? SET " + value));
                } else {
                    log.trace((Object)("MongoDB: TEST " + key + " = null ? FAILED"));
                }
            }
            return set3;
        }
        if (value == null) {
            boolean set4;
            DeleteResult res = this.coll.deleteOne(filter = Filters.and((Bson[])new Bson[]{filter, Filters.eq((String)VALUE_KEY, (Object)expected)}));
            boolean bl = set4 = res.getDeletedCount() == 1L;
            if (log.isTraceEnabled()) {
                if (set4) {
                    log.trace((Object)("MongoDB: TEST " + key + " = " + expected + " ? DEL"));
                } else {
                    log.trace((Object)("MongoDB: TEST " + key + " = " + expected + " ? FAILED"));
                }
            }
            return set4;
        }
        filter = Filters.and((Bson[])new Bson[]{filter, Filters.eq((String)VALUE_KEY, (Object)expected)});
        Document doc = new Document(VALUE_KEY, value);
        this.addTTL(doc, ttl);
        UpdateResult res = this.coll.replaceOne(filter, (Object)doc);
        boolean bl = set = res.getModifiedCount() == 1L;
        if (log.isTraceEnabled()) {
            if (set) {
                log.trace((Object)("MongoDB: TEST " + key + " = " + expected + " ? SET " + value));
            } else {
                log.trace((Object)("MongoDB: TEST " + key + " = " + expected + " ? FAILED"));
            }
        }
        return set;
    }

    public long addAndGet(String key, long delta) throws NumberFormatException {
        Document result;
        Bson filter = Filters.eq((String)ID_KEY, (Object)key);
        Bson update = Updates.inc((String)VALUE_KEY, (Number)delta);
        try {
            result = (Document)this.coll.findOneAndUpdate(filter, update, new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.AFTER));
        }
        catch (MongoCommandException e) {
            if (!e.getMessage().contains("Cannot apply $inc")) {
                throw new NuxeoException((Throwable)e);
            }
            return this.addAndGetGeneric(key, delta);
        }
        if (result == null) {
            throw new NuxeoException("Unexpected null result, upsert failed for key: " + key);
        }
        return (Long)result.get((Object)VALUE_KEY);
    }

    protected long addAndGetGeneric(String key, long delta) throws NumberFormatException {
        long result;
        Long newValue;
        Object value;
        do {
            if ((value = this.getObject(key)) == null) {
                result = delta;
                continue;
            }
            Long base = this.toLong(value);
            if (base == null) {
                throw new NumberFormatException("Value is not a Long for key: " + key);
            }
            result = base + delta;
        } while (!this.compareAndSet(key, value, newValue = Long.valueOf(result), 0L));
        return result;
    }
}

