/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprTransform;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.graph.NodeTransform;
import org.openjena.atlas.lib.Lib;

public abstract class ExprFunction3
extends ExprFunction {
    protected final Expr expr1;
    protected final Expr expr2;
    protected final Expr expr3;

    protected ExprFunction3(Expr expr1, Expr expr2, Expr expr3, String fName) {
        this(expr1, expr2, expr3, fName, null);
    }

    protected ExprFunction3(Expr expr1, Expr expr2, Expr expr3, String fName, String opSign) {
        super(fName, opSign);
        this.expr1 = expr1;
        this.expr2 = expr2;
        this.expr3 = expr3;
    }

    public Expr getArg1() {
        return this.expr1;
    }

    public Expr getArg2() {
        return this.expr2;
    }

    public Expr getArg3() {
        return this.expr3;
    }

    public Expr getArg(int i) {
        if (i == 1) {
            return this.expr1;
        }
        if (i == 2) {
            return this.expr2;
        }
        if (i == 3) {
            return this.expr3;
        }
        return null;
    }

    public int numArgs() {
        return 3;
    }

    public int hashCode() {
        return this.getFunctionSymbol().hashCode() ^ Lib.hashCodeObject(this.expr1) ^ Lib.hashCodeObject(this.expr2) ^ Lib.hashCodeObject(this.expr3);
    }

    public final NodeValue eval(Binding binding, FunctionEnv env) {
        NodeValue s = this.evalSpecial(binding, env);
        if (s != null) {
            return s;
        }
        NodeValue x = ExprFunction3.eval(binding, env, this.expr1);
        NodeValue y = ExprFunction3.eval(binding, env, this.expr2);
        NodeValue z = ExprFunction3.eval(binding, env, this.expr3);
        return this.eval(x, y, z, env);
    }

    protected NodeValue evalSpecial(Binding binding, FunctionEnv env) {
        return null;
    }

    public NodeValue eval(NodeValue x, NodeValue y, NodeValue z, FunctionEnv env) {
        return this.eval(x, y, z);
    }

    public abstract NodeValue eval(NodeValue var1, NodeValue var2, NodeValue var3);

    public final Expr copySubstitute(Binding binding, boolean foldConstants) {
        Expr e3;
        Expr e1 = this.expr1 == null ? null : this.expr1.copySubstitute(binding, foldConstants);
        Expr e2 = this.expr2 == null ? null : this.expr2.copySubstitute(binding, foldConstants);
        Expr expr = e3 = this.expr3 == null ? null : this.expr3.copySubstitute(binding, foldConstants);
        if (foldConstants) {
            try {
                if (e1 != null && e2 != null && e3 != null && e1.isConstant() && e2.isConstant() && e3.isConstant()) {
                    return this.eval(e1.getConstant(), e2.getConstant(), e3.getConstant());
                }
            }
            catch (ExprEvalException ex) {
                // empty catch block
            }
        }
        return this.copy(e1, e2, e3);
    }

    public final Expr applyNodeTransform(NodeTransform transform) {
        Expr e1 = this.expr1 == null ? null : this.expr1.applyNodeTransform(transform);
        Expr e2 = this.expr2 == null ? null : this.expr2.applyNodeTransform(transform);
        Expr e3 = this.expr3 == null ? null : this.expr3.applyNodeTransform(transform);
        return this.copy(e1, e2, e3);
    }

    public abstract Expr copy(Expr var1, Expr var2, Expr var3);

    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }

    public Expr apply(ExprTransform transform, Expr arg1, Expr arg2, Expr arg3) {
        return transform.transform(this, arg1, arg2, arg3);
    }
}

