/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.serializer;

import com.hp.hpl.jena.sparql.serializer.FormatterBase;
import com.hp.hpl.jena.sparql.serializer.FormatterTemplate;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.syntax.Template;
import org.openjena.atlas.io.IndentedLineBuffer;
import org.openjena.atlas.io.IndentedWriter;

public class FmtTemplate
extends FormatterBase
implements FormatterTemplate {
    static final int INDENT = 2;

    public FmtTemplate(IndentedWriter out, SerializationContext context) {
        super(out, context);
    }

    public static void format(IndentedWriter out, SerializationContext cxt, Template template) {
        FmtTemplate fmt = new FmtTemplate(out, cxt);
        fmt.startVisit();
        fmt.format(template);
        fmt.finishVisit();
    }

    public static String asString(Template template) {
        SerializationContext cxt = new SerializationContext();
        IndentedLineBuffer b = new IndentedLineBuffer();
        FmtTemplate.format(b, cxt, template);
        return b.toString();
    }

    public void format(Template template) {
        this.out.print("{");
        this.out.incIndent(2);
        this.out.pad();
        this.formatTriples(template.getBGP());
        this.out.decIndent(2);
        this.out.print("}");
        this.out.newline();
    }
}

