/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.api.comment;

import java.util.List;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.comment.LinkedDocument;
import org.nuxeo.ecm.platform.audit.api.comment.UIAuditComment;
import org.nuxeo.ecm.platform.util.RepositoryLocation;

public class CommentProcessorHelper {
    protected CoreSession documentManager;

    public CommentProcessorHelper(CoreSession documentManager) {
        this.documentManager = documentManager;
    }

    public void processComments(List<LogEntry> logEntries) {
        if (logEntries == null) {
            return;
        }
        for (LogEntry entry : logEntries) {
            String comment = this.getLogComment(entry);
            LinkedDocument linkedDoc = this.getLogLinkedDocument(entry);
            entry.setPreprocessedComment(new UIAuditComment(comment, linkedDoc));
        }
    }

    public String getLogComment(LogEntry entry) {
        String oldComment = entry.getComment();
        if (oldComment == null) {
            return null;
        }
        String newComment = oldComment;
        boolean targetDocExists = false;
        String[] split = oldComment.split(":");
        if (split.length >= 2) {
            String strDocRef = split[1];
            IdRef docRef = new IdRef(strDocRef);
            targetDocExists = this.documentManager.exists((DocumentRef)docRef);
        }
        if (targetDocExists) {
            String eventId = entry.getEventId();
            if ("documentDuplicated".equals(eventId)) {
                newComment = "audit.duplicated_to";
            } else if ("documentCreatedByCopy".equals(eventId)) {
                newComment = "audit.copied_from";
            } else if ("documentMoved".equals(eventId)) {
                newComment = "audit.moved_from";
            }
        }
        return newComment;
    }

    public LinkedDocument getLogLinkedDocument(LogEntry entry) {
        String oldComment = entry.getComment();
        if (oldComment == null) {
            return null;
        }
        LinkedDocument linkedDoc = null;
        String[] split = oldComment.split(":");
        if (split.length >= 2) {
            String repoName = split[0];
            String strDocRef = split[1];
            if (IdUtils.isValidUUID((String)strDocRef)) {
                IdRef docRef = new IdRef(strDocRef);
                RepositoryLocation repoLoc = new RepositoryLocation(repoName);
                linkedDoc = new LinkedDocument();
                linkedDoc.setDocumentRef((DocumentRef)docRef);
                linkedDoc.setRepository(repoLoc);
                try {
                    DocumentModel targetDoc = this.documentManager.getDocument((DocumentRef)docRef);
                    linkedDoc.setDocument(targetDoc);
                    linkedDoc.setBrokenDocument(false);
                }
                catch (DocumentNotFoundException documentNotFoundException) {
                    // empty catch block
                }
            }
        }
        return linkedDoc;
    }
}

