/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.api.job;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.runtime.api.Framework;

public class JobHistoryHelper {
    public static final String JOB_STARTED_SUFFIX = "Started";
    public static final String JOB_ENDED_SUFFIX = "Ended";
    public static final String JOB_FAILED_SUFFIX = "Failed";
    protected AuditLogger logger;
    protected String jobName;
    protected final String jobStartedEventId;
    protected final String jobEndedEventId;
    protected final String jobFailedEventId;

    public JobHistoryHelper(String jobName) {
        this.jobName = jobName;
        this.jobStartedEventId = jobName + JOB_STARTED_SUFFIX;
        this.jobEndedEventId = jobName + JOB_ENDED_SUFFIX;
        this.jobFailedEventId = jobName + JOB_FAILED_SUFFIX;
    }

    protected LogEntry getNewLogEntry() {
        LogEntry entry = this.getLogger().newLogEntry();
        entry.setCategory(this.jobName);
        entry.setPrincipalName("system");
        entry.setEventDate(new Date());
        return entry;
    }

    protected AuditLogger getLogger() {
        if (this.logger == null) {
            this.logger = (AuditLogger)Framework.getService(AuditLogger.class);
        }
        return this.logger;
    }

    public void logJobStarted() {
        LogEntry entry = this.getNewLogEntry();
        entry.setEventId(this.jobStartedEventId);
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        entries.add(entry);
        this.getLogger().addLogEntries(entries);
    }

    public void logJobEnded() {
        LogEntry entry = this.getNewLogEntry();
        entry.setEventId(this.jobEndedEventId);
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        entries.add(entry);
        this.getLogger().addLogEntries(entries);
    }

    public void logJobFailed(String errMessage) {
        LogEntry entry = this.getNewLogEntry();
        entry.setEventId(this.jobFailedEventId);
        entry.setComment(errMessage);
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        entries.add(entry);
        this.getLogger().addLogEntries(entries);
    }

    protected Date getLastRunWithStatus(String status) {
        AuditReader reader = (AuditReader)Framework.getService(AuditReader.class);
        StringBuilder query = new StringBuilder("from LogEntry log where log.eventId=");
        query.append("'");
        query.append(status);
        query.append("' AND log.category='");
        query.append(this.jobName);
        query.append("'  ORDER BY log.eventDate DESC");
        List<?> result = reader.nativeQuery(query.toString(), 1, 1);
        if (!result.isEmpty()) {
            LogEntry entry = (LogEntry)result.get(0);
            return entry.getEventDate();
        }
        return null;
    }

    public Date getLastSuccessfulRun() {
        return this.getLastRunWithStatus(this.jobEndedEventId);
    }

    public Date getLastFailedRun() {
        return this.getLastRunWithStatus(this.jobFailedEventId);
    }

    public Date getLastStarted() {
        return this.getLastRunWithStatus(this.jobStartedEventId);
    }
}

