/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.flac.FlacStreamReader;
import org.jaudiotagger.audio.flac.FlacTagCreator;
import org.jaudiotagger.audio.flac.FlacTagReader;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlock;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockData;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataApplication;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataCueSheet;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPadding;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataSeekTable;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataStreamInfo;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockHeader;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.flac.FlacTag;

public class FlacTagWriter {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.flac");
    private MetadataBlock streamInfoBlock;
    private List<MetadataBlock> metadataBlockPadding = new ArrayList<MetadataBlock>(1);
    private List<MetadataBlock> metadataBlockApplication = new ArrayList<MetadataBlock>(1);
    private List<MetadataBlock> metadataBlockSeekTable = new ArrayList<MetadataBlock>(1);
    private List<MetadataBlock> metadataBlockCueSheet = new ArrayList<MetadataBlock>(1);
    private FlacTagCreator tc = new FlacTagCreator();
    private FlacTagReader reader = new FlacTagReader();

    public void delete(RandomAccessFile raf, RandomAccessFile tempRaf) throws IOException, CannotWriteException {
        FlacTag emptyTag = new FlacTag(null, new ArrayList<MetadataBlockDataPicture>());
        raf.seek(0L);
        tempRaf.seek(0L);
        this.write(emptyTag, raf, tempRaf);
    }

    public void write(Tag tag, RandomAccessFile raf, RandomAccessFile rafTemp) throws CannotWriteException, IOException {
        logger.info("Writing tag");
        this.streamInfoBlock = null;
        this.metadataBlockPadding.clear();
        this.metadataBlockApplication.clear();
        this.metadataBlockSeekTable.clear();
        this.metadataBlockCueSheet.clear();
        FlacStreamReader flacStream = new FlacStreamReader(raf);
        try {
            flacStream.findStream();
        }
        catch (CannotReadException cre) {
            throw new CannotWriteException(cre.getMessage());
        }
        boolean isLastBlock = false;
        while (!isLastBlock) {
            MetadataBlockHeader mbh = MetadataBlockHeader.readHeader(raf);
            switch (mbh.getBlockType()) {
                case STREAMINFO: {
                    this.streamInfoBlock = new MetadataBlock(mbh, new MetadataBlockDataStreamInfo(mbh, raf));
                    break;
                }
                case VORBIS_COMMENT: 
                case PADDING: 
                case PICTURE: {
                    raf.seek(raf.getFilePointer() + (long)mbh.getDataLength());
                    MetadataBlockData mbd = new MetadataBlockDataPadding(mbh.getDataLength());
                    this.metadataBlockPadding.add(new MetadataBlock(mbh, mbd));
                    break;
                }
                case APPLICATION: {
                    MetadataBlockData mbd = new MetadataBlockDataApplication(mbh, raf);
                    this.metadataBlockApplication.add(new MetadataBlock(mbh, mbd));
                    break;
                }
                case SEEKTABLE: {
                    MetadataBlockData mbd = new MetadataBlockDataSeekTable(mbh, raf);
                    this.metadataBlockSeekTable.add(new MetadataBlock(mbh, mbd));
                    break;
                }
                case CUESHEET: {
                    MetadataBlockData mbd = new MetadataBlockDataCueSheet(mbh, raf);
                    this.metadataBlockCueSheet.add(new MetadataBlock(mbh, mbd));
                    break;
                }
                default: {
                    raf.seek(raf.getFilePointer() + (long)mbh.getDataLength());
                }
            }
            isLastBlock = mbh.isLastBlock();
        }
        int availableRoom = this.computeAvailableRoom();
        int newTagSize = this.tc.convert(tag).limit();
        int neededRoom = newTagSize + this.computeNeededRoom();
        raf.seek(flacStream.getStartOfFlacInFile());
        logger.info("Writing tag available bytes:" + availableRoom + ":needed bytes:" + neededRoom);
        if (availableRoom == neededRoom || availableRoom > neededRoom + 4) {
            raf.seek(flacStream.getStartOfFlacInFile() + 4);
            raf.write(this.streamInfoBlock.getHeader().getBytesWithoutIsLastBlockFlag());
            raf.write(this.streamInfoBlock.getData().getBytes());
            for (MetadataBlock aMetadataBlockApplication : this.metadataBlockApplication) {
                raf.write(aMetadataBlockApplication.getHeader().getBytesWithoutIsLastBlockFlag());
                raf.write(aMetadataBlockApplication.getData().getBytes());
            }
            for (MetadataBlock aMetadataBlockSeekTable : this.metadataBlockSeekTable) {
                raf.write(aMetadataBlockSeekTable.getHeader().getBytesWithoutIsLastBlockFlag());
                raf.write(aMetadataBlockSeekTable.getData().getBytes());
            }
            for (MetadataBlock aMetadataBlockCueSheet : this.metadataBlockCueSheet) {
                raf.write(aMetadataBlockCueSheet.getHeader().getBytesWithoutIsLastBlockFlag());
                raf.write(aMetadataBlockCueSheet.getData().getBytes());
            }
            raf.getChannel().write(this.tc.convert(tag, availableRoom - neededRoom));
        } else {
            int dataStartSize = flacStream.getStartOfFlacInFile() + 4 + 4 + 34;
            raf.seek(0L);
            rafTemp.getChannel().transferFrom(raf.getChannel(), 0L, dataStartSize);
            rafTemp.seek(dataStartSize);
            for (MetadataBlock aMetadataBlockApplication : this.metadataBlockApplication) {
                rafTemp.write(aMetadataBlockApplication.getHeader().getBytesWithoutIsLastBlockFlag());
                rafTemp.write(aMetadataBlockApplication.getData().getBytes());
            }
            for (MetadataBlock aMetadataBlockSeekTable : this.metadataBlockSeekTable) {
                rafTemp.write(aMetadataBlockSeekTable.getHeader().getBytesWithoutIsLastBlockFlag());
                rafTemp.write(aMetadataBlockSeekTable.getData().getBytes());
            }
            for (MetadataBlock aMetadataBlockCueSheet : this.metadataBlockCueSheet) {
                rafTemp.write(aMetadataBlockCueSheet.getHeader().getBytesWithoutIsLastBlockFlag());
                rafTemp.write(aMetadataBlockCueSheet.getData().getBytes());
            }
            rafTemp.write(this.tc.convert(tag, 4000).array());
            raf.seek(dataStartSize + availableRoom);
            rafTemp.getChannel().transferFrom(raf.getChannel(), rafTemp.getChannel().position(), raf.getChannel().size());
        }
    }

    private int computeAvailableRoom() {
        int length = 0;
        for (MetadataBlock aMetadataBlockApplication : this.metadataBlockApplication) {
            length += aMetadataBlockApplication.getLength();
        }
        for (MetadataBlock aMetadataBlockSeekTable : this.metadataBlockSeekTable) {
            length += aMetadataBlockSeekTable.getLength();
        }
        for (MetadataBlock aMetadataBlockCueSheet : this.metadataBlockCueSheet) {
            length += aMetadataBlockCueSheet.getLength();
        }
        for (MetadataBlock aMetadataBlockPadding : this.metadataBlockPadding) {
            length += aMetadataBlockPadding.getLength();
        }
        return length;
    }

    private int computeNeededRoom() {
        int length = 0;
        for (MetadataBlock aMetadataBlockApplication : this.metadataBlockApplication) {
            length += aMetadataBlockApplication.getLength();
        }
        for (MetadataBlock aMetadataBlockSeekTable : this.metadataBlockSeekTable) {
            length += aMetadataBlockSeekTable.getLength();
        }
        for (MetadataBlock aMetadataBlockCueSheet : this.metadataBlockCueSheet) {
            length += aMetadataBlockCueSheet.getLength();
        }
        return length;
    }
}

