/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.bulk.BulkAdminService;
import org.nuxeo.ecm.core.bulk.computation.BulkScrollerComputation;
import org.nuxeo.ecm.core.bulk.computation.BulkStatusComputation;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class BulkServiceProcessor
implements StreamProcessorTopology {
    public Topology getTopology(Map<String, String> options) {
        ArrayList<String> mapping = new ArrayList<String>();
        mapping.add("i1:command");
        List<String> actions = ((BulkAdminService)Framework.getService(BulkAdminService.class)).getActions();
        int i = 1;
        for (String action : actions) {
            mapping.add(String.format("o%s:%s", i, action));
            ++i;
        }
        mapping.add(String.format("o%s:%s", i, "status"));
        ConfigurationService confService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        int scrollBatchSize = confService.getInteger("nuxeo.core.bulk.scroller.scroll.size", 100);
        int scrollKeepAlive = confService.getInteger("nuxeo.core.bulk.scroller.scroll.keepAliveSeconds", 60);
        boolean scrollProduceImmediate = confService.isBooleanTrue("nuxeo.core.bulk.scroller.produceImmediate");
        return Topology.builder().addComputation(() -> new BulkScrollerComputation("scroller", actions.size() + 1, scrollBatchSize, scrollKeepAlive, scrollProduceImmediate), mapping).addComputation(() -> new BulkStatusComputation("status"), Arrays.asList("i1:status", "o1:done")).build();
    }
}

