/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.trash.TrashService;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractBulkComputation;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class TrashAction
implements StreamProcessorTopology {
    public static final String ACTION_NAME = "trash";
    public static final String PARAM_NAME = "value";
    public static final String PROXY_QUERY_TEMPLATE = "SELECT ecm:uuid FROM Document WHERE ecm:isProxy=1 AND ecm:uuid IN ('%s')";
    public static final String SYSPROP_QUERY_TEMPLATE = "SELECT ecm:uuid, ecm:name, ecm:parentId FROM Document WHERE ecm:isProxy=0 AND ecm:isTrashed=%s AND ecm:uuid IN ('%s')";

    public Topology getTopology(Map<String, String> options) {
        return Topology.builder().addComputation(TrashComputation::new, Arrays.asList("i1:trash", "o1:status")).build();
    }

    public static class TrashComputation
    extends AbstractBulkComputation {
        private static final Logger log = LogManager.getLogger(TrashComputation.class);

        public TrashComputation() {
            super(TrashAction.ACTION_NAME);
        }

        @Override
        protected void compute(CoreSession session, List<String> ids, Map<String, Serializable> properties) {
            Boolean trashValue = (Boolean)properties.get(TrashAction.PARAM_NAME);
            if (trashValue.booleanValue()) {
                this.removeProxies(session, ids);
            }
            this.setSystemProperty(session, ids, trashValue);
        }

        protected void removeProxies(CoreSession session, List<String> ids) {
            HashSet<IdRef> proxies = new HashSet<IdRef>();
            String query = String.format(TrashAction.PROXY_QUERY_TEMPLATE, String.join((CharSequence)"', '", ids));
            try (IterableQueryResult res = session.queryAndFetch(query, "NXQL", new Object[0]);){
                for (Map map : res) {
                    proxies.add(new IdRef((String)map.get("ecm:uuid")));
                }
            }
            session.removeDocuments(proxies.toArray(new DocumentRef[0]));
            try {
                session.save();
            }
            catch (PropertyException e) {
                log.warn("Cannot save session", (Throwable)e);
            }
        }

        public void setSystemProperty(CoreSession session, List<String> ids, Boolean value) {
            ArrayList<DocumentRef> updatedRefs = new ArrayList<DocumentRef>(ids.size());
            String query = String.format(TrashAction.SYSPROP_QUERY_TEMPLATE, value != false ? "0" : "1", String.join((CharSequence)"', '", ids));
            try (IterableQueryResult res = session.queryAndFetch(query, "NXQL", new Object[0]);){
                TrashService trashService = (TrashService)Framework.getService(TrashService.class);
                for (Map map : res) {
                    IdRef ref = new IdRef((String)map.get("ecm:uuid"));
                    try {
                        session.setDocumentSystemProp((DocumentRef)ref, "isTrashed", (Serializable)value);
                        String docName = (String)map.get("ecm:name");
                        if (!value.booleanValue() && trashService.isMangledName(docName)) {
                            IdRef parentRef = new IdRef((String)map.get("ecm:parentId"));
                            session.move((DocumentRef)ref, (DocumentRef)parentRef, trashService.unmangleName(session, (DocumentRef)parentRef, docName));
                        }
                        updatedRefs.add((DocumentRef)ref);
                    }
                    catch (NuxeoException e) {
                        log.warn("Cannot set system property: isTrashed on: " + ref.toString(), (Throwable)e);
                    }
                }
            }
            try {
                session.save();
                if (!updatedRefs.isEmpty()) {
                    this.fireEvent(session, value != false ? "documentTrashed" : "documentUntrashed", updatedRefs);
                }
            }
            catch (PropertyException e) {
                log.warn("Cannot save session", (Throwable)e);
            }
        }

        protected void fireEvent(CoreSession session, String eventId, Collection<DocumentRef> refs) {
            EventService eventService = (EventService)Framework.getService(EventService.class);
            DocumentModelList docs = session.getDocuments(refs.toArray(new DocumentRef[0]));
            docs.forEach(d -> {
                DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), d);
                ctx.setProperty("repositoryName", (Serializable)((Object)session.getRepositoryName()));
                ctx.setCategory("eventDocumentCategory");
                Event event = ctx.newEvent(eventId);
                event.setImmediate(false);
                event.setInline(false);
                eventService.fireEvent(event);
            });
        }
    }
}

