/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.action.computation;

import java.io.IOException;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.bulk.BulkCodecs;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractTransientBlobComputation;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.ecm.core.bulk.message.DataBucket;
import org.nuxeo.ecm.core.utils.BlobUtils;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.api.Framework;

public class ZipBlob
extends AbstractTransientBlobComputation {
    private static final Logger log = LogManager.getLogger(ZipBlob.class);
    public static final String NAME = "zipBlob";
    public static final String ZIP_PARAMETER = "zip";

    public ZipBlob() {
        super(NAME);
    }

    public void processRecord(ComputationContext context, String inputStreamName, Record record) {
        Codec<DataBucket> codec = BulkCodecs.getDataBucketCodec();
        DataBucket in = (DataBucket)codec.decode(record.getData());
        String storeName = ((BulkStatus)((BulkService)Framework.getService(BulkService.class)).getStatus((Serializable)((Object)in.getCommandId()))).getAction();
        Blob blob = this.getBlob(in.getDataAsString(), storeName);
        try {
            blob = BlobUtils.zip((Blob)blob, (String)(blob.getFilename() + ".zip"));
        }
        catch (IOException e) {
            log.error("Unable to zip blob", (Throwable)e);
        }
        this.storeBlob(blob, in.getCommandId(), storeName);
        DataBucket out = new DataBucket(in.getCommandId(), in.getCount(), this.getTransientStoreKey(in.getCommandId()));
        context.produceRecord("o1", Record.of((String)in.getCommandId(), (byte[])codec.encode((Object)out)));
        context.askForCheckpoint();
    }
}

