/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.jmx;

import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.jmx.JmxReporter;
import io.dropwizard.metrics5.jmx.ObjectNameFactory;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultObjectNameFactory
implements ObjectNameFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxReporter.class);

    @Override
    public ObjectName createName(String type, String domain, MetricName name) {
        try {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("name", name.getKey());
            properties.put("type", type);
            properties.putAll(name.getTags());
            ObjectName objectName = new ObjectName(domain, properties);
            if (objectName.isDomainPattern()) {
                domain = ObjectName.quote(domain);
            }
            if (objectName.isPropertyValuePattern("name")) {
                properties.put("name", ObjectName.quote(name.getKey()));
            }
            if (objectName.isPropertyValuePattern("type")) {
                properties.put("type", ObjectName.quote(type));
            }
            objectName = new ObjectName(domain, properties);
            return objectName;
        }
        catch (MalformedObjectNameException e) {
            try {
                return new ObjectName(domain, "name", ObjectName.quote(name.getKey()));
            }
            catch (MalformedObjectNameException e1) {
                LOGGER.warn("Unable to register {} {}", new Object[]{type, name, e1});
                throw new RuntimeException(e1);
            }
        }
    }
}

