/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.dbs.DBSConnection;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryBase;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;

public abstract class DBSConnectionBase
implements DBSConnection {
    protected final DBSRepositoryBase repository;

    public DBSConnectionBase(DBSRepositoryBase repository) {
        this.repository = repository;
    }

    @Override
    public String getRootId() {
        switch (this.repository.getIdType()) {
            case varchar: 
            case uuid: {
                return "00000000-0000-0000-0000-000000000000";
            }
            case sequence: {
                return "0";
            }
            case sequenceHexRandomized: {
                return "0000000000000000";
            }
        }
        throw new UnsupportedOperationException();
    }

    public void initRoot() {
        State state = new State();
        state.put("ecm:id", (Serializable)((Object)this.getRootId()));
        state.put("ecm:name", (Serializable)((Object)""));
        state.put("ecm:primaryType", (Serializable)((Object)"Root"));
        state.put("ecm:acp", DBSSession.acpToMem((ACP)this.getRootACP()));
        this.createState(state);
    }

    protected ACPImpl getRootACP() {
        ACLImpl acl = new ACLImpl();
        acl.add(new ACE("administrators", "Everything", true));
        acl.add(new ACE("Administrator", "Everything", true));
        acl.add(new ACE("members", "Read", true));
        ACPImpl acp = new ACPImpl();
        acp.addACL((ACL)acl);
        return acp;
    }
}

