/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.BatchFinderWork;
import org.nuxeo.ecm.core.BatchProcessorWork;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.ScrollResult;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.core.api.model.DeltaLong;
import org.nuxeo.ecm.core.api.repository.FulltextConfiguration;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.model.LockManager;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.ecm.core.storage.BaseDocument;
import org.nuxeo.ecm.core.storage.FulltextExtractorWork;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.StateHelper;
import org.nuxeo.ecm.core.storage.dbs.DBSConnection;
import org.nuxeo.ecm.core.storage.dbs.DBSDocument;
import org.nuxeo.ecm.core.storage.dbs.DBSDocumentState;
import org.nuxeo.ecm.core.storage.dbs.DBSExpressionEvaluator;
import org.nuxeo.ecm.core.storage.dbs.DBSRepository;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.runtime.api.Framework;

public class DBSTransactionState
implements LockManager,
AutoCloseable {
    private static final Log log = LogFactory.getLog(DBSTransactionState.class);
    private static final String KEY_UNDOLOG_CREATE = "__UNDOLOG_CREATE__\u0000\u0000";
    protected static final Set<String> READ_ACL_RECURSION_KEYS = new HashSet<String>(Arrays.asList("ecm:racl", "ecm:acp", "ecm:isVersion", "ecm:versionSeriesId", "ecm:parentId"));
    public static final String READ_ACL_ASYNC_ENABLED_PROPERTY = "nuxeo.core.readacl.async.enabled";
    public static final String READ_ACL_ASYNC_ENABLED_DEFAULT = "true";
    public static final String READ_ACL_ASYNC_THRESHOLD_PROPERTY = "nuxeo.core.readacl.async.threshold";
    public static final String READ_ACL_ASYNC_THRESHOLD_DEFAULT = "500";
    protected final DBSRepository repository;
    protected final DBSConnection connection;
    protected final DBSSession session;
    protected Map<String, DBSDocumentState> transientStates = new HashMap<String, DBSDocumentState>();
    protected Set<String> transientCreated = new LinkedHashSet<String>();
    protected final Set<Serializable> userChangeIds = new HashSet<Serializable>();
    protected Map<String, State> undoLog;
    protected final Set<String> browsePermissions;

    public DBSTransactionState(DBSRepository repository, DBSSession session) {
        this.repository = repository;
        this.connection = repository.getConnection();
        this.session = session;
        SecurityService securityService = (SecurityService)Framework.getService(SecurityService.class);
        this.browsePermissions = new HashSet<String>(Arrays.asList(securityService.getPermissionsToCheck("Browse")));
    }

    @Override
    public void close() {
        this.connection.close();
    }

    public String getRootId() {
        return this.connection.getRootId();
    }

    protected DBSDocumentState newTransientState(State state) {
        if (state == null) {
            return null;
        }
        String id = (String)((Object)state.get((Object)"ecm:id"));
        if (this.transientStates.containsKey(id)) {
            throw new IllegalStateException("Already transient: " + id);
        }
        DBSDocumentState docState = new DBSDocumentState(state);
        this.transientStates.put(id, docState);
        return docState;
    }

    public DBSDocumentState getStateForUpdate(String id) {
        DBSDocumentState docState = this.transientStates.get(id);
        if (docState != null) {
            return docState;
        }
        State state = this.connection.readState(id);
        return this.newTransientState(state);
    }

    public State getStateForRead(String id) {
        DBSDocumentState docState = this.transientStates.get(id);
        if (docState != null) {
            return docState.getState();
        }
        return this.connection.readState(id);
    }

    public List<DBSDocumentState> getStatesForUpdate(Collection<String> ids) {
        LinkedList<String> idsToFetch = new LinkedList<String>();
        for (String id : ids) {
            DBSDocumentState docState = this.transientStates.get(id);
            if (docState != null) continue;
            idsToFetch.add(id);
        }
        if (!idsToFetch.isEmpty()) {
            List<State> states = this.connection.readStates(idsToFetch);
            for (State state : states) {
                this.newTransientState(state);
            }
        }
        ArrayList<DBSDocumentState> docStates = new ArrayList<DBSDocumentState>(ids.size());
        for (String id : ids) {
            DBSDocumentState docState = this.transientStates.get(id);
            if (docState == null) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Cannot fetch document with id: " + id), new Throwable("debug stack trace"));
                continue;
            }
            docStates.add(docState);
        }
        return docStates;
    }

    public DBSDocumentState getChildState(String parentId, String name) {
        for (DBSDocumentState docState : this.transientStates.values()) {
            if (!parentId.equals(docState.getParentId()) || !name.equals(docState.getName())) continue;
            return docState;
        }
        State state = this.connection.readChildState(parentId, name, Collections.emptySet());
        if (state == null) {
            return null;
        }
        String id = (String)((Object)state.get((Object)"ecm:id"));
        if (this.transientStates.containsKey(id)) {
            return null;
        }
        return this.newTransientState(state);
    }

    public boolean hasChild(String parentId, String name) {
        for (DBSDocumentState docState : this.transientStates.values()) {
            if (!parentId.equals(docState.getParentId()) || !name.equals(docState.getName())) continue;
            return true;
        }
        return this.connection.hasChild(parentId, name, Collections.emptySet());
    }

    public List<DBSDocumentState> getChildrenStates(String parentId) {
        return this.getChildrenStates(parentId, false, false);
    }

    public List<DBSDocumentState> getChildrenStates(String parentId, boolean excludeSpecialChildren, boolean excludeRegularChildren) {
        List<State> states;
        LinkedList<DBSDocumentState> docStates = new LinkedList<DBSDocumentState>();
        HashSet<String> seen = new HashSet<String>();
        Set specialChildrenTypes = ((SchemaManager)Framework.getService(SchemaManager.class)).getSpecialDocumentTypes();
        boolean excludeChildren = excludeSpecialChildren || excludeRegularChildren;
        for (DBSDocumentState docState : this.transientStates.values()) {
            if (!parentId.equals(docState.getParentId())) continue;
            if (excludeChildren) {
                boolean specialChild = specialChildrenTypes.contains(docState.getPrimaryType());
                if (excludeSpecialChildren && specialChild || excludeRegularChildren && !specialChild) continue;
            }
            docStates.add(docState);
            seen.add(docState.getId());
        }
        if (!excludeChildren) {
            states = this.connection.queryKeyValue("ecm:parentId", parentId, seen);
        } else {
            DBSConnection.DBSQueryOperator operator = excludeSpecialChildren ? DBSConnection.DBSQueryOperator.NOT_IN : DBSConnection.DBSQueryOperator.IN;
            states = this.connection.queryKeyValueWithOperator("ecm:parentId", parentId, "ecm:primaryType", operator, specialChildrenTypes, seen);
        }
        for (State state : states) {
            String id = (String)((Object)state.get((Object)"ecm:id"));
            if (this.transientStates.containsKey(id)) continue;
            docStates.add(this.newTransientState(state));
        }
        return docStates;
    }

    public List<String> getChildrenIds(String parentId) {
        return this.getChildrenIds(parentId, false, false);
    }

    public List<String> getChildrenIds(String parentId, boolean excludeSpecialChildren, boolean excludeRegularChildren) {
        List<State> states;
        ArrayList<String> children = new ArrayList<String>();
        HashSet<String> seen = new HashSet<String>();
        Set specialChildrenTypes = ((SchemaManager)Framework.getService(SchemaManager.class)).getSpecialDocumentTypes();
        boolean excludeChildren = excludeSpecialChildren || excludeRegularChildren;
        for (DBSDocumentState docState : this.transientStates.values()) {
            String id = docState.getId();
            if (!parentId.equals(docState.getParentId())) continue;
            if (excludeChildren) {
                boolean specialChild = specialChildrenTypes.contains(docState.getPrimaryType());
                if (excludeSpecialChildren && specialChild || excludeRegularChildren && !specialChild) continue;
            }
            seen.add(id);
            children.add(id);
        }
        if (!excludeChildren) {
            states = this.connection.queryKeyValue("ecm:parentId", parentId, seen);
        } else {
            DBSConnection.DBSQueryOperator operator = excludeSpecialChildren ? DBSConnection.DBSQueryOperator.NOT_IN : DBSConnection.DBSQueryOperator.IN;
            states = this.connection.queryKeyValueWithOperator("ecm:parentId", parentId, "ecm:primaryType", operator, specialChildrenTypes, seen);
        }
        for (State state : states) {
            String id = (String)((Object)state.get((Object)"ecm:id"));
            if (this.transientStates.containsKey(id)) continue;
            children.add(id);
        }
        return new ArrayList<String>(children);
    }

    public boolean hasChildren(String parentId) {
        for (DBSDocumentState docState : this.transientStates.values()) {
            if (!parentId.equals(docState.getParentId())) continue;
            return true;
        }
        return this.connection.queryKeyValuePresence("ecm:parentId", parentId, Collections.emptySet());
    }

    public DBSDocumentState createChild(String id, String parentId, String name, Long pos, String typeName) {
        if (id == null) {
            id = this.connection.generateNewId();
        }
        if (this.transientStates.containsKey(id)) {
            throw new ConcurrentUpdateException(id);
        }
        this.transientCreated.add(id);
        DBSDocumentState docState = new DBSDocumentState();
        this.transientStates.put(id, docState);
        docState.put("ecm:id", (Serializable)((Object)id));
        docState.put("ecm:parentId", (Serializable)((Object)parentId));
        docState.put("ecm:ancestorIds", (Serializable)this.getAncestorIds(parentId));
        docState.put("ecm:name", (Serializable)((Object)name));
        docState.put("ecm:pos", pos);
        docState.put("ecm:primaryType", (Serializable)((Object)typeName));
        if (this.repository.isChangeTokenEnabled()) {
            docState.put("ecm:systemChangeToken", DBSDocument.INITIAL_SYS_CHANGE_TOKEN);
        }
        this.updateDocumentReadAcls(id);
        return docState;
    }

    protected Object[] getAncestorIds(String id) {
        if (id == null) {
            return null;
        }
        State state = this.getStateForRead(id);
        if (state == null) {
            throw new RuntimeException("No such id: " + id);
        }
        Object[] ancestors = (Object[])state.get((Object)"ecm:ancestorIds");
        if (ancestors == null) {
            return new Object[]{id};
        }
        Object[] newAncestors = new Object[ancestors.length + 1];
        System.arraycopy(ancestors, 0, newAncestors, 0, ancestors.length);
        newAncestors[ancestors.length] = id;
        return newAncestors;
    }

    public DBSDocumentState copy(String id) {
        DBSDocumentState copyState = new DBSDocumentState(this.getStateForRead(id));
        String copyId = this.connection.generateNewId();
        copyState.put("ecm:id", (Serializable)((Object)copyId));
        copyState.put("ecm:proxyIds", null);
        this.transientStates.put(copyId, copyState);
        this.transientCreated.add(copyId);
        return copyState;
    }

    public void updateAncestors(String id, int ndel, Object[] ancestorIds) {
        int nadd = ancestorIds.length;
        HashSet<String> ids = new HashSet<String>();
        ids.add(id);
        try (Stream<State> states = this.getDescendants(id, Collections.emptySet(), 0);){
            states.forEach(state -> ids.add((String)((Object)state.get((Object)"ecm:id"))));
        }
        for (String cid : ids) {
            Object[] newAncestors;
            DBSDocumentState docState = this.getStateForUpdate(cid);
            Object[] ancestors = (Object[])docState.get("ecm:ancestorIds");
            if (ancestors == null) {
                newAncestors = (Object[])ancestorIds.clone();
            } else {
                newAncestors = new Object[ancestors.length - ndel + nadd];
                System.arraycopy(ancestorIds, 0, newAncestors, 0, nadd);
                System.arraycopy(ancestors, ndel, newAncestors, nadd, ancestors.length - ndel);
            }
            docState.put("ecm:ancestorIds", (Serializable)newAncestors);
        }
    }

    protected int getReadAclsAsyncThreshold() {
        boolean enabled = Boolean.parseBoolean(Framework.getProperty((String)READ_ACL_ASYNC_ENABLED_PROPERTY, (String)READ_ACL_ASYNC_ENABLED_DEFAULT));
        if (enabled) {
            return Integer.parseInt(Framework.getProperty((String)READ_ACL_ASYNC_THRESHOLD_PROPERTY, (String)READ_ACL_ASYNC_THRESHOLD_DEFAULT));
        }
        return 0;
    }

    public void updateTreeReadAcls(String id) {
        this.save();
        this.updateDocumentReadAcls(id);
        int limit = this.getReadAclsAsyncThreshold();
        HashSet ids = new HashSet();
        try (Stream<State> states = this.getDescendants(id, Collections.emptySet(), limit);){
            states.forEach(state -> ids.add((String)((Object)state.get((Object)"ecm:id"))));
        }
        if (limit == 0 || ids.size() < limit) {
            ids.forEach(this::updateDocumentReadAcls);
        } else {
            String nxql = String.format("SELECT ecm:uuid FROM Document WHERE ecm:parentId = '%s'", id);
            SystemPrincipal principal = new SystemPrincipal(null);
            QueryFilter queryFilter = new QueryFilter((NuxeoPrincipal)principal, null, null, null, Collections.emptyList(), (long)limit, 0L);
            PartialList<Map<String, Serializable>> pl = this.session.queryProjection(nxql, "NXQL", queryFilter, false, 0L, new Object[0]);
            for (Map map : pl) {
                String childId = (String)map.get("ecm:uuid");
                this.updateDocumentReadAcls(childId);
            }
            nxql = String.format("SELECT ecm:uuid FROM Document WHERE ecm:ancestorId = '%s'", id);
            FindReadAclsWork work = new FindReadAclsWork(this.repository.getName(), nxql, null);
            ((WorkManager)Framework.getService(WorkManager.class)).schedule((Work)work);
        }
    }

    public void updateReadACLs(Collection<String> docIds) {
        docIds.forEach(id -> this.updateDocumentReadAclsNoCache((String)id));
    }

    protected void updateDocumentReadAcls(String id) {
        DBSDocumentState docState = this.getStateForUpdate(id);
        docState.put("ecm:racl", (Serializable)this.getReadACL(docState.getState()));
    }

    protected void updateDocumentReadAclsNoCache(String id) {
        State state = this.connection.readPartialState(id, READ_ACL_RECURSION_KEYS);
        State oldState = new State(1);
        oldState.put("ecm:racl", state.get((Object)"ecm:racl"));
        State newState = new State(1);
        newState.put("ecm:racl", (Serializable)this.getReadACL(state));
        State.StateDiff diff = StateHelper.diff((State)oldState, (State)newState);
        if (!diff.isEmpty()) {
            this.connection.updateState(id, diff, null);
        }
    }

    protected String[] getReadACL(State state) {
        String parentKey;
        String parentId;
        HashSet<String> racls = new HashSet<String>();
        block0: do {
            List aclList;
            if ((aclList = (List)((Object)state.get((Object)"ecm:acp"))) == null) continue;
            for (Serializable aclSer : aclList) {
                State aclMap = (State)aclSer;
                List aceList = (List)((Object)aclMap.get((Object)"acl"));
                for (Serializable aceSer : aceList) {
                    State aceMap = (State)aceSer;
                    String username = (String)((Object)aceMap.get((Object)"user"));
                    String permission = (String)((Object)aceMap.get((Object)"perm"));
                    Boolean granted = (Boolean)aceMap.get((Object)"grant");
                    Long status = (Long)aceMap.get((Object)"status");
                    if (Boolean.TRUE.equals(granted) && this.browsePermissions.contains(permission) && (status == null || status == 1L)) {
                        racls.add(username);
                    }
                    if (!Boolean.FALSE.equals(granted)) continue;
                    if ("Everyone".equals(username)) break block0;
                    racls.add("_UNSUPPORTED_ACL_");
                    break block0;
                }
            }
        } while ((state = (parentId = (String)((Object)state.get((Object)(parentKey = Boolean.TRUE.equals(state.get((Object)"ecm:isVersion")) ? "ecm:versionSeriesId" : "ecm:parentId")))) == null ? null : this.getStateForRead(parentId)) != null);
        ArrayList racl = new ArrayList(racls);
        Collections.sort(racl);
        return racl.toArray(new String[racl.size()]);
    }

    protected Stream<State> getDescendants(String id, Set<String> keys, int limit) {
        return this.connection.getDescendants(id, keys, limit);
    }

    public List<DBSDocumentState> getKeyValuedStates(String key, Object value) {
        LinkedList<DBSDocumentState> docStates = new LinkedList<DBSDocumentState>();
        HashSet<String> seen = new HashSet<String>();
        for (DBSDocumentState docState : this.transientStates.values()) {
            if (!value.equals(docState.get(key))) continue;
            docStates.add(docState);
            seen.add(docState.getId());
        }
        List<State> states = this.connection.queryKeyValue(key, value, seen);
        for (State state : states) {
            docStates.add(this.newTransientState(state));
        }
        return docStates;
    }

    public List<DBSDocumentState> getKeyValuedStates(String key1, Object value1, String key2, Object value2) {
        LinkedList<DBSDocumentState> docStates = new LinkedList<DBSDocumentState>();
        HashSet<String> seen = new HashSet<String>();
        for (DBSDocumentState docState : this.transientStates.values()) {
            seen.add(docState.getId());
            if (!value1.equals(docState.get(key1)) || !value2.equals(docState.get(key2))) continue;
            docStates.add(docState);
        }
        List<State> states = this.connection.queryKeyValue(key1, value1, key2, value2, seen);
        for (State state : states) {
            docStates.add(this.newTransientState(state));
        }
        return docStates;
    }

    public PartialList<Map<String, Serializable>> queryAndFetch(DBSExpressionEvaluator evaluator, OrderByClause orderByClause, boolean distinctDocuments, int limit, int offset, int countUpTo) {
        return this.connection.queryAndFetch(evaluator, orderByClause, distinctDocuments, limit, offset, countUpTo);
    }

    public ScrollResult<String> scroll(DBSExpressionEvaluator evaluator, int batchSize, int keepAliveSeconds) {
        return this.connection.scroll(evaluator, batchSize, keepAliveSeconds);
    }

    public ScrollResult<String> scroll(String scrollId) {
        return this.connection.scroll(scrollId);
    }

    public Lock getLock(String id) {
        return this.connection.getLock(id);
    }

    public Lock setLock(String id, Lock lock) {
        return this.connection.setLock(id, lock);
    }

    public Lock removeLock(String id, String owner) {
        return this.connection.removeLock(id, owner);
    }

    public void removeStates(Set<String> ids) {
        if (this.undoLog != null) {
            for (String id : ids) {
                if (this.undoLog.containsKey(id)) {
                    State oldUndo = this.undoLog.get(id);
                    if (oldUndo == null) {
                        this.undoLog.remove(id);
                        continue;
                    }
                    oldUndo.put(KEY_UNDOLOG_CREATE, (Serializable)Boolean.TRUE);
                    continue;
                }
                State oldState = StateHelper.deepCopy((State)this.getStateForRead(id));
                oldState.put(KEY_UNDOLOG_CREATE, (Serializable)Boolean.TRUE);
                this.undoLog.put(id, oldState);
            }
        }
        for (String id : ids) {
            this.transientStates.remove(id);
        }
        this.connection.deleteStates(ids);
    }

    public void markUserChange(String id) {
        this.userChangeIds.add((Serializable)((Object)id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        this.updateProxies();
        List<Object> works = !this.repository.isFulltextDisabled() ? this.getFulltextWorks() : Collections.emptyList();
        ArrayList<State> statesToCreate = new ArrayList<State>();
        for (String id : this.transientCreated) {
            DBSDocumentState docState = this.transientStates.get(id);
            docState.setNotDirty();
            if (this.undoLog != null) {
                this.undoLog.put(id, null);
            }
            State state = docState.getState();
            state.put("ecm:changeToken", (Serializable)DBSDocument.INITIAL_CHANGE_TOKEN);
            statesToCreate.add(state);
        }
        if (!statesToCreate.isEmpty()) {
            this.connection.createStates(statesToCreate);
        }
        for (DBSDocumentState docState : this.transientStates.values()) {
            State.StateDiff diff;
            String id = docState.getId();
            if (this.transientCreated.contains(id) || (diff = docState.getStateChange()) == null) continue;
            try {
                ChangeTokenUpdater changeTokenUpdater;
                if (this.undoLog != null && !this.undoLog.containsKey(id)) {
                    this.undoLog.put(id, StateHelper.deepCopy((State)docState.getOriginalState()));
                }
                if (this.repository.isChangeTokenEnabled()) {
                    Long base = (Long)docState.get("ecm:systemChangeToken");
                    docState.put("ecm:systemChangeToken", (Serializable)DeltaLong.valueOf((Number)base, (long)1L));
                    diff.put("ecm:systemChangeToken", (Serializable)DeltaLong.valueOf((Number)base, (long)1L));
                    changeTokenUpdater = this.userChangeIds.contains(id) ? new ChangeTokenUpdater(docState) : null;
                } else {
                    changeTokenUpdater = null;
                }
                this.connection.updateState(id, diff, changeTokenUpdater);
            }
            finally {
                docState.setNotDirty();
            }
        }
        this.transientCreated.clear();
        this.userChangeIds.clear();
        this.scheduleWork(works);
    }

    protected void applyUndoLog() {
        HashSet<String> deletes = new HashSet<String>();
        for (Map.Entry<String, State> es : this.undoLog.entrySet()) {
            State.StateDiff diff;
            boolean recreate;
            String id = es.getKey();
            State state = es.getValue();
            if (state == null) {
                deletes.add(id);
                continue;
            }
            boolean bl = recreate = state.remove((Object)KEY_UNDOLOG_CREATE) != null;
            if (recreate) {
                this.connection.createState(state);
                continue;
            }
            State currentState = this.connection.readState(id);
            if (currentState == null || (diff = StateHelper.diff((State)currentState, (State)state)).isEmpty()) continue;
            this.connection.updateState(id, diff, null);
        }
        if (!deletes.isEmpty()) {
            this.connection.deleteStates(deletes);
        }
    }

    protected void updateProxies() {
        for (String id : this.transientCreated) {
            DBSDocumentState docState = this.transientStates.get(id);
            this.updateProxies(docState);
        }
        for (String id : this.transientStates.keySet().toArray(new String[0])) {
            DBSDocumentState docState = this.transientStates.get(id);
            if (this.transientCreated.contains(id) || !docState.isDirty()) continue;
            this.updateProxies(docState);
        }
    }

    protected void updateProxies(DBSDocumentState target) {
        Object[] proxyIds = (Object[])target.get("ecm:proxyIds");
        if (proxyIds != null) {
            for (Object proxyId : proxyIds) {
                try {
                    this.updateProxy(target, (String)proxyId);
                }
                catch (ConcurrentUpdateException e) {
                    e.addInfo("On doc " + target.getId());
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    protected void updateProxy(DBSDocumentState target, String proxyId) {
        DBSDocumentState proxy = this.getStateForUpdate(proxyId);
        if (proxy == null) {
            throw new ConcurrentUpdateException("Proxy " + proxyId + " concurrently deleted");
        }
        SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        for (String key : proxy.getState().keyArray()) {
            if (this.isProxySpecific(key, schemaManager)) continue;
            proxy.put(key, null);
        }
        for (Map.Entry en : target.getState().entrySet()) {
            String key = (String)en.getKey();
            if (this.isProxySpecific(key, schemaManager)) continue;
            proxy.put(key, StateHelper.deepCopy(en.getValue()));
        }
    }

    protected boolean isProxySpecific(String key, SchemaManager schemaManager) {
        switch (key) {
            case "ecm:id": 
            case "ecm:parentId": 
            case "ecm:ancestorIds": 
            case "ecm:name": 
            case "ecm:pos": 
            case "ecm:acp": 
            case "ecm:racl": 
            case "ecm:isProxy": 
            case "ecm:proxyTargetId": 
            case "ecm:proxyVersionSeriesId": 
            case "ecm:isVersion": 
            case "ecm:proxyIds": {
                return true;
            }
        }
        int p = key.indexOf(58);
        if (p == -1) {
            return false;
        }
        String prefix = key.substring(0, p);
        Schema schema = schemaManager.getSchemaFromPrefix(prefix);
        if (schema == null && (schema = schemaManager.getSchema(prefix)) == null) {
            return false;
        }
        return schemaManager.isProxySchema(schema.getName(), null);
    }

    public void begin() {
        if (!this.repository.supportsTransactions()) {
            if (this.undoLog != null) {
                throw new NuxeoException("Transaction already started");
            }
            this.undoLog = new HashMap<String, State>();
        }
        this.connection.begin();
    }

    public void commit() {
        this.save();
        this.clearTransient();
        if (this.undoLog != null) {
            this.undoLog = null;
        }
        this.connection.commit();
    }

    public void rollback() {
        this.clearTransient();
        if (this.undoLog != null) {
            this.applyUndoLog();
            this.undoLog = null;
        }
        this.connection.rollback();
    }

    protected void clearTransient() {
        this.transientStates.clear();
        this.transientCreated.clear();
    }

    protected List<Work> getFulltextWorks() {
        Set<String> docsWithDirtyStrings = new HashSet<String>();
        HashSet<String> docsWithDirtyBinaries = new HashSet<String>();
        this.findDirtyDocuments(docsWithDirtyStrings, docsWithDirtyBinaries);
        if (this.repository.getFulltextConfiguration().fulltextSearchDisabled) {
            docsWithDirtyStrings = Collections.emptySet();
        }
        HashSet<String> dirtyIds = new HashSet<String>();
        dirtyIds.addAll(docsWithDirtyStrings);
        dirtyIds.addAll(docsWithDirtyBinaries);
        if (dirtyIds.isEmpty()) {
            return Collections.emptyList();
        }
        this.markIndexingInProgress(dirtyIds);
        ArrayList<Work> works = new ArrayList<Work>(dirtyIds.size());
        for (String id : dirtyIds) {
            boolean updateSimpleText = docsWithDirtyStrings.contains(id);
            boolean updateBinaryText = docsWithDirtyBinaries.contains(id);
            FulltextExtractorWork work = new FulltextExtractorWork(this.repository.getName(), id, updateSimpleText, updateBinaryText, true);
            works.add((Work)work);
        }
        return works;
    }

    protected void markIndexingInProgress(Set<String> ids) {
        FulltextConfiguration fulltextConfiguration = this.repository.getFulltextConfiguration();
        for (DBSDocumentState docState : this.getStatesForUpdate(ids)) {
            if (!fulltextConfiguration.isFulltextIndexable(docState.getPrimaryType())) continue;
            docState.put("ecm:fulltextJobId", (Serializable)((Object)docState.getId()));
        }
    }

    protected void findDirtyDocuments(Set<String> docsWithDirtyStrings, Set<String> docsWithDirtyBinaries) {
        for (DBSDocumentState docState : this.transientStates.values()) {
            State.StateDiff diff;
            State state;
            State originalState = docState.getOriginalState();
            if (originalState == (state = docState.getState()) || (diff = StateHelper.diff((State)originalState, (State)state)).isEmpty()) continue;
            State.StateDiff rdiff = StateHelper.diff((State)state, (State)originalState);
            HashSet<String> paths = new HashSet<String>();
            DirtyPathsFinder dirtyPathsFinder = new DirtyPathsFinder(paths);
            dirtyPathsFinder.findDirtyPaths(diff);
            dirtyPathsFinder.findDirtyPaths(rdiff);
            FulltextConfiguration fulltextConfiguration = this.repository.getFulltextConfiguration();
            boolean dirtyStrings = false;
            boolean dirtyBinaries = false;
            for (String path : paths) {
                Set indexesBinary;
                Set indexesSimple = (Set)fulltextConfiguration.indexesByPropPathSimple.get(path);
                if (indexesSimple != null && !indexesSimple.isEmpty()) {
                    dirtyStrings = true;
                    if (dirtyBinaries) break;
                }
                if ((indexesBinary = (Set)fulltextConfiguration.indexesByPropPathBinary.get(path)) == null || indexesBinary.isEmpty()) continue;
                dirtyBinaries = true;
                if (!dirtyStrings) continue;
                break;
            }
            if (dirtyStrings) {
                docsWithDirtyStrings.add(docState.getId());
            }
            if (!dirtyBinaries) continue;
            docsWithDirtyBinaries.add(docState.getId());
        }
    }

    protected void scheduleWork(List<Work> works) {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        if (repositoryManager != null && !works.isEmpty()) {
            WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
            for (Work work : works) {
                workManager.schedule(work, WorkManager.Scheduling.IF_NOT_SCHEDULED, true);
            }
        }
    }

    protected static class DirtyPathsFinder {
        protected Set<String> paths;

        public DirtyPathsFinder(Set<String> paths) {
            this.paths = paths;
        }

        public void findDirtyPaths(State.StateDiff value) {
            this.findDirtyPaths((State)value, (String)null);
        }

        protected void findDirtyPaths(Object value, String path) {
            if (value instanceof Object[]) {
                this.findDirtyPaths((Object[])value, path);
            } else if (value instanceof List) {
                this.findDirtyPaths((List)value, path);
            } else if (value instanceof State.ListDiff) {
                this.findDirtyPaths((State.ListDiff)value, path);
            } else if (value instanceof State) {
                this.findDirtyPaths((State)value, path);
            } else {
                this.paths.add(path);
            }
        }

        protected void findDirtyPaths(Object[] value, String path) {
            String newPath = path + "/*";
            for (Object v : value) {
                this.findDirtyPaths(v, newPath);
            }
        }

        protected void findDirtyPaths(List<?> value, String path) {
            String newPath = path + "/*";
            for (Object v : value) {
                this.findDirtyPaths(v, newPath);
            }
        }

        protected void findDirtyPaths(State.ListDiff value, String path) {
            String newPath = path;
            if (value.diff != null) {
                this.findDirtyPaths(value.diff, newPath);
            }
            if (value.rpush != null) {
                this.findDirtyPaths(value.rpush, newPath);
            }
        }

        protected void findDirtyPaths(State value, String path) {
            for (Map.Entry es : value.entrySet()) {
                String key = (String)es.getKey();
                Serializable v = (Serializable)es.getValue();
                String newPath = path == null ? key : path + "/" + key;
                this.findDirtyPaths(v, newPath);
            }
        }
    }

    public static class ChangeTokenUpdater {
        protected final DBSDocumentState docState;
        protected Long oldToken;

        public ChangeTokenUpdater(DBSDocumentState docState) {
            this.docState = docState;
            this.oldToken = (Long)docState.getOriginalState().get((Object)"ecm:changeToken");
        }

        public Map<String, Serializable> getConditions() {
            return Map.of("ecm:changeToken", this.oldToken);
        }

        public Map<String, Serializable> getUpdates() {
            Long newToken = this.oldToken == null ? DBSDocument.INITIAL_CHANGE_TOKEN : BaseDocument.updateChangeToken((Long)this.oldToken);
            this.docState.getState().put("ecm:changeToken", (Serializable)newToken);
            this.oldToken = newToken;
            return Map.of("ecm:changeToken", newToken);
        }
    }

    public static class UpdateReadAclsWork
    extends BatchProcessorWork {
        private static final long serialVersionUID = 1L;

        public UpdateReadAclsWork(String repositoryName, List<String> docIds, String originatingUsername) {
            super(repositoryName, docIds, originatingUsername);
        }

        public String getTitle() {
            return "Update Read ACLs";
        }

        public String getCategory() {
            return "security";
        }

        public int getBatchSize() {
            return 50;
        }

        public void processBatch(List<String> docIds) {
            this.session.updateReadACLs(docIds);
        }
    }

    public static class FindReadAclsWork
    extends BatchFinderWork {
        private static final long serialVersionUID = 1L;

        public FindReadAclsWork(String repositoryName, String nxql, String originatingUsername) {
            super(repositoryName, nxql, originatingUsername);
        }

        public String getTitle() {
            return "Find descendants for Read ACLs";
        }

        public String getCategory() {
            return "security";
        }

        public int getBatchSize() {
            return 500;
        }

        public Work getBatchProcessorWork(List<String> docIds) {
            return new UpdateReadAclsWork(this.repositoryName, docIds, this.getOriginatingUsername());
        }
    }
}

