/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.util.Collections;
import java.util.Map;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.bulk.TransportBulkAction;
import org.elasticsearch.action.bulk.TransportSingleItemBulkWriteAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.single.instance.TransportInstanceSingleOperationAction;
import org.elasticsearch.action.update.UpdateHelper;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.PlainShardIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.NotSerializableExceptionWrapper;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportUpdateAction
extends TransportInstanceSingleOperationAction<UpdateRequest, UpdateResponse> {
    private final TransportBulkAction bulkAction;
    private final AutoCreateIndex autoCreateIndex;
    private final TransportCreateIndexAction createIndexAction;
    private final UpdateHelper updateHelper;
    private final IndicesService indicesService;

    @Inject
    public TransportUpdateAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, TransportBulkAction bulkAction, TransportCreateIndexAction createIndexAction, UpdateHelper updateHelper, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService, AutoCreateIndex autoCreateIndex) {
        super(settings, "indices:data/write/update", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, UpdateRequest::new);
        this.bulkAction = bulkAction;
        this.createIndexAction = createIndexAction;
        this.updateHelper = updateHelper;
        this.indicesService = indicesService;
        this.autoCreateIndex = autoCreateIndex;
    }

    @Override
    protected String executor() {
        return "index";
    }

    @Override
    protected UpdateResponse newResponse() {
        return new UpdateResponse();
    }

    @Override
    protected boolean retryOnFailure(Exception e) {
        return TransportActions.isShardNotAvailableException(e);
    }

    @Override
    protected void resolveRequest(ClusterState state, UpdateRequest request) {
        TransportUpdateAction.resolveAndValidateRouting(state.metaData(), request.concreteIndex(), request);
    }

    public static void resolveAndValidateRouting(MetaData metaData, String concreteIndex, UpdateRequest request) {
        request.routing(metaData.resolveWriteIndexRouting(request.parent(), request.routing(), request.index()));
        if (request.routing() == null && metaData.routingRequired(concreteIndex, request.type())) {
            throw new RoutingMissingException(concreteIndex, request.type(), request.id());
        }
    }

    @Override
    protected void doExecute(final UpdateRequest request, final ActionListener<UpdateResponse> listener) {
        if (this.autoCreateIndex.shouldAutoCreate(request.index(), this.clusterService.state())) {
            this.createIndexAction.execute((CreateIndexRequest)new CreateIndexRequest().index(request.index()).cause("auto(update api)").masterNodeTimeout(request.timeout()), new ActionListener<CreateIndexResponse>(){

                @Override
                public void onResponse(CreateIndexResponse result) {
                    TransportUpdateAction.this.innerExecute(request, listener);
                }

                @Override
                public void onFailure(Exception e) {
                    if (ExceptionsHelper.unwrapCause(e) instanceof ResourceAlreadyExistsException) {
                        try {
                            TransportUpdateAction.this.innerExecute(request, listener);
                        }
                        catch (Exception inner) {
                            inner.addSuppressed(e);
                            listener.onFailure(inner);
                        }
                    } else {
                        listener.onFailure(e);
                    }
                }
            });
        } else {
            this.innerExecute(request, listener);
        }
    }

    private void innerExecute(UpdateRequest request, ActionListener<UpdateResponse> listener) {
        super.doExecute(request, listener);
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, UpdateRequest request) {
        ShardRouting shard;
        if (request.getShardId() != null) {
            return clusterState.routingTable().index(request.concreteIndex()).shard(request.getShardId().getId()).primaryShardIt();
        }
        ShardIterator shardIterator = this.clusterService.operationRouting().indexShards(clusterState, request.concreteIndex(), request.id(), request.routing());
        while ((shard = shardIterator.nextOrNull()) != null) {
            if (!shard.primary()) continue;
            return new PlainShardIterator(shardIterator.shardId(), Collections.singletonList(shard));
        }
        return new PlainShardIterator(shardIterator.shardId(), Collections.emptyList());
    }

    @Override
    protected void shardOperation(UpdateRequest request, ActionListener<UpdateResponse> listener) {
        this.shardOperation(request, listener, 0);
    }

    protected void shardOperation(UpdateRequest request, ActionListener<UpdateResponse> listener, int retryCount) {
        ShardId shardId = request.getShardId();
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.getId());
        UpdateHelper.Result result = this.updateHelper.prepare(request, indexShard, this.threadPool::absoluteTimeInMillis);
        switch (result.getResponseResult()) {
            case CREATED: {
                IndexRequest upsertRequest = (IndexRequest)result.action();
                BytesReference upsertSourceBytes = upsertRequest.source();
                this.bulkAction.execute(TransportSingleItemBulkWriteAction.toSingleItemBulkRequest(upsertRequest), TransportSingleItemBulkWriteAction.wrapBulkResponse(ActionListener.wrap(response -> {
                    UpdateResponse update = new UpdateResponse(response.getShardInfo(), response.getShardId(), response.getType(), response.getId(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), response.getResult());
                    if (request.fetchSource() != null && request.fetchSource().fetchSource() || request.fields() != null && request.fields().length > 0) {
                        Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(upsertSourceBytes, true, upsertRequest.getContentType());
                        update.setGetResult(UpdateHelper.extractGetResult(request, request.concreteIndex(), response.getVersion(), (Map)sourceAndContent.v2(), (XContentType)sourceAndContent.v1(), upsertSourceBytes));
                    } else {
                        update.setGetResult(null);
                    }
                    update.setForcedRefresh(response.forcedRefresh());
                    listener.onResponse(update);
                }, exception -> this.handleUpdateFailureWithRetry(listener, request, (Exception)exception, retryCount))));
                break;
            }
            case UPDATED: {
                IndexRequest indexRequest = (IndexRequest)result.action();
                BytesReference indexSourceBytes = indexRequest.source();
                this.bulkAction.execute(TransportSingleItemBulkWriteAction.toSingleItemBulkRequest(indexRequest), TransportSingleItemBulkWriteAction.wrapBulkResponse(ActionListener.wrap(response -> {
                    UpdateResponse update = new UpdateResponse(response.getShardInfo(), response.getShardId(), response.getType(), response.getId(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), response.getResult());
                    update.setGetResult(UpdateHelper.extractGetResult(request, request.concreteIndex(), response.getVersion(), result.updatedSourceAsMap(), result.updateSourceContentType(), indexSourceBytes));
                    update.setForcedRefresh(response.forcedRefresh());
                    listener.onResponse(update);
                }, exception -> this.handleUpdateFailureWithRetry(listener, request, (Exception)exception, retryCount))));
                break;
            }
            case DELETED: {
                DeleteRequest deleteRequest = (DeleteRequest)result.action();
                this.bulkAction.execute(TransportSingleItemBulkWriteAction.toSingleItemBulkRequest(deleteRequest), TransportSingleItemBulkWriteAction.wrapBulkResponse(ActionListener.wrap(response -> {
                    UpdateResponse update = new UpdateResponse(response.getShardInfo(), response.getShardId(), response.getType(), response.getId(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), response.getResult());
                    update.setGetResult(UpdateHelper.extractGetResult(request, request.concreteIndex(), response.getVersion(), result.updatedSourceAsMap(), result.updateSourceContentType(), null));
                    update.setForcedRefresh(response.forcedRefresh());
                    listener.onResponse(update);
                }, exception -> this.handleUpdateFailureWithRetry(listener, request, (Exception)exception, retryCount))));
                break;
            }
            case NOOP: {
                IndexShard shard;
                UpdateResponse update = (UpdateResponse)result.action();
                IndexService indexServiceOrNull = this.indicesService.indexService(shardId.getIndex());
                if (indexServiceOrNull != null && (shard = indexService.getShardOrNull(shardId.getId())) != null) {
                    shard.noopUpdate(request.type());
                }
                listener.onResponse(update);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal result " + result.getResponseResult());
            }
        }
    }

    private void handleUpdateFailureWithRetry(ActionListener<UpdateResponse> listener, final UpdateRequest request, Exception failure, final int retryCount) {
        Throwable cause = ExceptionsHelper.unwrapCause(failure);
        if (cause instanceof VersionConflictEngineException && retryCount < request.retryOnConflict()) {
            this.logger.trace("Retry attempt [{}] of [{}] on version conflict on [{}][{}][{}]", (Object)(retryCount + 1), (Object)request.retryOnConflict(), (Object)request.index(), (Object)request.getShardId(), (Object)request.id());
            this.threadPool.executor(this.executor()).execute(new ActionRunnable<UpdateResponse>(listener){

                @Override
                protected void doRun() {
                    TransportUpdateAction.this.shardOperation(request, this.listener, retryCount + 1);
                }
            });
            return;
        }
        listener.onFailure(cause instanceof Exception ? (Exception)cause : new NotSerializableExceptionWrapper(cause));
    }
}

