/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.suggestbox.automation;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.suggestbox.service.Suggestion;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionContext;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionException;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionService;

@Operation(id="Search.SuggestersLauncher", category="User Interface", label="Suggesters launcher", description="Get and launch the suggesters defined and return a list of Suggestion objects.", addToStudio=false)
public class SuggestOperation {
    public static final String ID = "Search.SuggestersLauncher";
    private static final String SUGGESTER_GROUP = "searchbox";
    @Context
    protected CoreSession session;
    @Context
    protected SuggestionService serviceSuggestion;
    @Param(name="searchTerm", required=false)
    protected String searchTerm;

    @OperationMethod
    public Blob run() throws SuggestionException, IOException {
        ArrayList result = new ArrayList();
        SuggestionContext suggestionContext = new SuggestionContext(SUGGESTER_GROUP, (Principal)this.session.getPrincipal());
        suggestionContext.withSession(this.session);
        List<Suggestion> listSuggestions = this.serviceSuggestion.suggest(this.searchTerm, suggestionContext);
        for (Suggestion suggestion : listSuggestions) {
            LinkedHashMap<String, Object> suggestionJSON = new LinkedHashMap<String, Object>();
            suggestionJSON.put("id", suggestion.getId());
            suggestionJSON.put("label", suggestion.getLabel());
            suggestionJSON.put("type", suggestion.getType());
            suggestionJSON.put("icon", suggestion.getIconURL());
            suggestionJSON.put("thumbnailUrl", suggestion.getThumbnailURL());
            suggestionJSON.put("url", suggestion.getObjectUrl());
            ArrayList highlights = new ArrayList();
            if (suggestion.getHighlights() != null) {
                for (Map.Entry<String, List<String>> e : suggestion.getHighlights().entrySet()) {
                    LinkedHashMap<String, Object> h = new LinkedHashMap<String, Object>();
                    h.put("field", e.getKey());
                    h.put("segments", e.getValue());
                    highlights.add(h);
                }
            }
            suggestionJSON.put("highlights", highlights);
            result.add(suggestionJSON);
        }
        return Blobs.createJSONBlobFromValue(result);
    }
}

