/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.suggestbox.service.suggesters;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.platform.suggestbox.service.ComponentInitializationException;
import org.nuxeo.ecm.platform.suggestbox.service.SearchDocumentsSuggestion;
import org.nuxeo.ecm.platform.suggestbox.service.Suggester;
import org.nuxeo.ecm.platform.suggestbox.service.Suggestion;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionContext;
import org.nuxeo.ecm.platform.suggestbox.service.SuggestionException;
import org.nuxeo.ecm.platform.suggestbox.service.descriptors.SuggesterDescriptor;
import org.nuxeo.ecm.platform.suggestbox.service.suggesters.I18nHelper;

@Deprecated
public class DocumentSearchByPropertySuggester
implements Suggester {
    protected String searchField = "fsd:ecm_fulltext";
    protected String suggesterId = "DocumentSearchByPropertySuggester";
    protected String[] searchFields;
    protected String label = "label.searchDocumentsByKeywords";
    protected String description = "";
    protected String iconURL = "/img/facetedSearch.png";
    protected boolean disabled;

    @Override
    public List<Suggestion> suggest(String userInput, SuggestionContext context) throws SuggestionException {
        I18nHelper i18n = I18nHelper.instanceFor(context.messages);
        String i18nLabel = i18n.translate(this.label, userInput);
        SearchDocumentsSuggestion suggestion = new SearchDocumentsSuggestion(this.suggesterId, i18nLabel, this.iconURL).withSearchCriterion(this.searchField, (Serializable)((Object)userInput));
        if (this.searchFields != null) {
            for (String field : this.searchFields) {
                suggestion.withSearchCriterion(field, (Serializable)((Object)userInput));
            }
        }
        if (this.disabled) {
            suggestion.disable();
        }
        if (this.description != null) {
            suggestion.withDescription(i18n.translate(this.description, userInput));
        }
        return Collections.singletonList(suggestion);
    }

    @Override
    public void initWithParameters(SuggesterDescriptor descriptor) throws ComponentInitializationException {
        String psearchFields;
        Map<String, String> params = descriptor.getParameters();
        this.searchField = params.get("searchField");
        this.label = params.get("label");
        String iconURL = params.get("iconURL");
        if (iconURL != null) {
            this.iconURL = iconURL;
        }
        this.description = params.get("description");
        String disabled = params.get("disabled");
        if (disabled != null) {
            this.disabled = Boolean.parseBoolean(disabled);
        }
        if ((psearchFields = params.get("searchFields")) != null) {
            this.searchFields = psearchFields.split(", *");
        }
        if (this.label == null || this.searchField == null && this.searchFields == null) {
            throw new ComponentInitializationException(String.format("Could not initialize suggester '%s': label, searchField (or searchFields) are mandatory parameters", descriptor.getName()));
        }
    }
}

