/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.document;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.nuxeo.ecm.automation.core.util.PaginableDocumentModelList;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.DefaultListJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class DocumentModelListJsonWriter
extends DefaultListJsonWriter<DocumentModel> {
    public static final String ENTITY_DOCUMENT_LIST = "documents";

    public DocumentModelListJsonWriter() {
        super(ENTITY_DOCUMENT_LIST, DocumentModel.class);
    }

    @Override
    public void write(List<DocumentModel> docs, JsonGenerator jg) throws IOException {
        if (docs instanceof PaginableDocumentModelList) {
            PaginableDocumentModelList paginable = (PaginableDocumentModelList)docs;
            String codecName = paginable.getDocumentLinkBuilder();
            try (Closeable resource = this.ctx.wrap().with("URLCodecName", codecName).open();){
                super.write(docs, jg);
            }
        } else {
            super.write(docs, jg);
        }
    }
}

