/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.enrichers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class BreadcrumbJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "breadcrumb";

    public BreadcrumbJsonEnricher() {
        super(NAME);
    }

    @Override
    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        List parentDocuments = null;
        try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(document);){
            parentDocuments = wrapper.getSession().getParentDocuments(document.getRef());
        }
        DocumentModelListImpl documentList = new DocumentModelListImpl(parentDocuments);
        jg.writeFieldName(NAME);
        this.writeEntity(documentList, jg);
    }
}

