/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.audit.es;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.http.readonly.filter.AuditRequestFilter;
import org.nuxeo.runtime.api.Framework;

public class RoutingAuditRequestFilter
extends AuditRequestFilter {
    private CoreSession session;

    public void init(CoreSession session, String indices, String types, String rawQuery, String payload) {
        this.session = session;
        this.principal = session.getPrincipal();
        ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
        this.indices = esa.getIndexNameForType("entry");
        this.types = "entry";
        this.rawQuery = rawQuery;
        this.payload = payload;
        if (payload == null && !this.principal.isAdministrator()) {
            this.extractPayloadFromQuery();
        }
    }

    public String getPayload() throws JSONException {
        if (this.filteredPayload == null) {
            JSONObject query;
            JSONObject payloadJson;
            if (this.payload.contains("\\")) {
                this.payload = this.payload.replaceAll("\\\\", "_@@_");
            }
            if ((payloadJson = new JSONObject(this.payload)).has("query")) {
                query = payloadJson.getJSONObject("query");
                payloadJson.remove("query");
            } else {
                query = new JSONObject("{\"match_all\":{}}");
            }
            JSONObject categoryFilter = new JSONObject().put("term", (Object)new JSONObject().put("category", (Object)"Routing"));
            JSONArray fs = new JSONArray().put((Object)categoryFilter);
            if (!this.principal.isAdministrator()) {
                DocumentRoutingService documentRoutingService = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
                List wfModels = documentRoutingService.getAvailableDocumentRouteModel(this.session);
                ArrayList<String> modelNames = new ArrayList<String>();
                for (DocumentRoute model : wfModels) {
                    if (!this.session.hasPermission(model.getDocument().getRef(), "DataVisualization")) continue;
                    modelNames.add(model.getModelName());
                }
                JSONObject wfModelFilter = new JSONObject().put("terms", (Object)new JSONObject().put("extended.modelName", (Object)modelNames.toArray(new String[0])));
                fs.put((Object)wfModelFilter);
            }
            JSONObject newQuery = new JSONObject().put("bool", (Object)new JSONObject().put("must", (Object)query).put("filter", (Object)fs));
            payloadJson.put("query", (Object)newQuery);
            this.filteredPayload = payloadJson.toString();
            if (this.filteredPayload.contains("_@@_")) {
                this.filteredPayload = this.filteredPayload.replaceAll("_@@_", "\\\\");
            }
        }
        return this.filteredPayload;
    }
}

