/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.ui.web.auth.digest;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.http.parser.Authorization;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class DigestAuthenticator
implements NuxeoAuthenticationPlugin {
    private static final Log log = LogFactory.getLog(DigestAuthenticator.class);
    protected static final String DEFAULT_REALMNAME = "NUXEO";
    protected static final long DEFAULT_NONCE_VALIDITY_SECONDS = 1000L;
    protected static final String REALM = "realm";
    protected static final String HTTP_METHOD = "httpMethod";
    protected static final String URI = "uri";
    protected static final String QOP = "qop";
    protected static final String NONCE = "nonce";
    protected static final String NC = "nc";
    protected static final String CNONCE = "cnonce";
    protected static final String REALM_NAME_KEY = "RealmName";
    protected static final String BA_HEADER_NAME = "WWW-Authenticate";
    protected String realmName;
    protected long nonceValiditySeconds = 1000L;
    protected String accessKey = "key";

    public Boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String baseURL) {
        long expiryTime = System.currentTimeMillis() + this.nonceValiditySeconds * 1000L;
        String signature = DigestUtils.md5Hex((String)(expiryTime + ":" + this.accessKey));
        String nonce = expiryTime + ":" + signature;
        String nonceB64 = new String(Base64.encodeBase64((byte[])nonce.getBytes()));
        String authenticateHeader = String.format("Digest realm=\"%s\", qop=\"auth\", nonce=\"%s\"", this.realmName, nonceB64);
        try {
            httpResponse.addHeader(BA_HEADER_NAME, authenticateHeader);
            httpResponse.sendError(401);
            return Boolean.TRUE;
        }
        catch (IOException e) {
            return Boolean.FALSE;
        }
    }

    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String header = httpRequest.getHeader("Authorization");
        if (StringUtils.isEmpty((CharSequence)header)) {
            return null;
        }
        Map<String, String> headerMap = DigestAuthenticator.splitParameters(header);
        if (headerMap == null) {
            return null;
        }
        headerMap.put(HTTP_METHOD, httpRequest.getMethod());
        String nonceB64 = headerMap.get(NONCE);
        String nonce = new String(Base64.decodeBase64((byte[])nonceB64.getBytes()));
        String[] nonceTokens = nonce.split(":");
        long nonceExpiryTime = Long.parseLong(nonceTokens[0]);
        String username = this.getValidatedUsername(headerMap);
        if (username == null) {
            return null;
        }
        return new UserIdentificationInfo(username);
    }

    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        return Boolean.TRUE;
    }

    public void initPlugin(Map<String, String> parameters) {
        this.realmName = parameters.containsKey(REALM_NAME_KEY) ? parameters.get(REALM_NAME_KEY) : DEFAULT_REALMNAME;
    }

    public List<String> getUnAuthenticatedURLPrefix() {
        return null;
    }

    public static Map<String, String> splitParameters(String auth) {
        Map map;
        try {
            map = Authorization.parseAuthorizationDigest((StringReader)new StringReader(auth));
        }
        catch (IOException | IllegalArgumentException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            map = null;
        }
        return map;
    }

    protected String getValidatedUsername(Map<String, String> headerMap) {
        String username = headerMap.get("username");
        try {
            String digest;
            String storedHA1 = this.getStoredHA1(username);
            if (StringUtils.isEmpty((CharSequence)storedHA1)) {
                log.warn((Object)("Digest authentication failed, stored HA1 is empty for user: " + username));
                return null;
            }
            String computedDigest = DigestAuthenticator.computeDigest(storedHA1, headerMap.get(HTTP_METHOD), headerMap.get(URI), headerMap.get(QOP), headerMap.get(NONCE), headerMap.get(NC), headerMap.get(CNONCE));
            if (!computedDigest.equals(digest = headerMap.get("response"))) {
                log.warn((Object)("Digest authentication failed for user: " + username + ", realm: " + headerMap.get(REALM)));
                return null;
            }
        }
        catch (IllegalArgumentException | DirectoryException e) {
            log.error((Object)("Digest authentication failed for user: " + username), e);
            return null;
        }
        return username;
    }

    protected static String computeDigest(String ha1, String httpMethod, String uri, String qop, String nonce, String nc, String cnonce) throws IllegalArgumentException {
        String digest;
        String a2 = httpMethod + ":" + uri;
        String ha2 = DigestUtils.md5Hex((String)a2);
        if (qop == null) {
            digest = ha1 + ":" + nonce + ":" + ha2;
        } else if ("auth".equals(qop)) {
            digest = ha1 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + ha2;
        } else {
            throw new IllegalArgumentException("This method does not support a qop: '" + qop + "'");
        }
        return DigestUtils.md5Hex((String)digest);
    }

    protected String getStoredHA1(String username) {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        String dirName = userManager.getDigestAuthDirectory();
        DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
        Directory directory = directoryService.getDirectory(dirName);
        if (directory == null) {
            throw new IllegalArgumentException("Digest Auth directory not found: " + dirName);
        }
        try (Session dir = directoryService.open(dirName);){
            dir.setReadAllColumns(true);
            String schema = directoryService.getDirectorySchema(dirName);
            DocumentModel entry = (DocumentModel)Framework.doPrivileged(() -> dir.getEntry(username, true));
            String passwordField = dir.getPasswordField();
            String string = entry == null ? null : (String)entry.getProperty(schema, passwordField);
            return string;
        }
    }
}

