/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.trash.TrashService;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.BooleanLiteral;
import org.nuxeo.ecm.core.query.sql.model.DateLiteral;
import org.nuxeo.ecm.core.query.sql.model.DoubleLiteral;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.Function;
import org.nuxeo.ecm.core.query.sql.model.IntegerLiteral;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.runtime.api.Framework;

public abstract class ExpressionEvaluator {
    public static final String NXQL_ECM_ANCESTOR_IDS = "ecm:__ancestorIds";
    public static final String NXQL_ECM_PATH = "ecm:__path";
    public static final String NXQL_ECM_READ_ACL = "ecm:__read_acl";
    public static final String NXQL_ECM_FULLTEXT_SIMPLE = "ecm:__fulltextSimple";
    public static final String NXQL_ECM_FULLTEXT_BINARY = "ecm:__fulltextBinary";
    protected static final String DATE_CAST = "DATE";
    protected static final String PHRASE_QUOTE = "\"";
    protected static final String NEG_PHRASE_QUOTE = "-\"";
    protected static final String OR = "or";
    public final PathResolver pathResolver;
    public final Set<String> principals;
    public final boolean fulltextSearchDisabled;
    public boolean hasFulltext;
    private static final Pattern WORD_PATTERN = Pattern.compile("[\\s\\p{Punct}]+");
    private static final String UNACCENTED = "aaaaaaaceeeeiiii\u00f0nooooo\u00f7ouuuuy\u00fey";
    private static final String STOP_WORDS_STR = "a an are and as at be by for from how i in is it of on or that the this to was what when where who will with car donc est il ils je la le les mais ni nous or ou pour tu un une vous www com net org";
    private static final Set<String> STOP_WORDS = new HashSet<String>(Arrays.asList(StringUtils.split((String)"a an are and as at be by for from how i in is it of on or that the this to was what when where who will with car donc est il ils je la le les mais ni nous or ou pour tu un une vous www com net org", (char)' ')));

    public ExpressionEvaluator(PathResolver pathResolver, String[] principals, boolean fulltextSearchDisabled) {
        this.pathResolver = pathResolver;
        this.principals = principals == null ? null : new HashSet<String>(Arrays.asList(principals));
        this.fulltextSearchDisabled = fulltextSearchDisabled;
    }

    public Object walkExpression(Expression expr) {
        String cast;
        Operator op = expr.operator;
        Operand lvalue = expr.lvalue;
        Operand rvalue = expr.rvalue;
        Reference ref = lvalue instanceof Reference ? (Reference)lvalue : null;
        String name = ref != null ? ref.name : null;
        String string = cast = ref != null ? ref.cast : null;
        if (DATE_CAST.equals(cast)) {
            this.checkDateLiteralForCast(rvalue, name);
        }
        if (op == Operator.STARTSWITH) {
            return this.walkStartsWith(lvalue, rvalue);
        }
        if ("ecm:path".equals(name)) {
            return this.walkEcmPath(op, rvalue);
        }
        if ("ecm:ancestorId".equals(name)) {
            return this.walkAncestorId(op, rvalue);
        }
        if ("ecm:isTrashed".equals(name)) {
            return this.walkIsTrashed(op, rvalue);
        }
        if (name != null && name.startsWith("ecm:fulltext") && !"ecm:fulltextJobId".equals(name)) {
            return this.walkEcmFulltext(name, op, rvalue);
        }
        if (op == Operator.SUM) {
            throw new UnsupportedOperationException("SUM");
        }
        if (op == Operator.SUB) {
            throw new UnsupportedOperationException("SUB");
        }
        if (op == Operator.MUL) {
            throw new UnsupportedOperationException("MUL");
        }
        if (op == Operator.DIV) {
            throw new UnsupportedOperationException("DIV");
        }
        if (op == Operator.LT) {
            return this.walkLt(lvalue, rvalue);
        }
        if (op == Operator.GT) {
            return this.walkGt(lvalue, rvalue);
        }
        if (op == Operator.EQ) {
            return this.walkEq(lvalue, rvalue);
        }
        if (op == Operator.NOTEQ) {
            return this.walkNotEq(lvalue, rvalue);
        }
        if (op == Operator.LTEQ) {
            return this.walkLtEq(lvalue, rvalue);
        }
        if (op == Operator.GTEQ) {
            return this.walkGtEq(lvalue, rvalue);
        }
        if (op == Operator.AND) {
            if (expr instanceof MultiExpression) {
                return this.walkMultiExpression((MultiExpression)expr);
            }
            return this.walkAnd(lvalue, rvalue);
        }
        if (op == Operator.NOT) {
            return this.walkNot(lvalue);
        }
        if (op == Operator.OR) {
            if (expr instanceof MultiExpression) {
                return this.walkMultiExpression((MultiExpression)expr);
            }
            return this.walkOr(lvalue, rvalue);
        }
        if (op == Operator.LIKE) {
            return this.walkLike(lvalue, rvalue, true, false);
        }
        if (op == Operator.ILIKE) {
            return this.walkLike(lvalue, rvalue, true, true);
        }
        if (op == Operator.NOTLIKE) {
            return this.walkLike(lvalue, rvalue, false, false);
        }
        if (op == Operator.NOTILIKE) {
            return this.walkLike(lvalue, rvalue, false, true);
        }
        if (op == Operator.IN) {
            return this.walkIn(lvalue, rvalue, true);
        }
        if (op == Operator.NOTIN) {
            return this.walkIn(lvalue, rvalue, false);
        }
        if (op == Operator.ISNULL) {
            return this.walkIsNull(lvalue);
        }
        if (op == Operator.ISNOTNULL) {
            return this.walkIsNotNull(lvalue);
        }
        if (op == Operator.BETWEEN) {
            return this.walkBetween(lvalue, rvalue, true);
        }
        if (op == Operator.NOTBETWEEN) {
            return this.walkBetween(lvalue, rvalue, false);
        }
        throw new QueryParseException("Unknown operator: " + op);
    }

    protected void checkDateLiteralForCast(Operand value, String name) {
        if (value instanceof DateLiteral && !((DateLiteral)value).onlyDate) {
            throw new QueryParseException("DATE() cast must be used with DATE literal, not TIMESTAMP: " + name);
        }
    }

    protected Boolean walkEcmPath(Operator op, Operand rvalue) {
        if (op != Operator.EQ && op != Operator.NOTEQ) {
            throw new QueryParseException("ecm:path requires = or <> operator");
        }
        if (!(rvalue instanceof StringLiteral)) {
            throw new QueryParseException("ecm:path requires literal path as right argument");
        }
        String path = ((StringLiteral)rvalue).value;
        if (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        String id = this.pathResolver.getIdForPath(path);
        Object right = this.walkReference(new Reference("ecm:uuid"));
        if (id == null) {
            return Boolean.FALSE;
        }
        Boolean eq = this.eq(id, right);
        return op == Operator.EQ ? eq : this.not(eq);
    }

    protected Boolean walkAncestorId(Operator op, Operand rvalue) {
        boolean eq;
        if (op != Operator.EQ && op != Operator.NOTEQ) {
            throw new QueryParseException("ecm:ancestorId requires = or <> operator");
        }
        if (!(rvalue instanceof StringLiteral)) {
            throw new QueryParseException("ecm:ancestorId requires literal id as right argument");
        }
        String ancestorId = ((StringLiteral)rvalue).value;
        Object[] ancestorIds = (Object[])this.walkReference(new Reference(NXQL_ECM_ANCESTOR_IDS));
        boolean bl = eq = op == Operator.EQ;
        if (ancestorIds == null) {
            return eq ? Boolean.FALSE : Boolean.TRUE;
        }
        for (Object id : ancestorIds) {
            if (!ancestorId.equals(id)) continue;
            return eq ? Boolean.TRUE : Boolean.FALSE;
        }
        return eq ? Boolean.FALSE : Boolean.TRUE;
    }

    protected Boolean walkEcmFulltext(String name, Operator op, Operand rvalue) {
        if (op != Operator.EQ && op != Operator.LIKE) {
            throw new QueryParseException("ecm:fulltext requires = or LIKE operator");
        }
        if (!(rvalue instanceof StringLiteral)) {
            throw new QueryParseException("ecm:fulltext requires literal string as right argument");
        }
        if (this.fulltextSearchDisabled) {
            throw new QueryParseException("Fulltext search disabled by configuration");
        }
        String query = ((StringLiteral)rvalue).value;
        if (name.equals("ecm:fulltext")) {
            this.hasFulltext = true;
            String simple = (String)this.walkReference(new Reference(NXQL_ECM_FULLTEXT_SIMPLE));
            String binary = (String)this.walkReference(new Reference(NXQL_ECM_FULLTEXT_BINARY));
            return ExpressionEvaluator.fulltext(simple, binary, query);
        }
        if (name.charAt("ecm:fulltext".length()) != '.') {
            throw new QueryParseException(name + " has incorrect syntax for a secondary fulltext index");
        }
        String prop = name.substring("ecm:fulltext".length() + 1);
        String ft = query.replace(" ", "%");
        rvalue = new StringLiteral(ft);
        return this.walkLike((Operand)new Reference(prop), rvalue, true, true);
    }

    protected Boolean walkIsTrashed(Operator op, Operand rvalue) {
        if (op != Operator.EQ && op != Operator.NOTEQ) {
            throw new QueryParseException("ecm:isTrashed requires = or <> operator");
        }
        TrashService trashService = (TrashService)Framework.getService(TrashService.class);
        if (trashService.hasFeature(TrashService.Feature.TRASHED_STATE_IS_DEDUCED_FROM_LIFECYCLE)) {
            return this.walkIsTrashed(new Reference("ecm:currentLifeCycleState"), op, rvalue, (Literal)new StringLiteral("deleted"));
        }
        if (trashService.hasFeature(TrashService.Feature.TRASHED_STATE_IN_MIGRATION)) {
            Boolean lifeCycleTrashed = this.walkIsTrashed(new Reference("ecm:currentLifeCycleState"), op, rvalue, (Literal)new StringLiteral("deleted"));
            Boolean propertyTrashed = this.walkIsTrashed(new Reference("ecm:isTrashed"), op, rvalue, (Literal)new IntegerLiteral(1L));
            return this.or(lifeCycleTrashed, propertyTrashed);
        }
        if (trashService.hasFeature(TrashService.Feature.TRASHED_STATE_IS_DEDICATED_PROPERTY)) {
            return this.walkIsTrashed(new Reference("ecm:isTrashed"), op, rvalue, (Literal)new IntegerLiteral(1L));
        }
        throw new UnsupportedOperationException("TrashService is in an unknown state");
    }

    protected Boolean walkIsTrashed(Reference ref, Operator op, Operand initialRvalue, Literal deletedRvalue) {
        long v;
        if (!(initialRvalue instanceof IntegerLiteral) || (v = ((IntegerLiteral)initialRvalue).value) != 0L && v != 1L) {
            throw new QueryParseException("ecm:isTrashed requires literal 0 or 1 as right argument");
        }
        boolean equalsDeleted = op == Operator.EQ ^ v == 0L;
        if (equalsDeleted) {
            return this.walkEq((Operand)ref, (Operand)deletedRvalue);
        }
        return this.walkNotEq((Operand)ref, (Operand)deletedRvalue);
    }

    public Boolean walkNot(Operand value) {
        return this.not(this.bool(this.walkOperand(value)));
    }

    public Boolean walkIsNull(Operand value) {
        return this.walkOperand(value) == null;
    }

    public Boolean walkIsNotNull(Operand value) {
        return this.walkOperand(value) != null;
    }

    public Boolean walkMultiExpression(MultiExpression expr) {
        boolean and = expr.operator == Operator.AND;
        Boolean res = and ? Boolean.TRUE : Boolean.FALSE;
        for (Predicate predicate : expr.predicates) {
            Boolean bool = this.bool(this.walkExpression((Expression)predicate));
            if (and) {
                res = this.and(res, bool);
                continue;
            }
            res = this.or(res, bool);
        }
        return res;
    }

    public Boolean walkAnd(Operand lvalue, Operand rvalue) {
        Boolean left = this.bool(this.walkOperand(lvalue));
        Boolean right = this.bool(this.walkOperand(rvalue));
        return this.and(left, right);
    }

    public Boolean walkOr(Operand lvalue, Operand rvalue) {
        Boolean left = this.bool(this.walkOperand(lvalue));
        Boolean right = this.bool(this.walkOperand(rvalue));
        return this.or(left, right);
    }

    public Boolean walkEq(Operand lvalue, Operand rvalue) {
        Object right = this.walkOperand(rvalue);
        if (this.isMixinTypes(lvalue)) {
            if (!(right instanceof String)) {
                throw new QueryParseException("Invalid EQ rhs: " + rvalue);
            }
            return this.walkMixinTypes(Collections.singletonList((String)right), true);
        }
        Object left = this.walkOperand(lvalue);
        return this.eqMaybeList(left, right);
    }

    public Boolean walkNotEq(Operand lvalue, Operand rvalue) {
        if (this.isMixinTypes(lvalue)) {
            Object right = this.walkOperand(rvalue);
            if (!(right instanceof String)) {
                throw new QueryParseException("Invalid NE rhs: " + rvalue);
            }
            return this.walkMixinTypes(Collections.singletonList((String)right), false);
        }
        return this.not(this.walkEq(lvalue, rvalue));
    }

    public Boolean walkLt(Operand lvalue, Operand rvalue) {
        Integer cmp = this.cmp(lvalue, rvalue);
        return cmp == null ? null : Boolean.valueOf(cmp < 0);
    }

    public Boolean walkGt(Operand lvalue, Operand rvalue) {
        Integer cmp = this.cmp(lvalue, rvalue);
        return cmp == null ? null : Boolean.valueOf(cmp > 0);
    }

    public Boolean walkLtEq(Operand lvalue, Operand rvalue) {
        Integer cmp = this.cmp(lvalue, rvalue);
        return cmp == null ? null : Boolean.valueOf(cmp <= 0);
    }

    public Boolean walkGtEq(Operand lvalue, Operand rvalue) {
        Integer cmp = this.cmp(lvalue, rvalue);
        return cmp == null ? null : Boolean.valueOf(cmp >= 0);
    }

    public Object walkBetween(Operand lvalue, Operand rvalue, boolean positive) {
        LiteralList l = (LiteralList)rvalue;
        Predicate va = new Predicate(lvalue, Operator.GTEQ, (Operand)l.get(0));
        Predicate vb = new Predicate(lvalue, Operator.LTEQ, (Operand)l.get(1));
        Predicate pred = new Predicate((Operand)va, Operator.AND, (Operand)vb);
        if (!positive) {
            pred = new Predicate((Operand)pred, Operator.NOT, null);
        }
        return this.walkExpression((Expression)pred);
    }

    public Boolean walkIn(Operand lvalue, Operand rvalue, boolean positive) {
        Object right = this.walkOperand(rvalue);
        if (!(right instanceof List)) {
            throw new QueryParseException("Invalid IN rhs: " + rvalue);
        }
        if (this.isMixinTypes(lvalue)) {
            return this.walkMixinTypes((List)right, positive);
        }
        Object left = this.walkOperand(lvalue);
        Boolean in = this.inMaybeList(left, (List)right);
        return positive ? in : this.not(in);
    }

    public Object walkOperand(Operand op) {
        if (op instanceof Literal) {
            return this.walkLiteral((Literal)op);
        }
        if (op instanceof LiteralList) {
            return this.walkLiteralList((LiteralList)op);
        }
        if (op instanceof Function) {
            return this.walkFunction((Function)op);
        }
        if (op instanceof Expression) {
            return this.walkExpression((Expression)op);
        }
        if (op instanceof Reference) {
            return this.walkReference((Reference)op);
        }
        throw new QueryParseException("Unknown operand: " + op);
    }

    public Object walkLiteral(Literal lit) {
        if (lit instanceof BooleanLiteral) {
            return this.walkBooleanLiteral((BooleanLiteral)lit);
        }
        if (lit instanceof DateLiteral) {
            return this.walkDateLiteral((DateLiteral)lit);
        }
        if (lit instanceof DoubleLiteral) {
            return this.walkDoubleLiteral((DoubleLiteral)lit);
        }
        if (lit instanceof IntegerLiteral) {
            return this.walkIntegerLiteral((IntegerLiteral)lit);
        }
        if (lit instanceof StringLiteral) {
            return this.walkStringLiteral((StringLiteral)lit);
        }
        throw new QueryParseException("Unknown literal: " + lit);
    }

    public Boolean walkBooleanLiteral(BooleanLiteral lit) {
        return lit.value;
    }

    public Calendar walkDateLiteral(DateLiteral lit) {
        if (lit.onlyDate) {
            Calendar date = lit.toCalendar();
            if (date != null) {
                date.set(11, 0);
                date.set(12, 0);
                date.set(13, 0);
                date.set(14, 0);
            }
            return date;
        }
        return lit.toCalendar();
    }

    public Double walkDoubleLiteral(DoubleLiteral lit) {
        return lit.value;
    }

    public Long walkIntegerLiteral(IntegerLiteral lit) {
        return lit.value;
    }

    public String walkStringLiteral(StringLiteral lit) {
        return lit.value;
    }

    public List<Object> walkLiteralList(LiteralList litList) {
        ArrayList<Object> list = new ArrayList<Object>(litList.size());
        for (Literal lit : litList) {
            list.add(this.walkLiteral(lit));
        }
        return list;
    }

    public Boolean walkLike(Operand lvalue, Operand rvalue, boolean positive, boolean caseInsensitive) {
        Object left = this.walkOperand(lvalue);
        Object right = this.walkOperand(rvalue);
        if (!(right instanceof String)) {
            throw new QueryParseException("Invalid LIKE rhs: " + rvalue);
        }
        return this.likeMaybeList(left, (String)right, positive, caseInsensitive);
    }

    public Object walkFunction(Function func) {
        throw new UnsupportedOperationException("Function");
    }

    public Boolean walkStartsWith(Operand lvalue, Operand rvalue) {
        if (!(lvalue instanceof Reference)) {
            throw new QueryParseException("Invalid STARTSWITH query, left hand side must be a property: " + lvalue);
        }
        String name = ((Reference)lvalue).name;
        if (!(rvalue instanceof StringLiteral)) {
            throw new QueryParseException("Invalid STARTSWITH query, right hand side must be a literal path: " + rvalue);
        }
        String path = ((StringLiteral)rvalue).value;
        if (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ("ecm:path".equals(name)) {
            return this.walkStartsWithPath(path);
        }
        return this.walkStartsWithNonPath(lvalue, path);
    }

    protected Boolean walkStartsWithPath(String path) {
        String ancestorId = this.pathResolver.getIdForPath(path);
        Object[] ancestorIds = (Object[])this.walkReference(new Reference(NXQL_ECM_ANCESTOR_IDS));
        if (ancestorId == null) {
            return Boolean.FALSE;
        }
        if (ancestorIds == null) {
            return Boolean.FALSE;
        }
        for (Object id : ancestorIds) {
            if (!ancestorId.equals(id)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected Boolean walkStartsWithNonPath(Operand lvalue, String path) {
        Object left = this.walkReference((Reference)lvalue);
        Boolean bool = this.eqMaybeList(left, path);
        if (Boolean.TRUE.equals(bool)) {
            return Boolean.TRUE;
        }
        String pattern = path + "/%";
        return this.likeMaybeList(left, pattern, true, false);
    }

    public abstract Object walkReference(Reference var1);

    protected boolean isMixinTypes(Operand op) {
        if (!(op instanceof Reference)) {
            return false;
        }
        return ((Reference)op).name.equals("ecm:mixinType");
    }

    protected Boolean bool(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Boolean)) {
            throw new QueryParseException("Not a boolean: " + value);
        }
        return (Boolean)value;
    }

    protected Boolean not(Boolean value) {
        if (value == null) {
            return null;
        }
        return value == false;
    }

    protected Boolean and(Boolean left, Boolean right) {
        if (Boolean.TRUE.equals(left)) {
            return right;
        }
        return left;
    }

    protected Boolean or(Boolean left, Boolean right) {
        if (Boolean.TRUE.equals(left)) {
            return left;
        }
        return right;
    }

    protected Boolean eq(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Calendar && right instanceof Calendar) {
            return ((Calendar)left).getTimeInMillis() == ((Calendar)right).getTimeInMillis();
        }
        return left.equals(right);
    }

    protected Boolean in(Object left, List<Object> right) {
        if (left == null) {
            return null;
        }
        boolean hasNull = false;
        for (Object r : right) {
            if (r == null) {
                hasNull = true;
                continue;
            }
            if (!left.equals(r)) continue;
            return Boolean.TRUE;
        }
        return hasNull ? null : Boolean.FALSE;
    }

    protected Integer cmp(Operand lvalue, Operand rvalue) {
        Object left = this.walkOperand(lvalue);
        Object right = this.walkOperand(rvalue);
        return this.cmp(left, right);
    }

    protected Integer cmp(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (!(left instanceof Comparable)) {
            throw new QueryParseException("Not a comparable: " + left);
        }
        return ((Comparable)left).compareTo(right);
    }

    protected Boolean like(Object left, String right, boolean caseInsensitive) {
        if (left == null || right == null) {
            return null;
        }
        if (!(left instanceof String)) {
            throw new QueryParseException("Invalid LIKE lhs: " + left);
        }
        String value = (String)left;
        if (caseInsensitive) {
            value = value.toLowerCase();
            right = right.toLowerCase();
        }
        String regex = ExpressionEvaluator.likeToRegex(right);
        return Pattern.matches(regex, value);
    }

    public static String likeToRegex(String like) {
        StringBuilder regex = new StringBuilder();
        char[] chars = like.toCharArray();
        boolean escape = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            boolean escapeNext = false;
            switch (c) {
                case '%': {
                    if (escape) {
                        regex.append(c);
                        break;
                    }
                    regex.append(".*");
                    break;
                }
                case '_': {
                    if (escape) {
                        regex.append(c);
                        break;
                    }
                    regex.append(".");
                    break;
                }
                case '\\': {
                    if (escape) {
                        regex.append("\\\\");
                        break;
                    }
                    escapeNext = true;
                    break;
                }
                default: {
                    if (!CharUtils.isAsciiAlphanumeric((char)c)) {
                        regex.append("\\");
                    }
                    regex.append(c);
                }
            }
            escape = escapeNext;
        }
        if (escape) {
            // empty if block
        }
        return regex.toString();
    }

    protected Boolean eqMaybeList(Object left, Object right) {
        if (left instanceof Object[]) {
            for (Object l : (Object[])left) {
                Boolean eq = this.eq(l, right);
                if (!Boolean.TRUE.equals(eq)) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return this.eq(left, right);
    }

    protected Boolean inMaybeList(Object left, List<Object> right) {
        if (left instanceof Object[]) {
            for (Object l : (Object[])left) {
                Boolean in = this.in(l, right);
                if (!Boolean.TRUE.equals(in)) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return this.in(left, right);
    }

    protected Boolean likeMaybeList(Object left, String right, boolean positive, boolean caseInsensitive) {
        if (left instanceof Object[]) {
            for (Object l : (Object[])left) {
                Boolean like = this.like(l, right, caseInsensitive);
                if (!Boolean.TRUE.equals(like)) continue;
                return positive;
            }
            return !positive;
        }
        Boolean like = this.like(left, right, caseInsensitive);
        return positive ? like : this.not(like);
    }

    public abstract Boolean walkMixinTypes(List<String> var1, boolean var2);

    protected static Boolean fulltext(String string1, String string2, String queryString) {
        if (queryString == null || string1 == null && string2 == null) {
            return null;
        }
        ArrayList<String> query = new ArrayList<String>();
        Object phrase = null;
        int phraseWordCount = 1;
        int maxPhraseWordCount = 1;
        for (String word : StringUtils.split((String)queryString.toLowerCase(), (char)' ')) {
            if (WORD_PATTERN.matcher(word).matches()) continue;
            if (phrase != null) {
                if (word.endsWith(PHRASE_QUOTE)) {
                    phrase = (String)phrase + " " + word.substring(0, word.length() - 1);
                    query.add((String)phrase);
                    if (maxPhraseWordCount < ++phraseWordCount) {
                        maxPhraseWordCount = phraseWordCount;
                    }
                    phrase = null;
                    phraseWordCount = 1;
                    continue;
                }
                phrase = phrase + " " + word;
                ++phraseWordCount;
                continue;
            }
            if (word.startsWith(PHRASE_QUOTE)) {
                phrase = word.substring(1);
                continue;
            }
            if (word.startsWith(NEG_PHRASE_QUOTE)) {
                phrase = "-" + word.substring(2);
                continue;
            }
            if (word.startsWith("+")) {
                word = word.substring(1);
            }
            query.add(word);
        }
        if (query.isEmpty()) {
            return Boolean.FALSE;
        }
        HashSet<String> fulltext = new HashSet<String>();
        fulltext.addAll(ExpressionEvaluator.parseFullText(string1, maxPhraseWordCount));
        fulltext.addAll(ExpressionEvaluator.parseFullText(string2, maxPhraseWordCount));
        return ExpressionEvaluator.fulltext(fulltext, query);
    }

    private static Set<String> parseFullText(String string, int phraseSize) {
        if (string == null) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        LinkedList<String> phraseWords = new LinkedList<String>();
        for (String word : WORD_PATTERN.split(string)) {
            if ((word = ExpressionEvaluator.parseWord(word)) == null) continue;
            word = word.toLowerCase();
            set.add(word);
            if (phraseSize <= 1) continue;
            phraseWords.addLast(word);
            if (phraseWords.size() <= 1) continue;
            if (phraseWords.size() > phraseSize) {
                phraseWords.removeFirst();
            }
            ExpressionEvaluator.addPhraseWords(set, phraseWords);
        }
        while (phraseWords.size() > 2) {
            phraseWords.removeFirst();
            ExpressionEvaluator.addPhraseWords(set, phraseWords);
        }
        return set;
    }

    private static void addPhraseWords(Set<String> set, Deque<String> phraseWords) {
        Object[] array = phraseWords.toArray(new String[0]);
        for (int len = 2; len <= array.length; ++len) {
            String phrase = StringUtils.join((Object[])array, (char)' ', (int)0, (int)len);
            set.add(phrase);
        }
    }

    private static String parseWord(String string) {
        String word;
        int len = string.length();
        if (len < 3) {
            return null;
        }
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = Character.toLowerCase(string.charAt(i));
            if (c == '\u00e6') {
                sb.append("ae");
                continue;
            }
            if (c >= '\u00e0' && c <= '\u00ff') {
                sb.append(UNACCENTED.charAt(c - 224));
                continue;
            }
            if (c == '\u0153') {
                sb.append("oe");
                continue;
            }
            sb.append(c);
        }
        int l = sb.length();
        if (l > 3 && sb.charAt(l - 1) == 's') {
            sb.setLength(l - 1);
        }
        if (STOP_WORDS.contains(word = sb.toString())) {
            return null;
        }
        return word;
    }

    protected static boolean fulltext(Set<String> fulltext, List<String> query) {
        boolean andMatch = true;
        PeekingIterator it = Iterators.peekingIterator(query.iterator());
        while (it.hasNext()) {
            boolean match;
            String word = (String)it.next();
            if (word.endsWith("*") || word.endsWith("%")) {
                match = false;
                String prefix = word.substring(0, word.length() - 2);
                for (String candidate : fulltext) {
                    if (!candidate.startsWith(prefix)) continue;
                    match = true;
                    break;
                }
            } else {
                match = word.startsWith("-") ? !fulltext.contains(word = word.substring(1)) : fulltext.contains(word);
            }
            if (!match) {
                andMatch = false;
            }
            if (!it.hasNext() || !((String)it.peek()).equals(OR)) continue;
            it.next();
            if (andMatch) {
                return true;
            }
            andMatch = true;
        }
        return andMatch;
    }

    protected static boolean fulltext1(Set<String> fulltext, List<String> query) {
        boolean inOr = false;
        boolean orMatch = false;
        PeekingIterator it = Iterators.peekingIterator(query.iterator());
        while (it.hasNext()) {
            boolean match;
            String word = (String)it.next();
            if (it.hasNext() && ((String)it.peek()).equals(OR)) {
                inOr = true;
                orMatch = false;
            }
            if (word.endsWith("*") || word.endsWith("%")) {
                match = false;
                String prefix = word.substring(0, word.length() - 2);
                for (String candidate : fulltext) {
                    if (!candidate.startsWith(prefix)) continue;
                    match = true;
                    break;
                }
            } else {
                match = word.startsWith("-") ? !fulltext.contains(word = word.substring(1)) : fulltext.contains(word);
            }
            if (inOr) {
                if (match) {
                    orMatch = true;
                }
                if (it.hasNext() && ((String)it.peek()).equals(OR)) {
                    it.next();
                    continue;
                }
                match = orMatch;
                inOr = false;
            }
            if (match) continue;
            return false;
        }
        return !inOr || orMatch;
    }

    public static interface PathResolver {
        public String getIdForPath(String var1);
    }
}

