/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.StateAccessor;
import org.nuxeo.ecm.core.storage.StateHelper;

public class State
implements StateAccessor,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Log log = LogFactory.getLog(State.class);
    private static final int HASHMAP_DEFAULT_INITIAL_CAPACITY = 16;
    private static final float HASHMAP_DEFAULT_LOAD_FACTOR = 0.75f;
    public static final int ARRAY_MAX = 5;
    private static final int DEBUG_MAX_STRING = 100;
    private static final int DEBUG_MAX_ARRAY = 10;
    public static final State EMPTY = new State(Collections.emptyMap());
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Set<String> TO_STRING_KEY_ORDER = new LinkedHashSet<String>(Arrays.asList("ecm:id", "ecm:primaryType", "ecm:name", "ecm:parentId", "ecm:isVersion", "ecm:isProxy"));
    public static final Nop NOP = Nop.NOP;
    protected Map<String, Serializable> map;
    protected List<String> keys;
    protected List<Serializable> values;

    private State(Map<String, Serializable> map) {
        this.map = map;
    }

    public State() {
        this(0, false);
    }

    public State(boolean threadSafe) {
        this(0, threadSafe);
    }

    public State(int size) {
        this(size, false);
    }

    public State(int size, boolean threadSafe) {
        if (threadSafe) {
            this.map = new ConcurrentHashMap<String, Serializable>(State.initialCapacity(size));
        } else if (size > 5) {
            this.map = new HashMap<String, Serializable>(State.initialCapacity(size));
        } else {
            this.keys = new ArrayList<String>(size);
            this.values = new ArrayList<Serializable>(size);
        }
    }

    protected static int initialCapacity(int size) {
        return Math.max((int)((float)size / 0.75f) + 1, 16);
    }

    public int size() {
        if (this.map != null) {
            return this.map.size();
        }
        return this.keys.size();
    }

    public boolean isEmpty() {
        if (this.map != null) {
            return this.map.isEmpty();
        }
        return this.keys.isEmpty();
    }

    public Serializable get(Object key) {
        if (this.map != null) {
            return this.map.get(key);
        }
        int i = this.keys.indexOf(key);
        return i >= 0 ? this.values.get(i) : null;
    }

    public void put(String key, Serializable value) {
        if (value == null) {
            if (this.map != null) {
                this.map.remove(key);
            } else {
                int i = this.keys.indexOf(key);
                if (i >= 0) {
                    this.keys.remove(i);
                    this.values.remove(i);
                }
            }
        } else {
            this.putEvenIfNull(key, value);
        }
    }

    protected void putEvenIfNull(String key, Serializable value) {
        if (this.map != null) {
            this.map.put(key, value);
        } else {
            int i = this.keys.indexOf(key);
            if (i >= 0) {
                this.values.set(i, value);
            } else if (this.keys.size() < 5) {
                this.keys.add(key);
                this.values.add(value);
            } else {
                this.map = new HashMap<String, Serializable>(State.initialCapacity(this.keys.size() + 1));
                for (int j = 0; j < this.keys.size(); ++j) {
                    this.map.put(this.keys.get(j), this.values.get(j));
                }
                this.map.put(key, value);
                this.keys = null;
                this.values = null;
            }
        }
    }

    public Serializable remove(Object key) {
        if (this.map != null) {
            return this.map.remove(key);
        }
        int i = this.keys.indexOf(key);
        if (i >= 0) {
            this.keys.remove(i);
            return this.values.remove(i);
        }
        return null;
    }

    public Set<String> keySet() {
        if (this.map != null) {
            return this.map.keySet();
        }
        return ImmutableSet.copyOf(this.keys);
    }

    public String[] keyArray() {
        if (this.map != null) {
            return this.map.keySet().toArray(EMPTY_STRING_ARRAY);
        }
        return this.keys.toArray(EMPTY_STRING_ARRAY);
    }

    public boolean containsKey(Object key) {
        if (this.map != null) {
            return this.map.containsKey(key);
        }
        return this.keys.contains(key);
    }

    public Set<Map.Entry<String, Serializable>> entrySet() {
        if (this.map != null) {
            return this.map.entrySet();
        }
        return new ArraysEntrySet();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean empty = true;
        for (String key : TO_STRING_KEY_ORDER) {
            if (!this.containsKey(key)) continue;
            if (!empty) {
                sb.append(", ");
            }
            empty = false;
            sb.append(key);
            sb.append('=');
            State.toString(sb, this.get(key));
        }
        Object[] keys = this.keyArray();
        Arrays.sort(keys);
        for (Object key : keys) {
            if (TO_STRING_KEY_ORDER.contains(key)) continue;
            if (!empty) {
                sb.append(", ");
            }
            empty = false;
            sb.append((String)key);
            sb.append('=');
            State.toString(sb, this.get(key));
        }
        sb.append('}');
        return sb.toString();
    }

    protected static void toString(StringBuilder sb, Object value) {
        if (value instanceof String) {
            Object v = (String)value;
            if (((String)v).length() > 100) {
                v = ((String)v).substring(0, 100) + "...(" + ((String)v).length() + " chars)...";
            }
            sb.append((String)v);
        } else if (value instanceof Calendar) {
            char sign;
            Calendar cal = (Calendar)value;
            int offset = cal.getTimeZone().getOffset(cal.getTimeInMillis()) / 60000;
            if (offset < 0) {
                offset = -offset;
                sign = '-';
            } else {
                sign = '+';
            }
            sb.append(String.format("Calendar(%04d-%02d-%02dT%02d:%02d:%02d.%03d%c%02d:%02d)", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14), Character.valueOf(sign), offset / 60, offset % 60));
        } else if (value instanceof Object[]) {
            Object[] v = (Object[])value;
            sb.append('[');
            for (int i = 0; i < v.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                    if (i > 10) {
                        sb.append("...(").append(v.length).append(" items)...");
                        break;
                    }
                }
                State.toString(sb, v[i]);
            }
            sb.append(']');
        } else {
            sb.append(value);
        }
    }

    @Override
    public Object getSingle(String name) {
        Serializable object = this.get(name);
        if (object instanceof Object[]) {
            Object[] array = (Object[])object;
            if (array.length == 0) {
                return null;
            }
            if (array.length == 1) {
                return array[0];
            }
            log.warn((Object)("Property " + name + ": expected a simple value but read an array: " + Arrays.toString(array)));
            return array[0];
        }
        return object;
    }

    @Override
    public Object[] getArray(String name) {
        Serializable object = this.get(name);
        if (object == null) {
            return null;
        }
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        return new Object[]{object};
    }

    @Override
    public void setSingle(String name, Object value) {
        this.put(name, (Serializable)value);
    }

    @Override
    public void setArray(String name, Object[] value) {
        this.put(name, (Serializable)value);
    }

    public boolean equals(Object other) {
        return StateHelper.equalsStrict((Object)this, other);
    }

    public class ArraysEntry
    implements Map.Entry<String, Serializable> {
        private final int index;

        public ArraysEntry(int index) {
            this.index = index;
        }

        @Override
        public String getKey() {
            return State.this.keys.get(this.index);
        }

        @Override
        public Serializable getValue() {
            return State.this.values.get(this.index);
        }

        @Override
        public Serializable setValue(Serializable value) {
            throw new UnsupportedOperationException();
        }
    }

    public class ArraysEntryIterator
    implements Iterator<Map.Entry<String, Serializable>> {
        private int index;

        @Override
        public boolean hasNext() {
            return this.index < State.this.keys.size();
        }

        @Override
        public Map.Entry<String, Serializable> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return new ArraysEntry(this.index++);
        }
    }

    protected class ArraysEntrySet
    implements Set<Map.Entry<String, Serializable>> {
        protected ArraysEntrySet() {
        }

        @Override
        public int size() {
            return State.this.keys.size();
        }

        @Override
        public boolean isEmpty() {
            return State.this.keys.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<String, Serializable>> iterator() {
            return new ArraysEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Map.Entry<String, Serializable> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<String, Serializable>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    public static class ListDiff
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public boolean isArray;
        public List<Object> diff;
        public List<Object> rpush;

        public String toString() {
            return this.getClass().getSimpleName() + "(" + (this.isArray ? "array" : "list") + (String)(this.diff == null ? "" : ", DIFF " + this.diff) + (String)(this.rpush == null ? "" : ", RPUSH " + this.rpush) + ")";
        }
    }

    private static enum Nop {
        NOP;

    }

    public static class StateDiff
    extends State {
        private static final long serialVersionUID = 1L;

        @Override
        public void put(String key, Serializable value) {
            this.putEvenIfNull(key, value);
        }
    }
}

