/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.task;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.task.AbstractTaskOperation;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.task.dashboard.DashBoardItem;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Workflow.UserTaskPageProvider", category="Services", label="UserTaskPageProvider", description="Returns the tasks waiting for the current user.", addToStudio=false)
public class UserTaskPageProviderOperation
extends AbstractTaskOperation {
    public static final String ID = "Workflow.UserTaskPageProvider";
    public static final String USER_TASKS_PAGE_PROVIDER = "user_tasks";
    @Param(name="language", required=false)
    protected String language;
    @Param(name="page", required=false)
    protected Integer page;
    @Param(name="pageSize", required=false)
    protected Integer pageSize;
    @Context
    protected CoreSession session;
    @Context
    protected DocumentViewCodecManager documentViewCodecManager;

    @OperationMethod
    public Blob run() throws IOException {
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
        Long targetPage = null;
        if (this.page != null) {
            targetPage = this.page.longValue();
        }
        Long targetPageSize = null;
        if (this.pageSize != null) {
            targetPageSize = this.pageSize.longValue();
        }
        PageProvider pageProvider = pps.getPageProvider(USER_TASKS_PAGE_PROVIDER, null, targetPageSize, targetPage, props, new Object[0]);
        Locale locale = this.language != null && !this.language.isEmpty() ? new Locale(this.language) : Locale.ENGLISH;
        ArrayList<Map> processes = new ArrayList<Map>();
        for (DashBoardItem dashBoardItem : pageProvider.getCurrentPage()) {
            dashBoardItem.setLocale(locale);
            Map obj = dashBoardItem.asMap();
            processes.add(obj);
        }
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        json.put("isPaginable", Boolean.TRUE);
        json.put("totalSize", pageProvider.getResultsCount());
        json.put("pageIndex", pageProvider.getCurrentPageIndex());
        json.put("pageSize", pageProvider.getPageSize());
        json.put("pageCount", pageProvider.getNumberOfPages());
        json.put("entries", processes);
        return Blobs.createJSONBlobFromValue(json);
    }
}

