/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.blob;

import java.util.List;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.collectors.BlobListCollector;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;

@Operation(id="Document.GetBlobs", category="Files", label="Get All Document Files", description="Gets a list of all blobs that are attached on the input document. Returns a list of files.", aliases={"Blob.GetAll"})
public class GetAllDocumentBlobs {
    public static final String ID = "Document.GetBlobs";

    @OperationMethod(collector=BlobListCollector.class)
    public BlobList run(DocumentModel doc) {
        BlobList blobs = new BlobList();
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (bh != null) {
            List docBlobs = bh.getBlobs();
            if (docBlobs != null && !docBlobs.isEmpty()) {
                for (Blob blob : docBlobs) {
                    blobs.add(blob);
                }
                return blobs;
            }
            return null;
        }
        return null;
    }
}

