/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.util;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.nuxeo.ecm.automation.core.util.JSONBlobDecoder;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;

public class JSONStringBlobDecoder
implements JSONBlobDecoder {
    @Override
    public Blob getBlobFromJSON(ObjectNode jsonObject) {
        String filename = null;
        if (jsonObject.has("filename")) {
            filename = jsonObject.get("filename").textValue();
        }
        if (filename == null && jsonObject.has("name")) {
            filename = jsonObject.get("name").textValue();
        }
        String encoding = "UTF-8";
        if (jsonObject.has("encoding")) {
            encoding = jsonObject.get("encoding").textValue();
        }
        String mimetype = "text/plain";
        if (jsonObject.has("mime-type")) {
            mimetype = jsonObject.get("mime-type").textValue();
        }
        String data = null;
        if (jsonObject.has("data")) {
            data = jsonObject.get("data").textValue();
            if (data.startsWith("http")) {
                data = null;
            }
        } else if (jsonObject.has("content")) {
            data = jsonObject.get("content").textValue();
        }
        if (data == null) {
            return null;
        }
        Blob blob = Blobs.createBlob((String)data, (String)mimetype, (String)encoding, (String)filename);
        return blob;
    }
}

