/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import java.io.Serializable;

public class Namespace
implements Serializable {
    public static final Namespace DEFAULT_NS = new Namespace();
    private static final long serialVersionUID = -3069469489908062592L;
    private static final String DEFAULT_PREFIX = "";
    private static final String DEFAULT_URI = "";
    public final String uri;
    public final String prefix;

    public Namespace(String uri, String prefix) {
        assert (uri != null);
        if (uri.length() == 0 && prefix.length() > 0) {
            throw new IllegalArgumentException("prefix cannot be not empty if the uri is empty");
        }
        this.uri = uri;
        this.prefix = prefix == null ? "" : prefix;
    }

    private Namespace() {
        this("", "");
    }

    public boolean hasPrefix() {
        return this.prefix.length() > 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Namespace) {
            Namespace ns = (Namespace)obj;
            return ns.uri.equals(this.uri) && ns.prefix.equals(this.prefix);
        }
        return false;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return this.uri + " [" + this.prefix + "]";
    }
}

