/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types;

import java.util.HashSet;
import org.nuxeo.ecm.core.schema.types.AbstractType;
import org.nuxeo.ecm.core.schema.types.PrimitiveType;
import org.nuxeo.ecm.core.schema.types.SimpleType;
import org.nuxeo.ecm.core.schema.types.TypeException;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolver;

public class SimpleTypeImpl
extends AbstractType
implements SimpleType {
    private static final long serialVersionUID = 1L;
    private ObjectResolver resolver;
    private PrimitiveType primitiveType;

    public SimpleTypeImpl(SimpleType superType, String schema, String name) {
        super(superType, schema, name);
        assert (superType != null);
        this.constraints = new HashSet();
    }

    @Override
    public boolean validate(Object object) throws TypeException {
        if (object == null) {
            return true;
        }
        if (this.validateConstraints(object)) {
            return this.getSuperType().validate(object);
        }
        return false;
    }

    @Override
    public PrimitiveType getPrimitiveType() {
        if (this.primitiveType == null) {
            this.primitiveType = ((SimpleType)this.getSuperType()).getPrimitiveType();
        }
        return this.primitiveType;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isSimpleType() {
        return true;
    }

    public void setResolver(ObjectResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public ObjectResolver getObjectResolver() {
        return this.resolver;
    }

    @Override
    public Object decode(String str) {
        return this.getPrimitiveType().decode(str);
    }

    @Override
    public String encode(Object value) {
        return this.getPrimitiveType().encode(value);
    }

    @Override
    public Object convert(Object value) throws TypeException {
        return this.getPrimitiveType().convert(value);
    }

    @Override
    public Object newInstance() {
        return this.getPrimitiveType().newInstance();
    }
}

