/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.actions.ActionPropertyListDescriptor;

@XObject(value="properties")
public class ActionPropertiesDescriptor {
    @XNode(value="@append")
    boolean append;
    @XNodeMap(value="property", key="@name", type=HashMap.class, componentType=String.class)
    Map<String, String> properties = new HashMap<String, String>();
    @XNodeMap(value="propertyList", key="@name", type=HashMap.class, componentType=ActionPropertyListDescriptor.class)
    Map<String, ActionPropertyListDescriptor> listProperties = new HashMap<String, ActionPropertyListDescriptor>();
    @XNodeMap(value="propertyMap", key="@name", type=HashMap.class, componentType=ActionPropertiesDescriptor.class)
    Map<String, ActionPropertiesDescriptor> mapProperties = new HashMap<String, ActionPropertiesDescriptor>();

    public HashMap<String, Serializable> getAllProperties() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.putAll(this.properties);
        for (Map.Entry<String, ActionPropertyListDescriptor> entry : this.listProperties.entrySet()) {
            map.put(entry.getKey(), (Serializable)entry.getValue().getValues());
        }
        for (Map.Entry<String, Object> entry : this.mapProperties.entrySet()) {
            map.put(entry.getKey(), ((ActionPropertiesDescriptor)entry.getValue()).getAllProperties());
        }
        return map;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, ActionPropertyListDescriptor> getListProperties() {
        return this.listProperties;
    }

    public void setListProperties(Map<String, ActionPropertyListDescriptor> listProperties) {
        this.listProperties = listProperties;
    }

    public Map<String, ActionPropertiesDescriptor> getMapProperties() {
        return this.mapProperties;
    }

    public void setMapProperties(Map<String, ActionPropertiesDescriptor> mapProperties) {
        this.mapProperties = mapProperties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void merge(ActionPropertiesDescriptor other) {
        if (other != null) {
            if (other.getProperties() != null) {
                if (this.properties == null) {
                    this.properties = other.getProperties();
                } else {
                    this.properties.putAll(other.getProperties());
                }
            }
            if (other.getListProperties() != null) {
                if (this.listProperties == null) {
                    this.listProperties = other.getListProperties();
                } else {
                    this.listProperties.putAll(other.getListProperties());
                }
            }
            if (other.getMapProperties() != null) {
                if (this.mapProperties == null) {
                    this.mapProperties = other.getMapProperties();
                } else {
                    this.mapProperties.putAll(other.getMapProperties());
                }
            }
        }
    }

    public ActionPropertiesDescriptor clone() {
        ActionPropertiesDescriptor clone = new ActionPropertiesDescriptor();
        if (this.properties != null) {
            clone.properties = new HashMap<String, String>(this.properties);
        }
        if (this.listProperties != null) {
            clone.listProperties = new HashMap<String, ActionPropertyListDescriptor>();
            for (Map.Entry<String, Object> entry : this.listProperties.entrySet()) {
                clone.listProperties.put(entry.getKey(), ((ActionPropertyListDescriptor)entry.getValue()).clone());
            }
        }
        if (this.mapProperties != null) {
            clone.mapProperties = new HashMap<String, ActionPropertiesDescriptor>();
            for (Map.Entry<String, Object> entry : this.mapProperties.entrySet()) {
                clone.mapProperties.put(entry.getKey(), ((ActionPropertiesDescriptor)entry.getValue()).clone());
            }
        }
        return clone;
    }
}

