/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.schema.ConcreteNameComponentNormalizer;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.aci.ACIItem;
import org.apache.directory.shared.ldap.aci.ACIItemParser;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.filter.AssertionEnum;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.NameComponentNormalizer;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.OidNormalizer;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleCache {
    private static final Logger log = LoggerFactory.getLogger(TupleCache.class);
    private final Hashtable<?, ?> env;
    private final Map<String, List<ACITuple>> tuples = new HashMap<String, List<ACITuple>>();
    private final PartitionNexus nexus;
    private final ACIItemParser aciParser;
    private AttributeTypeRegistry attributeTypeRegistry;
    private AttributeType prescriptiveAciAT;
    private Map<String, OidNormalizer> normalizerMap;

    public TupleCache(DirectoryServiceConfiguration factoryCfg) throws NamingException {
        this.normalizerMap = factoryCfg.getRegistries().getAttributeTypeRegistry().getNormalizerMapping();
        this.nexus = factoryCfg.getPartitionNexus();
        this.attributeTypeRegistry = factoryCfg.getRegistries().getAttributeTypeRegistry();
        OidRegistry oidRegistry = factoryCfg.getRegistries().getOidRegistry();
        ConcreteNameComponentNormalizer ncn = new ConcreteNameComponentNormalizer(this.attributeTypeRegistry, oidRegistry);
        this.aciParser = new ACIItemParser((NameComponentNormalizer)ncn, this.normalizerMap);
        this.env = (Hashtable)factoryCfg.getEnvironment().clone();
        this.prescriptiveAciAT = this.attributeTypeRegistry.lookup("prescriptiveACI");
        this.initialize();
    }

    private LdapDN parseNormalized(String name) throws NamingException {
        LdapDN dn = new LdapDN(name);
        dn.normalize(this.normalizerMap);
        return dn;
    }

    private void initialize() throws NamingException {
        Iterator<String> suffixes = this.nexus.listSuffixes(null);
        while (suffixes.hasNext()) {
            String suffix = suffixes.next();
            LdapDN baseDn = this.parseNormalized(suffix);
            SimpleNode filter = new SimpleNode("objectClass", "accessControlSubentry", AssertionEnum.EQUALITY);
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            NamingEnumeration<SearchResult> results = this.nexus.search(new SearchOperationContext(baseDn, this.env, (ExprNode)filter, ctls));
            while (results.hasMore()) {
                SearchResult result = results.next();
                String subentryDn = result.getName();
                Attribute aci = AttributeUtils.getAttribute((Attributes)result.getAttributes(), (AttributeType)this.prescriptiveAciAT);
                if (aci == null) {
                    log.warn("Found accessControlSubentry '" + subentryDn + "' without any " + "prescriptiveACI");
                    continue;
                }
                LdapDN normName = this.parseNormalized(subentryDn);
                this.subentryAdded(subentryDn, normName, result.getAttributes());
            }
            results.close();
        }
    }

    private boolean hasPrescriptiveACI(Attributes entry) throws NamingException {
        Attribute aci = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.prescriptiveAciAT);
        if (aci == null) {
            if (AttributeUtils.containsValueCaseIgnore((Attribute)entry.get("objectClass"), (Object)"accessControlSubentry") || AttributeUtils.containsValueCaseIgnore((Attribute)entry.get("objectClass"), (Object)"2.5.17.1")) {
                throw new LdapSchemaViolationException("", ResultCodeEnum.OBJECT_CLASS_VIOLATION);
            }
            return false;
        }
        return true;
    }

    public void subentryAdded(String upName, LdapDN normName, Attributes entry) throws NamingException {
        Attribute aci = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)this.prescriptiveAciAT);
        if (!this.hasPrescriptiveACI(entry)) {
            return;
        }
        ArrayList entryTuples = new ArrayList();
        for (int ii = 0; ii < aci.size(); ++ii) {
            ACIItem item = null;
            String aciStr = (String)aci.get(ii);
            try {
                item = this.aciParser.parse(aciStr);
                entryTuples.addAll(item.toTuples());
                continue;
            }
            catch (ParseException e) {
                String msg = "ACIItem parser failure on \n'" + item + "'\ndue to syntax error. " + "Cannnot add ACITuples to TupleCache.\n" + "Check that the syntax of the ACI item is correct. \nUntil this error " + "is fixed your security settings will not be as expected.";
                log.error(msg, (Throwable)e);
            }
        }
        this.tuples.put(normName.toNormName(), entryTuples);
    }

    public void subentryDeleted(Name normName, Attributes entry) throws NamingException {
        if (!this.hasPrescriptiveACI(entry)) {
            return;
        }
        this.tuples.remove(normName.toString());
    }

    public void subentryModified(LdapDN normName, ModificationItemImpl[] mods, Attributes entry) throws NamingException {
        if (!this.hasPrescriptiveACI(entry)) {
            return;
        }
        for (int ii = 0; ii < mods.length; ++ii) {
            String attrID = mods[ii].getAttribute().getID();
            if (!attrID.equalsIgnoreCase("prescriptiveACI") && !attrID.equalsIgnoreCase("2.5.24.4")) continue;
            this.subentryDeleted((Name)normName, entry);
            this.subentryAdded(normName.getUpName(), normName, entry);
        }
    }

    public void subentryModified(LdapDN normName, int modOp, Attributes mods, Attributes entry) throws NamingException {
        if (!this.hasPrescriptiveACI(entry)) {
            return;
        }
        if (AttributeUtils.getAttribute((Attributes)mods, (AttributeType)this.prescriptiveAciAT) != null) {
            this.subentryDeleted((Name)normName, entry);
            this.subentryAdded(normName.getUpName(), normName, entry);
        }
    }

    public List<ACITuple> getACITuples(String subentryDn) {
        List<ACITuple> aciTuples = this.tuples.get(subentryDn);
        if (aciTuples == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(aciTuples);
    }

    public void subentryRenamed(Name oldName, Name newName) {
        this.tuples.put(newName.toString(), this.tuples.remove(oldName.toString()));
    }
}

