/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.event.EventContext;
import javax.naming.event.NamingListener;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.PartitionConfiguration;
import org.apache.directory.server.core.enumeration.SearchResultFilter;
import org.apache.directory.server.core.enumeration.SearchResultFilteringEnumeration;
import org.apache.directory.server.core.event.EventService;
import org.apache.directory.server.core.interceptor.InterceptorChain;
import org.apache.directory.server.core.interceptor.context.AddContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.GetSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.ListSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RemoveContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.shared.ldap.exception.LdapSizeLimitExceededException;
import org.apache.directory.shared.ldap.exception.LdapTimeLimitExceededException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.name.LdapDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionNexusProxy
extends PartitionNexus {
    public static final Collection<String> LOOKUP_BYPASS;
    public static final Collection<String> GETMATCHEDDN_BYPASS;
    public static final Collection<String> LOOKUP_EXCLUDING_OPR_ATTRS_BYPASS;
    public static final String BYPASS_ALL = "*";
    public static final Collection<String> BYPASS_ALL_COLLECTION;
    private static Attributes ROOT_DSE_ALL;
    private static Attributes ROOT_DSE_NO_OPERATIONNAL;
    private static final Object ROOT_DSE_ALL_MUTEX;
    private static final Object ROOT_DSE_NOOP_MUTEX;
    private final Context caller;
    private final DirectoryService service;
    private final DirectoryServiceConfiguration configuration;

    public PartitionNexusProxy(Context caller, DirectoryService service) throws NamingException {
        this.caller = caller;
        this.service = service;
        this.configuration = service.getConfiguration();
    }

    @Override
    public LdapContext getLdapContext() {
        return this.configuration.getPartitionNexus().getLdapContext();
    }

    @Override
    public String getId() {
        throw new UnsupportedOperationException("Nexus partition proxy objects do not have an Id.");
    }

    @Override
    public PartitionConfiguration getConfiguration() {
        throw new UnsupportedOperationException("Nexus partition proxy objects do not have a partition configuration.");
    }

    @Override
    public void init(DirectoryServiceConfiguration factoryCfg, PartitionConfiguration cfg) throws NamingException {
    }

    @Override
    public void destroy() {
    }

    @Override
    public Partition getSystemPartition() {
        return this.configuration.getPartitionNexus().getSystemPartition();
    }

    @Override
    public Partition getPartition(LdapDN dn) throws NamingException {
        return this.configuration.getPartitionNexus().getPartition(dn);
    }

    @Override
    public LdapDN getSuffix() throws NamingException {
        return this.configuration.getPartitionNexus().getSuffix();
    }

    @Override
    public LdapDN getUpSuffix() throws NamingException {
        return this.configuration.getPartitionNexus().getUpSuffix();
    }

    @Override
    public void sync() throws NamingException {
        this.service.sync();
    }

    public void close() throws NamingException {
        this.service.shutdown();
    }

    @Override
    public boolean isInitialized() {
        return this.service.isStarted();
    }

    @Override
    public LdapDN getMatchedName(GetMatchedNameOperationContext opContext) throws NamingException {
        return this.getMatchedName(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapDN getMatchedName(GetMatchedNameOperationContext opContext, Collection<String> bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        Object[] args = new Object[]{opContext};
        stack.push(new Invocation(this, this.caller, "getMatchedName", args, bypass));
        try {
            LdapDN ldapDN = this.configuration.getInterceptorChain().getMatchedName(opContext);
            return ldapDN;
        }
        finally {
            stack.pop();
        }
    }

    @Override
    public LdapDN getSuffix(GetSuffixOperationContext opContext) throws NamingException {
        return this.getSuffix(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapDN getSuffix(GetSuffixOperationContext opContext, Collection<String> bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        Object[] args = new Object[]{opContext};
        stack.push(new Invocation(this, this.caller, "getSuffix", args, bypass));
        try {
            LdapDN ldapDN = this.configuration.getInterceptorChain().getSuffix(opContext);
            return ldapDN;
        }
        finally {
            stack.pop();
        }
    }

    @Override
    public Iterator<String> listSuffixes(ListSuffixOperationContext opContext) throws NamingException {
        return this.listSuffixes(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> listSuffixes(ListSuffixOperationContext opContext, Collection<String> bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        Object[] args = new Object[]{};
        stack.push(new Invocation(this, this.caller, "listSuffixes", args, bypass));
        try {
            Iterator<String> iterator = this.configuration.getInterceptorChain().listSuffixes(opContext);
            return iterator;
        }
        finally {
            stack.pop();
        }
    }

    @Override
    public boolean compare(CompareOperationContext opContext) throws NamingException {
        return this.compare(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compare(CompareOperationContext opContext, Collection<String> bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "compare", new Object[]{opContext}, bypass));
        try {
            boolean bl = this.configuration.getInterceptorChain().compare(opContext);
            return bl;
        }
        finally {
            stack.pop();
        }
    }

    @Override
    public void delete(DeleteOperationContext opContext) throws NamingException {
        this.delete(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(DeleteOperationContext opContext, Collection<String> bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "delete", new Object[]{opContext}, bypass));
        try {
            this.configuration.getInterceptorChain().delete(opContext);
        }
        finally {
            stack.pop();
        }
    }

    @Override
    public void add(AddOperationContext opContext) throws NamingException {
        this.add(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AddOperationContext opContext, Collection<String> bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "add", new Object[]{opContext}, bypass));
        try {
            this.configuration.getInterceptorChain().add(opContext);
        }
        finally {
            stack.pop();
        }
    }

    @Override
    public void modify(ModifyOperationContext opContext) throws NamingException {
        this.modify(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(ModifyOperationContext opContext, Collection<String> bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "modify", new Object[]{opContext}, bypass));
        try {
            this.configuration.getInterceptorChain().modify(opContext);
        }
        finally {
            stack.pop();
        }
    }

    @Override
    public NamingEnumeration<SearchResult> list(ListOperationContext opContext) throws NamingException {
        return this.list(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingEnumeration<SearchResult> list(ListOperationContext opContext, Collection<String> bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "list", new Object[]{opContext}, bypass));
        try {
            NamingEnumeration<SearchResult> namingEnumeration = this.configuration.getInterceptorChain().list(opContext);
            return namingEnumeration;
        }
        finally {
            stack.pop();
        }
    }

    @Override
    public NamingEnumeration<SearchResult> search(SearchOperationContext opContext) throws NamingException {
        NamingEnumeration<SearchResult> ne = this.search(opContext, null);
        if (ne instanceof SearchResultFilteringEnumeration) {
            SearchResultFilteringEnumeration results = (SearchResultFilteringEnumeration)ne;
            SearchControls searchCtls = opContext.getSearchControls();
            if ((long)searchCtls.getTimeLimit() + searchCtls.getCountLimit() > 0L) {
                results.addResultFilter(new SearchResultFilter(){
                    final long startTime = System.currentTimeMillis();
                    int count = 1;

                    public boolean accept(Invocation invocation, SearchResult result, SearchControls controls) throws NamingException {
                        long runtime;
                        if (controls.getTimeLimit() > 0 && (runtime = System.currentTimeMillis() - this.startTime) > (long)controls.getTimeLimit()) {
                            throw new LdapTimeLimitExceededException();
                        }
                        if (controls.getCountLimit() > 0L && (long)this.count > controls.getCountLimit()) {
                            throw new LdapSizeLimitExceededException();
                        }
                        ++this.count;
                        return true;
                    }
                });
            }
        }
        return ne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingEnumeration<SearchResult> search(SearchOperationContext opContext, Collection<String> bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "search", new Object[]{opContext}, bypass));
        try {
            NamingEnumeration<SearchResult> namingEnumeration = this.configuration.getInterceptorChain().search(opContext);
            return namingEnumeration;
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attributes lookup(LookupOperationContext opContext) throws NamingException {
        if (opContext.getDn().size() == 0) {
            List<String> attrs = opContext.getAttrsId();
            if (attrs == null || attrs.size() == 0) {
                Object object = ROOT_DSE_NOOP_MUTEX;
                synchronized (object) {
                    if (ROOT_DSE_NO_OPERATIONNAL == null) {
                        ROOT_DSE_NO_OPERATIONNAL = this.lookup(opContext, null);
                    }
                }
                return ROOT_DSE_NO_OPERATIONNAL;
            }
            if (attrs.size() == 1 && attrs.contains("+")) {
                Object object = ROOT_DSE_ALL_MUTEX;
                synchronized (object) {
                    if (ROOT_DSE_ALL == null) {
                        ROOT_DSE_ALL = this.lookup(opContext, null);
                    }
                }
                return ROOT_DSE_ALL;
            }
        }
        return this.lookup(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attributes lookup(LookupOperationContext opContext, Collection<String> bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "lookup", new Object[]{opContext}, bypass));
        try {
            Attributes attributes = this.configuration.getInterceptorChain().lookup(opContext);
            return attributes;
        }
        finally {
            stack.pop();
        }
    }

    @Override
    public boolean hasEntry(EntryOperationContext opContext) throws NamingException {
        return this.hasEntry(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEntry(EntryOperationContext opContext, Collection<String> bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "hasEntry", new Object[]{opContext}, bypass));
        try {
            boolean bl = this.configuration.getInterceptorChain().hasEntry(opContext);
            return bl;
        }
        finally {
            stack.pop();
        }
    }

    @Override
    public void rename(RenameOperationContext opContext) throws NamingException {
        this.rename(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(RenameOperationContext opContext, Collection<String> bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        Object[] args = new Object[]{opContext};
        stack.push(new Invocation(this, this.caller, "rename", args, bypass));
        try {
            this.configuration.getInterceptorChain().rename(opContext);
        }
        finally {
            stack.pop();
        }
    }

    @Override
    public void move(MoveOperationContext opContext) throws NamingException {
        this.move(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(MoveOperationContext opContext, Collection<String> bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "move", new Object[]{opContext}, bypass));
        try {
            this.configuration.getInterceptorChain().move(opContext);
        }
        finally {
            stack.pop();
        }
    }

    @Override
    public void moveAndRename(MoveAndRenameOperationContext opContext) throws NamingException {
        this.moveAndRename(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAndRename(MoveAndRenameOperationContext opContext, Collection<String> bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        Object[] args = new Object[]{opContext};
        stack.push(new Invocation(this, this.caller, "moveAndRename", args, bypass));
        try {
            this.configuration.getInterceptorChain().moveAndRename(opContext);
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(BindOperationContext opContext, Collection<String> bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        Object[] args = new Object[]{opContext};
        stack.push(new Invocation(this, this.caller, "bind", args, bypass));
        try {
            this.configuration.getInterceptorChain().bind(opContext);
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(UnbindOperationContext opContext, Collection<String> bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        Object[] args = new Object[]{opContext};
        stack.push(new Invocation(this, this.caller, "unbind", args, bypass));
        try {
            this.configuration.getInterceptorChain().unbind(opContext);
        }
        finally {
            stack.pop();
        }
    }

    @Override
    public void bind(BindOperationContext opContext) throws NamingException {
        this.bind(opContext, null);
    }

    @Override
    public void unbind(UnbindOperationContext opContext) throws NamingException {
        this.unbind(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attributes getRootDSE(GetRootDSEOperationContext opContext) throws NamingException {
        if (opContext.getDn().size() == 0) {
            Object object = ROOT_DSE_ALL_MUTEX;
            synchronized (object) {
                if (ROOT_DSE_ALL == null) {
                    ROOT_DSE_ALL = this.getRootDSE(null, null);
                }
            }
            return ROOT_DSE_ALL;
        }
        return this.getRootDSE(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attributes getRootDSE(GetRootDSEOperationContext opContext, Collection<String> bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "getRootDSE", null, bypass));
        try {
            Attributes attributes = this.configuration.getInterceptorChain().getRootDSE(opContext);
            return attributes;
        }
        finally {
            stack.pop();
        }
    }

    @Override
    public void addContextPartition(AddContextPartitionOperationContext opContext) throws NamingException {
        this.addContextPartition(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContextPartition(AddContextPartitionOperationContext opContext, Collection<String> bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "addContextPartition", new Object[]{opContext}, bypass));
        try {
            this.configuration.getInterceptorChain().addContextPartition(opContext);
        }
        finally {
            stack.pop();
        }
    }

    @Override
    public void removeContextPartition(RemoveContextPartitionOperationContext opContext) throws NamingException {
        this.removeContextPartition(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContextPartition(RemoveContextPartitionOperationContext opContext, Collection<String> bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "removeContextPartition", new Object[]{opContext}, bypass));
        try {
            this.configuration.getInterceptorChain().removeContextPartition(opContext);
        }
        finally {
            stack.pop();
        }
    }

    private void ensureStarted() throws ServiceUnavailableException {
        if (!this.service.isStarted()) {
            throw new ServiceUnavailableException("Directory service is not started.");
        }
    }

    @Override
    public void registerSupportedExtensions(Set<String> extensionOids) {
        this.configuration.getPartitionNexus().registerSupportedExtensions(extensionOids);
    }

    public void addNamingListener(EventContext ctx, Name name, ExprNode filter, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        InterceptorChain chain = this.configuration.getInterceptorChain();
        EventService interceptor = (EventService)chain.get("eventService");
        interceptor.addNamingListener(ctx, name, filter, searchControls, namingListener);
    }

    public void removeNamingListener(EventContext ctx, NamingListener namingListener) throws NamingException {
        InterceptorChain chain = this.configuration.getInterceptorChain();
        if (chain == null) {
            return;
        }
        EventService interceptor = (EventService)chain.get("eventService");
        interceptor.removeNamingListener(ctx, namingListener);
    }

    static {
        BYPASS_ALL_COLLECTION = Collections.singleton(BYPASS_ALL);
        ROOT_DSE_ALL_MUTEX = new Object();
        ROOT_DSE_NOOP_MUTEX = new Object();
        HashSet<String> c = new HashSet<String>();
        c.add("normalizationService");
        c.add("authenticationService");
        c.add("authorizationService");
        c.add("defaultAuthorizationService");
        c.add("schemaService");
        c.add("subentryService");
        c.add("operationalAttributeService");
        c.add("referralService");
        c.add("eventService");
        LOOKUP_BYPASS = Collections.unmodifiableCollection(c);
        c = new HashSet();
        c.add("authenticationService");
        c.add("authorizationService");
        c.add("defaultAuthorizationService");
        c.add("schemaService");
        c.add("subentryService");
        c.add("operationalAttributeService");
        c.add("referralService");
        c.add("eventService");
        GETMATCHEDDN_BYPASS = Collections.unmodifiableCollection(c);
        c = new HashSet();
        c.add("normalizationService");
        c.add("authenticationService");
        c.add("authorizationService");
        c.add("defaultAuthorizationService");
        c.add("schemaService");
        c.add("subentryService");
        c.add("referralService");
        c.add("eventService");
        c.add("triggerService");
        LOOKUP_EXCLUDING_OPR_ATTRS_BYPASS = Collections.unmodifiableCollection(c);
    }
}

