/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.Comparator;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.Evaluator;
import org.apache.directory.server.core.partition.impl.btree.Index;
import org.apache.directory.server.core.partition.impl.btree.IndexRecord;
import org.apache.directory.server.core.partition.impl.btree.ScopeEvaluator;
import org.apache.directory.server.core.partition.impl.btree.SubstringEvaluator;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.ByteArrayComparator;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.NoOpNormalizer;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.util.AttributeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeafEvaluator
implements Evaluator {
    private static final int EQUALITY_MATCH = 0;
    private static final int ORDERING_MATCH = 1;
    private static final int SUBSTRING_MATCH = 2;
    private BTreePartition db;
    private OidRegistry oidRegistry;
    private AttributeTypeRegistry attributeTypeRegistry;
    private SubstringEvaluator substringEvaluator;
    private ScopeEvaluator scopeEvaluator;

    public LeafEvaluator(BTreePartition db, OidRegistry oidRegistry, AttributeTypeRegistry attributeTypeRegistry, ScopeEvaluator scopeEvaluator, SubstringEvaluator substringEvaluator) {
        this.db = db;
        this.oidRegistry = oidRegistry;
        this.attributeTypeRegistry = attributeTypeRegistry;
        this.scopeEvaluator = scopeEvaluator;
        this.substringEvaluator = substringEvaluator;
    }

    public ScopeEvaluator getScopeEvaluator() {
        return this.scopeEvaluator;
    }

    public SubstringEvaluator getSubstringEvaluator() {
        return this.substringEvaluator;
    }

    @Override
    public boolean evaluate(ExprNode node, IndexRecord record) throws NamingException {
        if (node instanceof ScopeNode) {
            return this.scopeEvaluator.evaluate(node, record);
        }
        switch (((LeafNode)node).getAssertionType()) {
            case APPROXIMATE: {
                return this.evalEquality((SimpleNode)node, record);
            }
            case EQUALITY: {
                return this.evalEquality((SimpleNode)node, record);
            }
            case EXTENSIBLE: {
                throw new NotImplementedException();
            }
            case GREATEREQ: {
                return this.evalGreater((SimpleNode)node, record, true);
            }
            case LESSEQ: {
                return this.evalGreater((SimpleNode)node, record, false);
            }
            case PRESENCE: {
                String attrId = ((PresenceNode)node).getAttribute();
                return this.evalPresence(attrId, record);
            }
            case SUBSTRING: {
                return this.substringEvaluator.evaluate(node, record);
            }
        }
        throw new NamingException("Unrecognized leaf node type: " + ((LeafNode)node).getAssertionType());
    }

    private boolean evalGreater(SimpleNode node, IndexRecord record, boolean isGreater) throws NamingException {
        Attribute attr;
        String attrId = node.getAttribute();
        Long id = (Long)record.getEntryId();
        if (this.db.hasUserIndexOn(attrId)) {
            Index idx = this.db.getUserIndex(attrId);
            if (isGreater) {
                return idx.hasValue(node.getValue(), (Object)id, true);
            }
            return idx.hasValue(node.getValue(), (Object)id, false);
        }
        if (null == record.getAttributes()) {
            record.setAttributes(this.db.lookup(id));
        }
        if (null == (attr = AttributeUtils.getAttribute((Attributes)record.getAttributes(), (AttributeType)this.attributeTypeRegistry.lookup(node.getAttribute())))) {
            return false;
        }
        Normalizer normalizer = this.getNormalizer(attrId, 1);
        Comparator<Object> comparator = this.getComparator(attrId, 1);
        Object filterValue = node.getValue();
        NamingEnumeration<?> list = attr.getAll();
        if (isGreater) {
            while (list.hasMore()) {
                Object value = normalizer.normalize(list.next());
                if (0 < comparator.compare(filterValue, value)) continue;
                return true;
            }
        } else {
            while (list.hasMore()) {
                Object value = normalizer.normalize(list.next());
                if (0 > comparator.compare(filterValue, value)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean evalPresence(String attrId, IndexRecord rec) throws NamingException {
        Attributes attrs;
        if (this.db.hasUserIndexOn(attrId)) {
            Index idx = this.db.getExistanceIndex();
            return idx.hasValue((Object)attrId, rec.getEntryId());
        }
        if (null == rec.getAttributes()) {
            rec.setAttributes(this.db.lookup((Long)rec.getEntryId()));
        }
        if ((attrs = rec.getAttributes()) == null) {
            return false;
        }
        AttributeType type = this.attributeTypeRegistry.lookup(this.oidRegistry.getOid(attrId));
        return null != AttributeUtils.getAttribute((Attributes)attrs, (AttributeType)type);
    }

    private boolean evalEquality(SimpleNode node, IndexRecord rec) throws NamingException {
        AttributeType type;
        Attributes attrs;
        Attribute attr;
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getUserIndex(node.getAttribute());
            return idx.hasValue(node.getValue(), rec.getEntryId());
        }
        Normalizer normalizer = this.getNormalizer(node.getAttribute(), 0);
        Comparator<Object> comparator = this.getComparator(node.getAttribute(), 0);
        if (null == rec.getAttributes()) {
            rec.setAttributes(this.db.lookup((Long)rec.getEntryId()));
        }
        if (null == (attr = AttributeUtils.getAttribute((Attributes)(attrs = rec.getAttributes()), (AttributeType)(type = this.attributeTypeRegistry.lookup(node.getAttribute()))))) {
            return false;
        }
        Object filterValue = node.getValue();
        if (AttributeUtils.containsValue((Attribute)attr, (Object)node.getValue(), (AttributeType)type)) {
            return true;
        }
        NamingEnumeration<?> list = attr.getAll();
        while (list.hasMore()) {
            Object value = normalizer.normalize(list.next());
            if (0 != comparator.compare(value, filterValue)) continue;
            return true;
        }
        return false;
    }

    private Comparator<Object> getComparator(String attrId, int matchType) throws NamingException {
        MatchingRule mrule = this.getMatchingRule(attrId, matchType);
        if (mrule == null) {
            return ByteArrayComparator.INSTANCE;
        }
        return mrule.getComparator();
    }

    private Normalizer getNormalizer(String attrId, int matchType) throws NamingException {
        MatchingRule mrule = this.getMatchingRule(attrId, matchType);
        if (mrule == null) {
            return NoOpNormalizer.INSTANCE;
        }
        return mrule.getNormalizer();
    }

    private MatchingRule getMatchingRule(String attrId, int matchType) throws NamingException {
        MatchingRule mrule = null;
        String oid = this.oidRegistry.getOid(attrId);
        AttributeType type = this.attributeTypeRegistry.lookup(oid);
        switch (matchType) {
            case 0: {
                mrule = type.getEquality();
                break;
            }
            case 2: {
                mrule = type.getSubstr();
                break;
            }
            case 1: {
                mrule = type.getOrdering();
                break;
            }
            default: {
                throw new NamingException("Unknown match type: " + matchType);
            }
        }
        if (matchType != 0 && mrule == null) {
            return this.getMatchingRule(attrId, 0);
        }
        return mrule;
    }
}

