/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.dropwizard5;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Histogram;
import io.dropwizard.metrics5.Meter;
import io.dropwizard.metrics5.MetricFilter;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Snapshot;
import io.dropwizard.metrics5.Timer;
import io.opencensus.common.Clock;
import io.opencensus.common.Timestamp;
import io.opencensus.contrib.dropwizard5.DropWizardUtils;
import io.opencensus.implcore.common.MillisClock;
import io.opencensus.internal.Utils;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.export.Metric;
import io.opencensus.metrics.export.MetricDescriptor;
import io.opencensus.metrics.export.MetricProducer;
import io.opencensus.metrics.export.Point;
import io.opencensus.metrics.export.Summary;
import io.opencensus.metrics.export.TimeSeries;
import io.opencensus.metrics.export.Value;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class DropWizardMetrics
extends MetricProducer {
    static final String DEFAULT_UNIT = "1";
    static final String NS_UNIT = "ns";
    private final List<MetricRegistry> metricRegistryList;
    private final MetricFilter metricFilter;
    private final Clock clock;
    private final Timestamp cumulativeStartTimestamp;

    public DropWizardMetrics(List<MetricRegistry> metricRegistryList) {
        this(metricRegistryList, MetricFilter.ALL);
    }

    public DropWizardMetrics(List<MetricRegistry> metricRegistryList, MetricFilter metricFilter) {
        Utils.checkListElementNotNull((List)((List)Utils.checkNotNull(metricRegistryList, (Object)"metricRegistryList")), (Object)"metricRegistry");
        this.metricRegistryList = metricRegistryList;
        this.metricFilter = (MetricFilter)Utils.checkNotNull((Object)metricFilter, (Object)"metricFilter");
        this.clock = MillisClock.getInstance();
        this.cumulativeStartTimestamp = this.clock.now();
    }

    @Nullable
    private Metric collectGauge(MetricName dropwizardMetric, Gauge gauge) {
        Value value;
        MetricDescriptor.Type type;
        String metricName = DropWizardUtils.generateFullMetricName(dropwizardMetric.getKey(), "gauge");
        String metricDescription = DropWizardUtils.generateFullMetricDescription(dropwizardMetric.getKey(), (io.dropwizard.metrics5.Metric)gauge);
        AbstractMap.SimpleImmutableEntry<List<LabelKey>, List<LabelValue>> labels = DropWizardUtils.generateLabels(dropwizardMetric);
        Object obj = gauge.getValue();
        if (obj instanceof Number) {
            type = MetricDescriptor.Type.GAUGE_DOUBLE;
            value = Value.doubleValue((double)((Number)obj).doubleValue());
        } else if (obj instanceof Boolean) {
            type = MetricDescriptor.Type.GAUGE_INT64;
            value = Value.longValue((long)((Boolean)obj != false ? 1L : 0L));
        } else {
            return null;
        }
        MetricDescriptor metricDescriptor = MetricDescriptor.create((String)metricName, (String)metricDescription, (String)DEFAULT_UNIT, (MetricDescriptor.Type)type, labels.getKey());
        TimeSeries timeSeries = TimeSeries.createWithOnePoint(labels.getValue(), (Point)Point.create((Value)value, (Timestamp)this.clock.now()), null);
        return Metric.createWithOneTimeSeries((MetricDescriptor)metricDescriptor, (TimeSeries)timeSeries);
    }

    private Metric collectCounter(MetricName dropwizardMetric, Counter counter) {
        String metricName = DropWizardUtils.generateFullMetricName(dropwizardMetric.getKey(), "counter");
        String metricDescription = DropWizardUtils.generateFullMetricDescription(dropwizardMetric.getKey(), (io.dropwizard.metrics5.Metric)counter);
        AbstractMap.SimpleImmutableEntry<List<LabelKey>, List<LabelValue>> labels = DropWizardUtils.generateLabels(dropwizardMetric);
        MetricDescriptor metricDescriptor = MetricDescriptor.create((String)metricName, (String)metricDescription, (String)DEFAULT_UNIT, (MetricDescriptor.Type)MetricDescriptor.Type.GAUGE_INT64, labels.getKey());
        TimeSeries timeSeries = TimeSeries.createWithOnePoint(labels.getValue(), (Point)Point.create((Value)Value.longValue((long)counter.getCount()), (Timestamp)this.clock.now()), null);
        return Metric.createWithOneTimeSeries((MetricDescriptor)metricDescriptor, (TimeSeries)timeSeries);
    }

    private Metric collectMeter(MetricName dropwizardMetric, Meter meter) {
        String metricName = DropWizardUtils.generateFullMetricName(dropwizardMetric.getKey(), "meter");
        String metricDescription = DropWizardUtils.generateFullMetricDescription(dropwizardMetric.getKey(), (io.dropwizard.metrics5.Metric)meter);
        AbstractMap.SimpleImmutableEntry<List<LabelKey>, List<LabelValue>> labels = DropWizardUtils.generateLabels(dropwizardMetric);
        MetricDescriptor metricDescriptor = MetricDescriptor.create((String)metricName, (String)metricDescription, (String)DEFAULT_UNIT, (MetricDescriptor.Type)MetricDescriptor.Type.CUMULATIVE_INT64, labels.getKey());
        TimeSeries timeSeries = TimeSeries.createWithOnePoint(labels.getValue(), (Point)Point.create((Value)Value.longValue((long)meter.getCount()), (Timestamp)this.clock.now()), (Timestamp)this.cumulativeStartTimestamp);
        return Metric.createWithOneTimeSeries((MetricDescriptor)metricDescriptor, (TimeSeries)timeSeries);
    }

    private Metric collectHistogram(MetricName dropwizardMetric, Histogram histogram) {
        String metricName = DropWizardUtils.generateFullMetricName(dropwizardMetric.getKey(), "histogram");
        String metricDescription = DropWizardUtils.generateFullMetricDescription(dropwizardMetric.getKey(), (io.dropwizard.metrics5.Metric)histogram);
        AbstractMap.SimpleImmutableEntry<List<LabelKey>, List<LabelValue>> labels = DropWizardUtils.generateLabels(dropwizardMetric);
        return this.collectSnapshotAndCount(metricName, metricDescription, labels.getKey(), labels.getValue(), DEFAULT_UNIT, histogram.getSnapshot(), histogram.getCount());
    }

    private Metric collectTimer(MetricName dropwizardMetric, Timer timer) {
        String metricName = DropWizardUtils.generateFullMetricName(dropwizardMetric.getKey(), "timer");
        String metricDescription = DropWizardUtils.generateFullMetricDescription(dropwizardMetric.getKey(), (io.dropwizard.metrics5.Metric)timer);
        AbstractMap.SimpleImmutableEntry<List<LabelKey>, List<LabelValue>> labels = DropWizardUtils.generateLabels(dropwizardMetric);
        return this.collectSnapshotAndCount(metricName, metricDescription, labels.getKey(), labels.getValue(), NS_UNIT, timer.getSnapshot(), timer.getCount());
    }

    private Metric collectSnapshotAndCount(String metricName, String metricDescription, List<LabelKey> labelKeys, List<LabelValue> labelValues, String unit, Snapshot codahaleSnapshot, long count) {
        List<Summary.Snapshot.ValueAtPercentile> valueAtPercentiles = Arrays.asList(Summary.Snapshot.ValueAtPercentile.create((double)50.0, (double)codahaleSnapshot.getMedian()), Summary.Snapshot.ValueAtPercentile.create((double)75.0, (double)codahaleSnapshot.get75thPercentile()), Summary.Snapshot.ValueAtPercentile.create((double)98.0, (double)codahaleSnapshot.get98thPercentile()), Summary.Snapshot.ValueAtPercentile.create((double)99.0, (double)codahaleSnapshot.get99thPercentile()), Summary.Snapshot.ValueAtPercentile.create((double)99.9, (double)codahaleSnapshot.get999thPercentile()));
        Summary.Snapshot snapshot = Summary.Snapshot.create((Long)Long.valueOf(codahaleSnapshot.size()), (Double)0.0, valueAtPercentiles);
        Point point = Point.create((Value)Value.summaryValue((Summary)Summary.create((Long)count, (Double)0.0, (Summary.Snapshot)snapshot)), (Timestamp)this.clock.now());
        MetricDescriptor metricDescriptor = MetricDescriptor.create((String)metricName, (String)metricDescription, (String)unit, (MetricDescriptor.Type)MetricDescriptor.Type.SUMMARY, labelKeys);
        TimeSeries timeSeries = TimeSeries.createWithOnePoint(labelValues, (Point)point, (Timestamp)this.cumulativeStartTimestamp);
        return Metric.createWithOneTimeSeries((MetricDescriptor)metricDescriptor, (TimeSeries)timeSeries);
    }

    public Collection<Metric> getMetrics() {
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        for (MetricRegistry metricRegistry : this.metricRegistryList) {
            for (Map.Entry counterEntry : metricRegistry.getCounters(this.metricFilter).entrySet()) {
                metrics.add(this.collectCounter((MetricName)counterEntry.getKey(), (Counter)counterEntry.getValue()));
            }
            for (Map.Entry gaugeEntry : metricRegistry.getGauges(this.metricFilter).entrySet()) {
                Metric metric = this.collectGauge((MetricName)gaugeEntry.getKey(), (Gauge)gaugeEntry.getValue());
                if (metric == null) continue;
                metrics.add(metric);
            }
            for (Map.Entry counterEntry : metricRegistry.getMeters(this.metricFilter).entrySet()) {
                metrics.add(this.collectMeter((MetricName)counterEntry.getKey(), (Meter)counterEntry.getValue()));
            }
            for (Map.Entry counterEntry : metricRegistry.getHistograms(this.metricFilter).entrySet()) {
                metrics.add(this.collectHistogram((MetricName)counterEntry.getKey(), (Histogram)counterEntry.getValue()));
            }
            for (Map.Entry counterEntry : metricRegistry.getTimers(this.metricFilter).entrySet()) {
                metrics.add(this.collectTimer((MetricName)counterEntry.getKey(), (Timer)counterEntry.getValue()));
            }
        }
        return metrics;
    }
}

