/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb;

import com.mongodb.MongoException;
import com.mongodb.MongoWriteException;
import com.novemberain.quartz.mongodb.LockManager;
import com.novemberain.quartz.mongodb.TriggerAndJobPersister;
import com.novemberain.quartz.mongodb.cluster.TriggerRecoverer;
import com.novemberain.quartz.mongodb.dao.CalendarDao;
import com.novemberain.quartz.mongodb.dao.JobDao;
import com.novemberain.quartz.mongodb.dao.LocksDao;
import com.novemberain.quartz.mongodb.dao.TriggerDao;
import com.novemberain.quartz.mongodb.trigger.MisfireHandler;
import com.novemberain.quartz.mongodb.trigger.TriggerConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.TriggerKey;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.spi.TriggerFiredResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerRunner {
    private static final Logger log = LoggerFactory.getLogger(TriggerRunner.class);
    private static final Comparator<OperableTrigger> NEXT_FIRE_TIME_COMPARATOR = new Comparator<OperableTrigger>(){

        @Override
        public int compare(OperableTrigger o1, OperableTrigger o2) {
            return (int)(o1.getNextFireTime().getTime() - o2.getNextFireTime().getTime());
        }
    };
    private MisfireHandler misfireHandler;
    private TriggerAndJobPersister persister;
    private TriggerDao triggerDao;
    private TriggerConverter triggerConverter;
    private LockManager lockManager;
    private TriggerRecoverer recoverer;
    private JobDao jobDao;
    private LocksDao locksDao;
    private CalendarDao calendarDao;

    public TriggerRunner(TriggerAndJobPersister persister, TriggerDao triggerDao, JobDao jobDao, LocksDao locksDao, CalendarDao calendarDao, MisfireHandler misfireHandler, TriggerConverter triggerConverter, LockManager lockManager, TriggerRecoverer recoverer) {
        this.persister = persister;
        this.triggerDao = triggerDao;
        this.jobDao = jobDao;
        this.locksDao = locksDao;
        this.calendarDao = calendarDao;
        this.misfireHandler = misfireHandler;
        this.triggerConverter = triggerConverter;
        this.lockManager = lockManager;
        this.recoverer = recoverer;
    }

    public List<OperableTrigger> acquireNext(long noLaterThan, int maxCount, long timeWindow) throws JobPersistenceException {
        Date noLaterThanDate = new Date(noLaterThan + timeWindow);
        log.debug("Finding up to {} triggers which have time less than {}", (Object)maxCount, (Object)noLaterThanDate);
        List<OperableTrigger> triggers = this.acquireNextTriggers(noLaterThanDate, maxCount);
        Collections.sort(triggers, NEXT_FIRE_TIME_COMPARATOR);
        return triggers;
    }

    public List<TriggerFiredResult> triggersFired(List<OperableTrigger> triggers) throws JobPersistenceException {
        ArrayList<TriggerFiredResult> results = new ArrayList<TriggerFiredResult>(triggers.size());
        try {
            for (OperableTrigger trigger : triggers) {
                log.debug("Fired trigger {}", (Object)trigger.getKey());
                TriggerFiredBundle bundle = this.createTriggerFiredBundle(trigger);
                if (!this.hasJobDetail(bundle)) continue;
                JobDetail job = bundle.getJobDetail();
                try {
                    this.lockManager.lockJob(job);
                    results.add(new TriggerFiredResult(bundle));
                    this.persister.storeTrigger(trigger, true);
                }
                catch (MongoWriteException dk) {
                    log.debug("Job disallows concurrent execution and is already running {}", (Object)job.getKey());
                    this.locksDao.unlockTrigger(trigger);
                    this.lockManager.unlockExpired(job);
                }
            }
        }
        catch (MongoException e) {
            log.error("acquireNextTriggers failed due to MongoException: " + e.getMessage(), (Throwable)e);
            throw new JobPersistenceException("acquireNextTriggers failed due to MongoException: ", (Throwable)e);
        }
        return results;
    }

    private List<OperableTrigger> acquireNextTriggers(Date noLaterThanDate, int maxCount) throws JobPersistenceException {
        HashMap<TriggerKey, OperableTrigger> triggers = new HashMap<TriggerKey, OperableTrigger>();
        try {
            for (Document triggerDoc : this.triggerDao.findEligibleToRun(noLaterThanDate)) {
                if (!this.acquiredEnough(triggers, maxCount)) {
                    OperableTrigger trigger = this.triggerConverter.toTriggerWithOptionalJob(triggerDoc);
                    if (this.cannotAcquire(triggers, trigger)) continue;
                    if (trigger.getJobKey() == null) {
                        log.error("Error retrieving job for trigger {}, setting trigger state to ERROR.", (Object)trigger.getKey());
                        this.triggerDao.transferState(trigger.getKey(), "waiting", "error");
                        continue;
                    }
                    TriggerKey key = trigger.getKey();
                    if (this.lockManager.tryLock(key)) {
                        if (this.prepareForFire(noLaterThanDate, trigger)) {
                            log.info("Acquired trigger: {}", (Object)trigger.getKey());
                            triggers.put(trigger.getKey(), trigger);
                            continue;
                        }
                        triggers.put(trigger.getKey(), trigger);
                        this.lockManager.unlockAcquiredTrigger(trigger);
                        triggers.remove(trigger.getKey());
                        continue;
                    }
                    if (!this.lockManager.relockExpired(key)) continue;
                    log.info("Recovering trigger: {}", (Object)trigger.getKey());
                    OperableTrigger recoveryTrigger = this.recoverer.doRecovery(trigger);
                    this.lockManager.unlockAcquiredTrigger(trigger);
                    if (recoveryTrigger == null || !this.lockManager.tryLock(recoveryTrigger.getKey())) continue;
                    log.info("Acquired trigger: {}", (Object)recoveryTrigger.getKey());
                    triggers.put(recoveryTrigger.getKey(), recoveryTrigger);
                    continue;
                }
                break;
            }
        }
        catch (MongoException e) {
            for (OperableTrigger triggerDoc : triggers.values()) {
                this.lockManager.unlockAcquiredTrigger(triggerDoc);
            }
            log.error("acquireNextTriggers failed due to MongoException: " + e.getMessage(), (Throwable)e);
            throw new JobPersistenceException("acquireNextTriggers failed due to MongoException: ", (Throwable)e);
        }
        return new ArrayList<OperableTrigger>(triggers.values());
    }

    private boolean prepareForFire(Date noLaterThanDate, OperableTrigger trigger) throws JobPersistenceException {
        if (this.persister.removeTriggerWithoutNextFireTime(trigger)) {
            return false;
        }
        return !this.notAcquirableAfterMisfire(noLaterThanDate, trigger);
    }

    private boolean acquiredEnough(Map<TriggerKey, OperableTrigger> triggers, int maxCount) {
        return maxCount <= triggers.size();
    }

    private boolean cannotAcquire(Map<TriggerKey, OperableTrigger> triggers, OperableTrigger trigger) {
        if (trigger == null) {
            return true;
        }
        if (triggers.containsKey(trigger.getKey())) {
            log.debug("Skipping trigger {} as we have already acquired it.", (Object)trigger.getKey());
            return true;
        }
        return false;
    }

    private TriggerFiredBundle createTriggerFiredBundle(OperableTrigger trigger) throws JobPersistenceException {
        Calendar cal = this.calendarDao.retrieveCalendar(trigger.getCalendarName());
        if (this.expectedCalendarButNotFound(trigger, cal)) {
            return null;
        }
        Date prevFireTime = trigger.getPreviousFireTime();
        trigger.triggered(cal);
        return new TriggerFiredBundle(this.retrieveJob(trigger), trigger, cal, this.isRecovering(trigger), new Date(), trigger.getPreviousFireTime(), prevFireTime, trigger.getNextFireTime());
    }

    private boolean expectedCalendarButNotFound(OperableTrigger trigger, Calendar cal) {
        return trigger.getCalendarName() != null && cal == null;
    }

    private boolean isRecovering(OperableTrigger trigger) {
        return trigger.getKey().getGroup().equals("RECOVERING_JOBS");
    }

    private boolean hasJobDetail(TriggerFiredBundle bundle) {
        return bundle != null && bundle.getJobDetail() != null;
    }

    private boolean notAcquirableAfterMisfire(Date noLaterThanDate, OperableTrigger trigger) throws JobPersistenceException {
        if (this.misfireHandler.applyMisfire(trigger)) {
            this.persister.storeTrigger(trigger, true);
            log.debug("Misfire trigger {}.", (Object)trigger.getKey());
            if (this.persister.removeTriggerWithoutNextFireTime(trigger)) {
                return true;
            }
            if (trigger.getNextFireTime().after(noLaterThanDate)) {
                log.debug("Skipping trigger {} as it misfired and was scheduled for {}.", (Object)trigger.getKey(), (Object)trigger.getNextFireTime());
                return true;
            }
        }
        return false;
    }

    private JobDetail retrieveJob(OperableTrigger trigger) throws JobPersistenceException {
        try {
            return this.jobDao.retrieveJob(trigger.getJobKey());
        }
        catch (JobPersistenceException e) {
            this.locksDao.unlockTrigger(trigger);
            throw e;
        }
    }
}

