/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.bson.Document;
import org.nuxeo.ecm.core.api.trash.TrashService;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.BooleanLiteral;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.IntegerLiteral;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.SelectClause;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.core.storage.ExpressionEvaluator;
import org.nuxeo.ecm.core.storage.FulltextQueryAnalyzer;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBAbstractQueryBuilder;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepository;
import org.nuxeo.runtime.api.Framework;

public class MongoDBRepositoryQueryBuilder
extends MongoDBAbstractQueryBuilder {
    protected final SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
    protected final String idKey;
    protected List<String> documentTypes;
    protected final SelectClause selectClause;
    protected final OrderByClause orderByClause;
    protected final ExpressionEvaluator.PathResolver pathResolver;
    public boolean hasFulltext;
    public boolean sortOnFulltextScore;
    protected Document orderBy;
    protected Document projection;
    protected Map<String, String> propertyKeys;
    boolean projectionHasWildcard;
    private boolean fulltextSearchDisabled;
    protected static final Pattern NON_CANON_INDEX = Pattern.compile("[^/\\[\\]]+\\[(\\d+|\\*|\\*\\d+)\\]");

    public MongoDBRepositoryQueryBuilder(MongoDBRepository repository, Expression expression, SelectClause selectClause, OrderByClause orderByClause, ExpressionEvaluator.PathResolver pathResolver, boolean fulltextSearchDisabled) {
        super(repository.getConverter(), expression);
        this.idKey = repository.getIdKey();
        this.selectClause = selectClause;
        this.orderByClause = orderByClause;
        this.pathResolver = pathResolver;
        this.fulltextSearchDisabled = fulltextSearchDisabled;
        this.propertyKeys = new HashMap<String, String>();
    }

    @Override
    public void walk() {
        super.walk();
        this.walkOrderBy();
        this.walkProjection();
    }

    public Document getOrderBy() {
        return this.orderBy;
    }

    public Document getProjection() {
        return this.projection;
    }

    public boolean hasProjectionWildcard() {
        return this.projectionHasWildcard;
    }

    protected void walkOrderBy() {
        this.sortOnFulltextScore = false;
        if (this.orderByClause == null) {
            this.orderBy = null;
        } else {
            this.orderBy = new Document();
            for (OrderByExpr ob : this.orderByClause.elements) {
                Double value;
                Reference ref = ob.reference;
                boolean desc = ob.isDescending;
                String field = this.walkReference((Reference)ref).queryField;
                if (this.orderBy.containsKey((Object)field)) continue;
                if ("ecm:fulltextScore".equals(field)) {
                    if (!desc) {
                        throw new QueryParseException("Cannot sort by ecm:fulltextScore ascending");
                    }
                    this.sortOnFulltextScore = true;
                    value = new Document("$meta", (Object)"textScore");
                } else {
                    value = desc ? MINUS_ONE : ONE;
                }
                this.orderBy.put(field, (Object)value);
            }
            if (this.sortOnFulltextScore && this.orderBy.size() > 1) {
                throw new QueryParseException("Cannot sort by ecm:fulltextScore and other criteria");
            }
        }
    }

    protected void walkProjection() {
        this.projection = new Document();
        boolean projectionOnFulltextScore = false;
        for (Operand op : this.selectClause.getSelectList().values()) {
            if (!(op instanceof Reference)) {
                throw new QueryParseException("Projection not supported: " + op);
            }
            MongoDBAbstractQueryBuilder.FieldInfo fieldInfo = this.walkReference((Reference)op);
            String propertyField = fieldInfo.prop;
            if (!(propertyField.equals("ecm:uuid") || propertyField.equals(fieldInfo.projectionField) || propertyField.contains("/"))) {
                this.propertyKeys.put(fieldInfo.projectionField, propertyField);
            }
            this.projection.put(fieldInfo.projectionField, (Object)ONE);
            if (propertyField.contains("*")) {
                this.projectionHasWildcard = true;
            }
            if (!fieldInfo.projectionField.equals("ecm:fulltextScore")) continue;
            projectionOnFulltextScore = true;
        }
        if (projectionOnFulltextScore || this.sortOnFulltextScore) {
            if (!this.hasFulltext) {
                throw new QueryParseException("ecm:fulltextScore cannot be used without ecm:fulltext");
            }
            this.projection.put("ecm:fulltextScore", (Object)new Document("$meta", (Object)"textScore"));
        }
    }

    @Override
    public Document walkExpression(Expression expr) {
        String name;
        Operator op = expr.operator;
        Operand lvalue = expr.lvalue;
        Operand rvalue = expr.rvalue;
        Reference ref = lvalue instanceof Reference ? (Reference)lvalue : null;
        String string = name = ref != null ? ref.name : null;
        if (op == Operator.STARTSWITH) {
            return this.walkStartsWith(lvalue, rvalue);
        }
        if ("ecm:path".equals(name)) {
            return this.walkEcmPath(op, rvalue);
        }
        if ("ecm:ancestorId".equals(name)) {
            return this.walkAncestorId(op, rvalue);
        }
        if ("ecm:isTrashed".equals(name)) {
            return this.walkIsTrashed(op, rvalue);
        }
        if (name != null && name.startsWith("ecm:fulltext") && !"ecm:fulltextJobId".equals(name)) {
            return this.walkEcmFulltext(name, op, rvalue);
        }
        return super.walkExpression(expr);
    }

    protected Document walkEcmPath(Operator op, Operand rvalue) {
        String id;
        if (op != Operator.EQ && op != Operator.NOTEQ) {
            throw new QueryParseException("ecm:path requires = or <> operator");
        }
        if (!(rvalue instanceof StringLiteral)) {
            throw new QueryParseException("ecm:path requires literal path as right argument");
        }
        String path = ((StringLiteral)rvalue).value;
        if (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((id = this.pathResolver.getIdForPath(path)) == null) {
            return new Document("_id", (Object)"__nosuchid__");
        }
        Object bsonId = this.converter.serializableToBson("ecm:id", id);
        if (op == Operator.EQ) {
            return new Document(this.idKey, bsonId);
        }
        return new Document(this.idKey, (Object)new Document("$ne", bsonId));
    }

    protected Document walkAncestorId(Operator op, Operand rvalue) {
        if (op != Operator.EQ && op != Operator.NOTEQ) {
            throw new QueryParseException("ecm:ancestorId requires = or <> operator");
        }
        if (!(rvalue instanceof StringLiteral)) {
            throw new QueryParseException("ecm:ancestorId requires literal id as right argument");
        }
        String ancestorId = ((StringLiteral)rvalue).value;
        Object bsonAncestorId = this.converter.serializableToBson("ecm:ancestorIds", ancestorId);
        if (op == Operator.EQ) {
            return new Document("ecm:ancestorIds", bsonAncestorId);
        }
        return new Document("ecm:ancestorIds", (Object)new Document("$ne", bsonAncestorId));
    }

    protected Document walkEcmFulltext(String name, Operator op, Operand rvalue) {
        if (op != Operator.EQ && op != Operator.LIKE) {
            throw new QueryParseException("ecm:fulltext requires = or LIKE operator");
        }
        if (!(rvalue instanceof StringLiteral)) {
            throw new QueryParseException("ecm:fulltext requires literal string as right argument");
        }
        if (this.fulltextSearchDisabled) {
            throw new QueryParseException("Fulltext search disabled by configuration");
        }
        String fulltextQuery = ((StringLiteral)rvalue).value;
        if (name.equals("ecm:fulltext")) {
            this.hasFulltext = true;
            String ft = MongoDBRepositoryQueryBuilder.getMongoDBFulltextQuery(fulltextQuery);
            if (ft == null) {
                return new Document("_id", (Object)"__nosuchid__");
            }
            Document textSearch = new Document();
            textSearch.put("$search", (Object)ft);
            return new Document("$text", (Object)textSearch);
        }
        if (name.charAt("ecm:fulltext".length()) != '.') {
            throw new QueryParseException(name + " has incorrect syntax for a secondary fulltext index");
        }
        String prop = name.substring("ecm:fulltext".length() + 1);
        String ft = fulltextQuery.replace(" ", "%");
        rvalue = new StringLiteral(ft);
        return this.walkLike((Operand)new Reference(prop), rvalue, true, true);
    }

    protected Document walkIsTrashed(Operator op, Operand rvalue) {
        if (op != Operator.EQ && op != Operator.NOTEQ) {
            throw new QueryParseException("ecm:isTrashed requires = or <> operator");
        }
        TrashService trashService = (TrashService)Framework.getService(TrashService.class);
        if (trashService.hasFeature(TrashService.Feature.TRASHED_STATE_IS_DEDUCED_FROM_LIFECYCLE)) {
            return this.walkIsTrashed(new Reference("ecm:currentLifeCycleState"), op, rvalue, (Literal)new StringLiteral("deleted"));
        }
        if (trashService.hasFeature(TrashService.Feature.TRASHED_STATE_IN_MIGRATION)) {
            Document lifeCycleTrashed = this.walkIsTrashed(new Reference("ecm:currentLifeCycleState"), op, rvalue, (Literal)new StringLiteral("deleted"));
            Document propertyTrashed = this.walkIsTrashed(new Reference("ecm:isTrashed"), op, rvalue, (Literal)new BooleanLiteral(true));
            return new Document("$or", new ArrayList<Document>(Arrays.asList(lifeCycleTrashed, propertyTrashed)));
        }
        if (trashService.hasFeature(TrashService.Feature.TRASHED_STATE_IS_DEDICATED_PROPERTY)) {
            return this.walkIsTrashed(new Reference("ecm:isTrashed"), op, rvalue, (Literal)new BooleanLiteral(true));
        }
        throw new UnsupportedOperationException("TrashService is in an unknown state");
    }

    protected Document walkIsTrashed(Reference ref, Operator op, Operand initialRvalue, Literal deletedRvalue) {
        long v;
        if (!(initialRvalue instanceof IntegerLiteral) || (v = ((IntegerLiteral)initialRvalue).value) != 0L && v != 1L) {
            throw new QueryParseException("ecm:isTrashed requires literal 0 or 1 as right argument");
        }
        boolean equalsDeleted = op == Operator.EQ ^ v == 0L;
        if (equalsDeleted) {
            return this.walkEq((Operand)ref, (Operand)deletedRvalue);
        }
        return this.walkNotEq((Operand)ref, (Operand)deletedRvalue);
    }

    public static String getMongoDBFulltextQuery(String query) {
        FulltextQueryAnalyzer.FulltextQuery ft = FulltextQueryAnalyzer.analyzeFulltextQuery((String)query);
        if (ft == null) {
            return null;
        }
        return MongoDBRepositoryQueryBuilder.translateFulltext(ft, false);
    }

    protected static String translateFulltext(FulltextQueryAnalyzer.FulltextQuery ft, boolean and) {
        ArrayList<String> buf = new ArrayList<String>();
        MongoDBRepositoryQueryBuilder.translateFulltext(ft, buf, and);
        return StringUtils.join(buf, (char)' ');
    }

    protected static void translateFulltext(FulltextQueryAnalyzer.FulltextQuery ft, List<String> buf, boolean and) {
        if (ft.op == FulltextQueryAnalyzer.Op.OR) {
            for (FulltextQueryAnalyzer.FulltextQuery term : ft.terms) {
                MongoDBRepositoryQueryBuilder.translateFulltext(term, buf, false);
            }
        } else if (ft.op == FulltextQueryAnalyzer.Op.AND) {
            for (FulltextQueryAnalyzer.FulltextQuery term : ft.terms) {
                MongoDBRepositoryQueryBuilder.translateFulltext(term, buf, true);
            }
        } else {
            String neg = ft.op == FulltextQueryAnalyzer.Op.NOTWORD ? "-" : "";
            String word = ft.word.toLowerCase();
            if (ft.isPhrase() || and) {
                buf.add(neg + "\"" + word + "\"");
            } else {
                buf.add(neg + word);
            }
        }
    }

    @Override
    public Document walkEq(Operand lvalue, Operand rvalue) {
        MongoDBAbstractQueryBuilder.FieldInfo fieldInfo = this.walkReference(lvalue);
        if (this.isMixinTypes(fieldInfo)) {
            Object right = this.walkOperand(fieldInfo, rvalue);
            if (!(right instanceof String)) {
                throw new QueryParseException("Invalid EQ rhs: " + rvalue);
            }
            return this.walkMixinTypes(Collections.singletonList((String)right), true);
        }
        return super.walkEq(fieldInfo, rvalue);
    }

    @Override
    public Document walkNotEq(Operand lvalue, Operand rvalue) {
        MongoDBAbstractQueryBuilder.FieldInfo fieldInfo = this.walkReference(lvalue);
        if (this.isMixinTypes(fieldInfo)) {
            Object right = this.walkOperand(fieldInfo, rvalue);
            if (!(right instanceof String)) {
                throw new QueryParseException("Invalid NE rhs: " + rvalue);
            }
            return this.walkMixinTypes(Collections.singletonList((String)right), false);
        }
        return super.walkNotEq(fieldInfo, rvalue);
    }

    @Override
    public Document walkIn(Operand lvalue, Operand rvalue, boolean positive) {
        MongoDBAbstractQueryBuilder.FieldInfo fieldInfo = this.walkReference(lvalue);
        if (this.isMixinTypes(fieldInfo)) {
            Object right = this.walkOperand(fieldInfo, rvalue);
            if (!(right instanceof List)) {
                throw new QueryParseException("Invalid IN, right hand side must be a list: " + rvalue);
            }
            return this.walkMixinTypes((List)right, positive);
        }
        return super.walkIn(fieldInfo, rvalue, positive);
    }

    public Document walkStartsWith(Operand lvalue, Operand rvalue) {
        if (!(lvalue instanceof Reference)) {
            throw new QueryParseException("Invalid STARTSWITH query, left hand side must be a property: " + lvalue);
        }
        String name = ((Reference)lvalue).name;
        if (!(rvalue instanceof StringLiteral)) {
            throw new QueryParseException("Invalid STARTSWITH query, right hand side must be a literal path: " + rvalue);
        }
        String path = ((StringLiteral)rvalue).value;
        if (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ("ecm:path".equals(name)) {
            return this.walkStartsWithPath(path);
        }
        return this.walkStartsWithNonPath(lvalue, path);
    }

    protected Document walkStartsWithPath(String path) {
        String ancestorId = this.pathResolver.getIdForPath(path);
        if (ancestorId == null) {
            return new Document("_id", (Object)"__nosuchid__");
        }
        Object bsonAncestorId = this.converter.serializableToBson("ecm:ancestorIds", ancestorId);
        return new Document("ecm:ancestorIds", bsonAncestorId);
    }

    protected Document walkStartsWithNonPath(Operand lvalue, String path) {
        MongoDBAbstractQueryBuilder.FieldInfo fieldInfo = this.walkReference(lvalue);
        Document eq = this.newDocumentWithField(fieldInfo, path);
        String regex = path.replaceAll("([^a-zA-Z0-9 /])", "\\\\$1");
        Pattern pattern = Pattern.compile(regex + "/.*");
        Document like = this.newDocumentWithField(fieldInfo, pattern);
        return new Document("$or", Arrays.asList(eq, like));
    }

    public static String canonicalXPath(String xpath) {
        while (xpath.length() > 0 && xpath.charAt(0) == '/') {
            xpath = xpath.substring(1);
        }
        if (xpath.indexOf(91) == -1) {
            return xpath;
        }
        return NON_CANON_INDEX.matcher(xpath).replaceAll("$1");
    }

    @Override
    protected MongoDBAbstractQueryBuilder.FieldInfo walkReference(String name) {
        String prop = MongoDBRepositoryQueryBuilder.canonicalXPath(name);
        String[] parts = prop.split("/");
        if (prop.startsWith("ecm:")) {
            if (prop.startsWith("ecm:acl/")) {
                return this.parseACP(prop, parts);
            }
            if (prop.startsWith("ecm:tag")) {
                String queryField = "nxtag:tags.label";
                queryField = this.stripElemMatchPrefix(queryField);
                return new MongoDBAbstractQueryBuilder.FieldInfo(prop, prop, queryField, queryField, (Type)StringType.INSTANCE);
            }
            String field = DBSSession.convToInternal((String)prop);
            Type type = DBSSession.getType((String)field);
            String queryField = this.converter.keyToBson(field);
            queryField = this.stripElemMatchPrefix(queryField);
            return new MongoDBAbstractQueryBuilder.FieldInfo(prop, field, queryField, queryField, type);
        }
        String first = parts[0];
        Field field = this.schemaManager.getField(first);
        if (field == null) {
            if (first.indexOf(58) > -1) {
                throw new QueryParseException("No such property: " + name);
            }
            for (Schema schema : this.schemaManager.getSchemas()) {
                if (StringUtils.isBlank((CharSequence)schema.getNamespace().prefix) && (field = schema.getField(first)) != null) break;
            }
            if (field == null) {
                throw new QueryParseException("No such property: " + name);
            }
        }
        Type type = field.getType();
        if ("uid:major_version".equals(prop) || "uid:minor_version".equals(prop) || "major_version".equals(prop) || "minor_version".equals(prop)) {
            String fieldName = DBSSession.convToInternal((String)prop);
            return new MongoDBAbstractQueryBuilder.FieldInfo(prop, fieldName, fieldName, fieldName, type);
        }
        parts[0] = field.getName().getPrefixedName();
        LinkedList<String> queryFieldParts = new LinkedList<String>();
        LinkedList<String> projectionFieldParts = new LinkedList<String>();
        boolean firstPart = true;
        for (String part : parts) {
            if (NumberUtils.isDigits((String)part)) {
                queryFieldParts.add(part);
                type = ((ListType)type).getFieldType();
            } else if (!part.startsWith("*")) {
                queryFieldParts.add(part);
                projectionFieldParts.add(part);
                if (!firstPart) {
                    field = ((ComplexType)type).getField(part);
                    if (field == null) {
                        throw new QueryParseException("No such property: " + name);
                    }
                    type = field.getType();
                }
            } else {
                type = ((ListType)type).getFieldType();
            }
            firstPart = false;
        }
        String queryField = StringUtils.join(queryFieldParts, (char)'.');
        String projectionField = StringUtils.join(projectionFieldParts, (char)'.');
        queryField = this.stripElemMatchPrefix(queryField);
        return new MongoDBAbstractQueryBuilder.FieldInfo(prop, prop, queryField, projectionField, type);
    }

    protected MongoDBAbstractQueryBuilder.FieldInfo parseACP(String prop, String[] parts) {
        Object queryField;
        if (parts.length != 3) {
            throw new QueryParseException("No such property: " + prop);
        }
        String wildcard = parts[1];
        if (NumberUtils.isDigits((String)wildcard)) {
            throw new QueryParseException("Cannot use explicit index in ACLs: " + prop);
        }
        String last = parts[2];
        if ("name".equals(last)) {
            queryField = "ecm:acp.name";
        } else {
            String fieldLast = DBSSession.convToInternalAce((String)last);
            if (fieldLast == null) {
                throw new QueryParseException("No such property: " + prop);
            }
            queryField = "ecm:acp.acl." + fieldLast;
        }
        Type type = DBSSession.getType((String)last);
        queryField = this.stripElemMatchPrefix((String)queryField);
        return new MongoDBAbstractQueryBuilder.FieldInfo(prop, prop, (String)queryField, (String)queryField, type);
    }

    protected boolean isMixinTypes(MongoDBAbstractQueryBuilder.FieldInfo fieldInfo) {
        return fieldInfo.queryField.equals("ecm:mixinTypes");
    }

    protected Set<String> getMixinDocumentTypes(String mixin) {
        Set types = this.schemaManager.getDocumentTypeNamesForFacet(mixin);
        return types == null ? Collections.emptySet() : types;
    }

    protected List<String> getDocumentTypes() {
        if (this.documentTypes == null) {
            this.documentTypes = new ArrayList<String>();
            for (DocumentType docType : this.schemaManager.getDocumentTypes()) {
                this.documentTypes.add(docType.getName());
            }
        }
        return this.documentTypes;
    }

    protected boolean isNeverPerInstanceMixin(String mixin) {
        return this.schemaManager.getNoPerDocumentQueryFacets().contains(mixin);
    }

    public Document walkMixinTypes(List<String> mixins, boolean include) {
        HashSet<Object> matchPrimaryTypes;
        if (include) {
            matchPrimaryTypes = new HashSet();
            for (String string : mixins) {
                matchPrimaryTypes.addAll(this.getMixinDocumentTypes(string));
            }
        } else {
            matchPrimaryTypes = new HashSet<String>(this.getDocumentTypes());
            for (String string : mixins) {
                matchPrimaryTypes.removeAll(this.getMixinDocumentTypes(string));
            }
        }
        HashSet<String> matchMixinTypes = new HashSet<String>();
        for (String mixin : mixins) {
            if (this.isNeverPerInstanceMixin(mixin)) continue;
            matchMixinTypes.add(mixin);
        }
        Document document = new Document("ecm:primaryType", (Object)new Document("$in", matchPrimaryTypes));
        String innin = include ? "$in" : "$nin";
        Document m = new Document("ecm:mixinTypes", (Object)new Document(innin, matchMixinTypes));
        String op = include ? "$or" : "$and";
        return new Document(op, Arrays.asList(document, m));
    }
}

