/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.core.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutTypeDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetType;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.converters.LayoutDefinitionConverter;
import org.nuxeo.ecm.platform.forms.layout.api.converters.WidgetDefinitionConverter;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetTypeImpl;
import org.nuxeo.ecm.platform.forms.layout.api.service.LayoutStore;
import org.nuxeo.ecm.platform.forms.layout.core.registries.LayoutConverterRegistry;
import org.nuxeo.ecm.platform.forms.layout.core.registries.LayoutDefinitionRegistry;
import org.nuxeo.ecm.platform.forms.layout.core.registries.LayoutTypeDefinitionRegistry;
import org.nuxeo.ecm.platform.forms.layout.core.registries.WidgetConverterRegistry;
import org.nuxeo.ecm.platform.forms.layout.core.registries.WidgetDefinitionRegistry;
import org.nuxeo.ecm.platform.forms.layout.core.registries.WidgetTypeDefinitionRegistry;
import org.nuxeo.ecm.platform.forms.layout.core.registries.WidgetTypeRegistry;
import org.nuxeo.ecm.platform.forms.layout.descriptors.LayoutConverterDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.LayoutDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.LayoutTypeDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.WidgetConverterDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.WidgetDescriptor;
import org.nuxeo.ecm.platform.forms.layout.descriptors.WidgetTypeDescriptor;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class LayoutStoreImpl
extends DefaultComponent
implements LayoutStore {
    private static final Log log = LogFactory.getLog(LayoutStoreImpl.class);
    private static final long serialVersionUID = 1L;
    public static final String WIDGET_TYPES_EP_NAME = "widgettypes";
    public static final String LAYOUT_TYPES_EP_NAME = "layouttypes";
    public static final String WIDGETS_EP_NAME = "widgets";
    public static final String LAYOUTS_EP_NAME = "layouts";
    public static final String LAYOUT_CONVERTERS_EP_NAME = "layoutConverters";
    public static final String WIDGET_CONVERTERS_EP_NAME = "widgetConverters";
    protected final Map<String, WidgetTypeRegistry> widgetTypesByCat;
    protected final Map<String, WidgetTypeDefinitionRegistry> widgetTypeDefsByCat = new HashMap<String, WidgetTypeDefinitionRegistry>();
    protected final Map<String, LayoutTypeDefinitionRegistry> layoutTypeDefsByCat = new HashMap<String, LayoutTypeDefinitionRegistry>();
    protected final Map<String, LayoutDefinitionRegistry> layoutsByCat;
    protected final Map<String, WidgetDefinitionRegistry> widgetsByCat;
    protected final Map<String, WidgetConverterRegistry> widgetConvertersByCat;
    protected final Map<String, LayoutConverterRegistry> layoutConvertersByCat;

    public LayoutStoreImpl() {
        this.widgetTypesByCat = new HashMap<String, WidgetTypeRegistry>();
        this.layoutsByCat = new HashMap<String, LayoutDefinitionRegistry>();
        this.widgetsByCat = new HashMap<String, WidgetDefinitionRegistry>();
        this.widgetConvertersByCat = new HashMap<String, WidgetConverterRegistry>();
        this.layoutConvertersByCat = new HashMap<String, LayoutConverterRegistry>();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(WIDGET_TYPES_EP_NAME)) {
            WidgetTypeDescriptor desc = (WidgetTypeDescriptor)contribution;
            String[] categories = desc.getCategories();
            if (categories == null || categories.length == 0) {
                log.error((Object)String.format("Cannot register widget type '%s': no category found", desc.getName()));
            } else {
                for (String cat : categories) {
                    this.registerWidgetType(cat, desc.getWidgetTypeDefinition());
                }
            }
        } else if (extensionPoint.equals(LAYOUT_TYPES_EP_NAME)) {
            LayoutTypeDescriptor desc = (LayoutTypeDescriptor)contribution;
            String[] categories = desc.getCategories();
            if (categories == null || categories.length == 0) {
                log.error((Object)String.format("Cannot register layout type '%s': no category found", desc.getName()));
            } else {
                for (String cat : categories) {
                    this.registerLayoutType(cat, desc.getLayoutTypeDefinition());
                }
            }
        } else if (extensionPoint.equals(LAYOUTS_EP_NAME)) {
            LayoutDescriptor desc = (LayoutDescriptor)contribution;
            String[] categories = desc.getCategories();
            if (categories == null || categories.length == 0) {
                log.error((Object)String.format("Cannot register layout '%s': no category found", desc.getName()));
            } else {
                for (String cat : categories) {
                    this.registerLayout(cat, desc.getLayoutDefinition());
                }
            }
        } else if (extensionPoint.equals(WIDGETS_EP_NAME)) {
            WidgetDescriptor desc = (WidgetDescriptor)contribution;
            String[] categories = desc.getCategories();
            if (categories == null || categories.length == 0) {
                log.error((Object)String.format("Cannot register widget '%s': no category found", desc.getName()));
            } else {
                for (String cat : categories) {
                    this.registerWidget(cat, desc.getWidgetDefinition());
                }
            }
        } else if (extensionPoint.equals(LAYOUT_CONVERTERS_EP_NAME)) {
            LayoutConverterDescriptor desc = (LayoutConverterDescriptor)contribution;
            String[] categories = desc.getCategories();
            if (categories == null || categories.length == 0) {
                log.error((Object)String.format("Cannot register layout converter '%s': no category found", desc.getName()));
            } else {
                for (String cat : categories) {
                    this.registerLayoutConverter(cat, desc);
                }
            }
        } else if (extensionPoint.equals(WIDGET_CONVERTERS_EP_NAME)) {
            WidgetConverterDescriptor desc = (WidgetConverterDescriptor)contribution;
            String[] categories = desc.getCategories();
            if (categories == null || categories.length == 0) {
                log.error((Object)String.format("Cannot register widget converter '%s': no category found", desc.getName()));
            } else {
                for (String cat : categories) {
                    this.registerWidgetConverter(cat, desc);
                }
            }
        } else {
            log.error((Object)String.format("Unknown extension point %s, can't register !", extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(WIDGET_TYPES_EP_NAME)) {
            WidgetTypeDescriptor desc = (WidgetTypeDescriptor)contribution;
            String[] categories = desc.getCategories();
            if (categories == null || categories.length == 0) {
                log.error((Object)String.format("Cannot unregister widget type '%s': no category found", desc.getName()));
            } else {
                for (String cat : categories) {
                    this.unregisterWidgetType(cat, desc.getWidgetTypeDefinition());
                }
            }
        } else if (extensionPoint.equals(LAYOUT_TYPES_EP_NAME)) {
            LayoutTypeDescriptor desc = (LayoutTypeDescriptor)contribution;
            String[] categories = desc.getCategories();
            if (categories == null || categories.length == 0) {
                log.error((Object)String.format("Cannot unregister layout type '%s': no category found", desc.getName()));
            } else {
                for (String cat : categories) {
                    this.unregisterLayoutType(cat, desc.getLayoutTypeDefinition());
                }
            }
        } else if (extensionPoint.equals(LAYOUTS_EP_NAME)) {
            LayoutDescriptor desc = (LayoutDescriptor)contribution;
            String[] categories = desc.getCategories();
            if (categories == null || categories.length == 0) {
                log.error((Object)String.format("Cannot unregister layout '%s': no category found", desc.getName()));
            } else {
                for (String cat : categories) {
                    this.unregisterLayout(cat, desc.getLayoutDefinition());
                }
            }
        } else if (extensionPoint.equals(WIDGETS_EP_NAME)) {
            WidgetDescriptor desc = (WidgetDescriptor)contribution;
            String[] categories = desc.getCategories();
            if (categories == null || categories.length == 0) {
                log.error((Object)String.format("Cannot unregister widget '%s': no category found", desc.getName()));
            } else {
                for (String cat : categories) {
                    this.unregisterWidget(cat, desc.getWidgetDefinition());
                }
            }
        } else if (extensionPoint.equals(LAYOUT_CONVERTERS_EP_NAME)) {
            LayoutConverterDescriptor desc = (LayoutConverterDescriptor)contribution;
            String[] categories = desc.getCategories();
            if (categories == null || categories.length == 0) {
                log.error((Object)String.format("Cannot register layout converter '%s': no category found", desc.getName()));
            } else {
                for (String cat : categories) {
                    this.unregisterLayoutConverter(cat, desc);
                }
            }
        } else if (extensionPoint.equals(WIDGET_CONVERTERS_EP_NAME)) {
            WidgetConverterDescriptor desc = (WidgetConverterDescriptor)contribution;
            String[] categories = desc.getCategories();
            if (categories == null || categories.length == 0) {
                log.error((Object)String.format("Cannot register widget converter '%s': no category found", desc.getName()));
            } else {
                for (String cat : categories) {
                    this.unregisterWidgetConverter(cat, desc);
                }
            }
        } else {
            log.error((Object)String.format("Unknown extension point %s, can't unregister !", extensionPoint));
        }
    }

    public List<String> getCategories() {
        HashSet<String> cats = new HashSet<String>();
        cats.addAll(this.widgetTypeDefsByCat.keySet());
        cats.addAll(this.widgetTypesByCat.keySet());
        cats.addAll(this.layoutsByCat.keySet());
        cats.addAll(this.widgetsByCat.keySet());
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(cats);
        Collections.sort(res);
        return res;
    }

    public void registerWidgetType(String category, WidgetTypeDefinition desc) {
        String name = desc.getName();
        String className = desc.getHandlerClassName();
        Class<?> widgetTypeClass = null;
        if (className != null) {
            try {
                widgetTypeClass = LayoutStoreImpl.class.getClassLoader().loadClass(className);
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)"Caught error when instantiating widget type handler", (Throwable)e);
                return;
            }
        }
        if (this.widgetTypesByCat.containsKey(name) || this.widgetTypeDefsByCat.containsKey(name)) {
            log.warn((Object)String.format("Overriding definition for widget type %s", name));
            this.widgetTypesByCat.remove(name);
            this.widgetTypeDefsByCat.remove(name);
        }
        WidgetTypeImpl widgetType = new WidgetTypeImpl(name, widgetTypeClass, desc.getProperties());
        widgetType.setAliases(desc.getAliases());
        WidgetTypeRegistry typeReg = this.widgetTypesByCat.get(category);
        if (typeReg == null) {
            typeReg = new WidgetTypeRegistry(category);
            this.widgetTypesByCat.put(category, typeReg);
        }
        typeReg.addContribution((WidgetType)widgetType);
        WidgetTypeDefinitionRegistry defReg = this.widgetTypeDefsByCat.get(category);
        if (defReg == null) {
            defReg = new WidgetTypeDefinitionRegistry(category);
            this.widgetTypeDefsByCat.put(category, defReg);
        }
        defReg.addContribution(desc);
        log.info((Object)String.format("Registered widget type '%s' for category '%s' ", name, category));
    }

    public void unregisterWidgetType(String category, WidgetTypeDefinition desc) {
        String name = desc.getName();
        WidgetTypeRegistry typeReg = this.widgetTypesByCat.get(category);
        WidgetTypeDefinitionRegistry defReg = this.widgetTypeDefsByCat.get(category);
        if (typeReg != null && defReg != null) {
            WidgetTypeImpl widgetType = new WidgetTypeImpl(name, null, null);
            typeReg.removeContribution((WidgetType)widgetType);
            defReg.removeContribution(desc);
            log.info((Object)String.format("Unregistered widget type '%s' for category '%s' ", name, category));
        }
    }

    public void registerLayoutType(String category, LayoutTypeDefinition layoutTypeDef) {
        LayoutTypeDefinitionRegistry reg = this.layoutTypeDefsByCat.get(category);
        if (reg == null) {
            reg = new LayoutTypeDefinitionRegistry(category);
            this.layoutTypeDefsByCat.put(category, reg);
        }
        reg.addContribution(layoutTypeDef);
        log.info((Object)String.format("Registered layout type '%s' for category '%s' ", layoutTypeDef.getName(), category));
    }

    public void unregisterLayoutType(String category, LayoutTypeDefinition layoutTypeDef) {
        LayoutTypeDefinitionRegistry reg = this.layoutTypeDefsByCat.get(category);
        if (reg != null) {
            reg.removeContribution(layoutTypeDef);
            log.info((Object)String.format("Unregistered layout type '%s' for category '%s' ", layoutTypeDef.getName(), category));
        }
    }

    public void registerLayout(String category, LayoutDefinition layoutDef) {
        LayoutDefinitionRegistry reg = this.layoutsByCat.get(category);
        if (reg == null) {
            reg = new LayoutDefinitionRegistry(category);
            this.layoutsByCat.put(category, reg);
        }
        reg.addContribution(layoutDef);
        log.info((Object)String.format("Registered layout '%s' for category '%s' ", layoutDef.getName(), category));
    }

    public void unregisterLayout(String category, LayoutDefinition layoutDef) {
        LayoutDefinitionRegistry reg = this.layoutsByCat.get(category);
        if (reg != null) {
            reg.removeContribution(layoutDef);
            log.info((Object)String.format("Unregistered layout '%s' for category '%s' ", layoutDef.getName(), category));
        }
    }

    public void registerWidget(String category, WidgetDefinition widgetDef) {
        WidgetDefinitionRegistry reg = this.widgetsByCat.get(category);
        if (reg == null) {
            reg = new WidgetDefinitionRegistry(category);
            this.widgetsByCat.put(category, reg);
        }
        reg.addContribution(widgetDef);
        log.info((Object)String.format("Registered widget '%s' for category '%s' ", widgetDef.getName(), category));
    }

    public void unregisterWidget(String category, WidgetDefinition widgetDef) {
        WidgetDefinitionRegistry reg = this.widgetsByCat.get(category);
        if (reg != null) {
            reg.removeContribution(widgetDef);
            log.info((Object)String.format("Unregistered widget '%s' for category '%s' ", widgetDef.getName(), category));
        }
    }

    public void registerLayoutConverter(String category, LayoutConverterDescriptor layoutConverter) {
        LayoutConverterRegistry reg = this.layoutConvertersByCat.get(category);
        if (reg == null) {
            reg = new LayoutConverterRegistry(category);
            this.layoutConvertersByCat.put(category, reg);
        }
        reg.addContribution(layoutConverter);
        log.info((Object)String.format("Registered layout converter '%s' for category '%s' ", layoutConverter.getName(), category));
    }

    public void unregisterLayoutConverter(String category, LayoutConverterDescriptor layoutConverter) {
        LayoutConverterRegistry reg = this.layoutConvertersByCat.get(category);
        if (reg != null) {
            reg.removeContribution(layoutConverter);
            log.info((Object)String.format("Unregistered layout converter '%s' for category '%s' ", layoutConverter.getName(), category));
        }
    }

    public void registerWidgetConverter(String category, WidgetConverterDescriptor widgetConverter) {
        WidgetConverterRegistry reg = this.widgetConvertersByCat.get(category);
        if (reg == null) {
            reg = new WidgetConverterRegistry(category);
            this.widgetConvertersByCat.put(category, reg);
        }
        reg.addContribution(widgetConverter);
        log.info((Object)String.format("Registered widget converter '%s' for category '%s' ", widgetConverter.getName(), category));
    }

    public void unregisterWidgetConverter(String category, WidgetConverterDescriptor widgetConverter) {
        WidgetConverterRegistry reg = this.widgetConvertersByCat.get(category);
        if (reg != null) {
            reg.removeContribution(widgetConverter);
            log.info((Object)String.format("Unregistered widget converter '%s' for category '%s' ", widgetConverter.getName(), category));
        }
    }

    public WidgetType getWidgetType(String category, String typeName) {
        WidgetTypeRegistry reg = this.widgetTypesByCat.get(category);
        if (reg != null) {
            return reg.getWidgetType(typeName);
        }
        return null;
    }

    public WidgetTypeDefinition getWidgetTypeDefinition(String category, String typeName) {
        WidgetTypeDefinitionRegistry reg = this.widgetTypeDefsByCat.get(category);
        if (reg != null) {
            return reg.getDefinition(typeName);
        }
        return null;
    }

    public List<WidgetTypeDefinition> getWidgetTypeDefinitions(String category) {
        List<WidgetTypeDefinition> defs;
        ArrayList<WidgetTypeDefinition> res = new ArrayList<WidgetTypeDefinition>();
        WidgetTypeDefinitionRegistry reg = this.widgetTypeDefsByCat.get(category);
        if (reg != null && (defs = reg.getDefinitions()) != null) {
            res.addAll(defs);
        }
        return res;
    }

    public LayoutTypeDefinition getLayoutTypeDefinition(String category, String typeName) {
        LayoutTypeDefinitionRegistry reg = this.layoutTypeDefsByCat.get(category);
        if (reg != null) {
            return reg.getDefinition(typeName);
        }
        return null;
    }

    public List<LayoutTypeDefinition> getLayoutTypeDefinitions(String category) {
        List<LayoutTypeDefinition> defs;
        ArrayList<LayoutTypeDefinition> res = new ArrayList<LayoutTypeDefinition>();
        LayoutTypeDefinitionRegistry reg = this.layoutTypeDefsByCat.get(category);
        if (reg != null && (defs = reg.getDefinitions()) != null) {
            res.addAll(defs);
        }
        return res;
    }

    public LayoutDefinition getLayoutDefinition(String category, String layoutName) {
        LayoutDefinitionRegistry reg = this.layoutsByCat.get(category);
        if (reg != null) {
            return reg.getLayoutDefinition(layoutName);
        }
        return null;
    }

    public List<String> getLayoutDefinitionNames(String category) {
        LayoutDefinitionRegistry reg = this.layoutsByCat.get(category);
        if (reg != null) {
            return reg.getLayoutNames();
        }
        return Collections.emptyList();
    }

    public WidgetDefinition getWidgetDefinition(String category, String widgetName) {
        WidgetDefinitionRegistry reg = this.widgetsByCat.get(category);
        if (reg != null) {
            return reg.getWidgetDefinition(widgetName);
        }
        return null;
    }

    public List<LayoutDefinitionConverter> getLayoutConverters(String category) {
        ArrayList<LayoutDefinitionConverter> res = new ArrayList<LayoutDefinitionConverter>();
        ArrayList<String> orderedConverterNames = new ArrayList<String>();
        LayoutConverterRegistry reg = this.layoutConvertersByCat.get(category);
        if (reg != null) {
            List<LayoutConverterDescriptor> descs = reg.getConverters();
            Collections.sort(descs);
            for (LayoutConverterDescriptor desc : descs) {
                try {
                    Class<?> converterClass = LayoutStoreImpl.class.getClassLoader().loadClass(desc.getConverterClassName());
                    LayoutDefinitionConverter converter = (LayoutDefinitionConverter)converterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    res.add(converter);
                    orderedConverterNames.add(desc.getName());
                }
                catch (ReflectiveOperationException e) {
                    log.error((Object)"Caught error when instantiating layout definition converter", (Throwable)e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Ordered layout converters for category '%s': %s", category, orderedConverterNames));
        }
        return res;
    }

    public List<WidgetDefinitionConverter> getWidgetConverters(String category) {
        ArrayList<WidgetDefinitionConverter> res = new ArrayList<WidgetDefinitionConverter>();
        ArrayList<String> orderedConverterNames = new ArrayList<String>();
        WidgetConverterRegistry reg = this.widgetConvertersByCat.get(category);
        if (reg != null) {
            List<WidgetConverterDescriptor> descs = reg.getConverters();
            Collections.sort(descs);
            for (WidgetConverterDescriptor desc : descs) {
                try {
                    Class<?> converterClass = LayoutStoreImpl.class.getClassLoader().loadClass(desc.getConverterClassName());
                    WidgetDefinitionConverter converter = (WidgetDefinitionConverter)converterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    res.add(converter);
                    orderedConverterNames.add(desc.getName());
                }
                catch (ReflectiveOperationException e) {
                    log.error((Object)"Caught error when instantiating widget definition converter", (Throwable)e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Ordered widget converters for category '%s': %s", category, orderedConverterNames));
        }
        return res;
    }
}

