/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.decoder;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.directory.server.kerberos.shared.io.decoder.Decoder;
import org.apache.directory.server.kerberos.shared.io.decoder.DecoderFactory;
import org.apache.directory.server.kerberos.shared.io.decoder.HostAddressDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.KerberosTimeDecoder;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.components.EncKrbPrivPart;
import org.apache.directory.server.kerberos.shared.messages.components.EncKrbPrivPartModifier;
import org.apache.directory.shared.asn1.der.ASN1InputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERGeneralizedTime;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class EncKrbPrivPartDecoder
implements Decoder,
DecoderFactory {
    public Decoder getDecoder() {
        return new EncKrbPrivPartDecoder();
    }

    public Encodable decode(byte[] encodedPrivatePart) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(encodedPrivatePart);
        DERApplicationSpecific app = (DERApplicationSpecific)ais.readObject();
        DERSequence privatePart = (DERSequence)app.getObject();
        return this.decodePrivatePartSequence(privatePart);
    }

    private EncKrbPrivPart decodePrivatePartSequence(DERSequence sequence) {
        EncKrbPrivPartModifier modifier = new EncKrbPrivPartModifier();
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DEROctetString tag0 = (DEROctetString)derObject;
                    modifier.setUserData(tag0.getOctets());
                    break;
                }
                case 1: {
                    DERGeneralizedTime tag1 = (DERGeneralizedTime)derObject;
                    modifier.setTimestamp(KerberosTimeDecoder.decode(tag1));
                    break;
                }
                case 2: {
                    DERInteger tag2 = (DERInteger)derObject;
                    modifier.setMicroSecond(new Integer(tag2.intValue()));
                    break;
                }
                case 3: {
                    DERInteger tag3 = (DERInteger)derObject;
                    modifier.setSequenceNumber(new Integer(tag3.intValue()));
                    break;
                }
                case 4: {
                    DERSequence tag4 = (DERSequence)derObject;
                    modifier.setSenderAddress(HostAddressDecoder.decode(tag4));
                    break;
                }
                case 5: {
                    DERSequence tag5 = (DERSequence)derObject;
                    modifier.setRecipientAddress(HostAddressDecoder.decode(tag5));
                }
            }
        }
        return modifier.getEncKrbPrivPart();
    }
}

