/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.io;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVPrinter;
import org.nuxeo.ecm.core.io.marshallers.csv.AbstractCSVWriter;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.audit.api.LogEntry;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class LogEntryCSVWriter
extends AbstractCSVWriter<LogEntry> {
    public static final List<String> DEFAULT_PROPERTIES = List.of("id", "category", "principalName", "comment", "docLifeCycle", "docPath", "docType", "docUUID", "eventId", "repositoryId", "eventDate", "logDate");

    protected void write(LogEntry entity, CSVPrinter printer) throws IOException {
        HashSet<String> propertiesToFetch = new HashSet<String>(LogEntryCSVWriter.getPropertiesToFetch(this.ctx));
        if (propertiesToFetch.contains("id")) {
            printer.print((Object)entity.getId());
        }
        if (propertiesToFetch.contains("category")) {
            printer.print((Object)entity.getCategory());
        }
        if (propertiesToFetch.contains("principalName")) {
            printer.print((Object)entity.getPrincipalName());
        }
        if (propertiesToFetch.contains("comment")) {
            printer.print((Object)entity.getComment());
        }
        if (propertiesToFetch.contains("docLifeCycle")) {
            printer.print((Object)entity.getDocLifeCycle());
        }
        if (propertiesToFetch.contains("docPath")) {
            printer.print((Object)entity.getDocPath());
        }
        if (propertiesToFetch.contains("docType")) {
            printer.print((Object)entity.getDocType());
        }
        if (propertiesToFetch.contains("docUUID")) {
            printer.print((Object)entity.getDocUUID());
        }
        if (propertiesToFetch.contains("eventId")) {
            printer.print((Object)entity.getEventId());
        }
        if (propertiesToFetch.contains("repositoryId")) {
            printer.print((Object)entity.getRepositoryId());
        }
        if (propertiesToFetch.contains("eventDate")) {
            printer.print((Object)entity.getEventDate());
        }
        if (propertiesToFetch.contains("logDate")) {
            printer.print((Object)entity.getLogDate());
        }
    }

    protected void writeHeader(LogEntry entity, CSVPrinter printer) throws IOException {
        LogEntryCSVWriter.writeHeader(printer, this.ctx);
    }

    protected static List<String> getPropertiesToFetch(RenderingContext ctx) {
        Set fetched = ctx.getFetched("logEntry");
        List propertiesToFetch = DEFAULT_PROPERTIES.stream().filter(fetched::contains).collect(Collectors.toList());
        return propertiesToFetch.isEmpty() ? DEFAULT_PROPERTIES : propertiesToFetch;
    }

    public static void writeHeader(CSVPrinter printer, RenderingContext ctx) throws IOException {
        List<String> properties = LogEntryCSVWriter.getPropertiesToFetch(ctx);
        for (String property : properties) {
            printer.print((Object)property);
        }
        printer.println();
    }
}

