/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.listener;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;

public class CheckedInCommentListener
implements PostCommitFilteringEventListener {
    public boolean acceptEvent(Event event) {
        return "documentCheckedIn".equals(event.getName());
    }

    public void handleEvent(EventBundle events) {
        for (Event event : events) {
            if (!this.acceptEvent(event)) continue;
            this.handleEvent(event);
        }
    }

    protected void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        CoreSession session = ctx.getCoreSession();
        DocumentRef versionRef = (DocumentRef)ctx.getProperty("checkedInVersionRef");
        if (versionRef != null && session.hasChild(versionRef, "Comments")) {
            DocumentModel comments = session.getChild(versionRef, "Comments");
            this.updateCommentProperties(session, comments.getId(), versionRef.reference().toString(), new String[0]);
        }
    }

    protected void updateCommentProperties(CoreSession session, String ecmParentId, String commentParentId, String ... parentCommentAncestorIds) {
        int limit = 100;
        long offset = 0L;
        long total = 0L;
        do {
            DocumentModelList docModels = session.query(String.format("SELECT * FROM Comment where ecm:parentId='%s'", ecmParentId), null, (long)limit, offset, true);
            for (DocumentModel docModel : docModels) {
                ArrayList<String> commentAncestorIds = new ArrayList<String>(Arrays.asList(parentCommentAncestorIds));
                commentAncestorIds.add(commentParentId);
                docModel.setPropertyValue("comment:ancestorIds", commentAncestorIds);
                docModel.setPropertyValue("comment:parentId", (Serializable)((Object)commentParentId));
                session.saveDocument(docModel);
                this.updateCommentProperties(session, docModel.getId(), docModel.getId(), (String[])commentAncestorIds.toArray(String[]::new));
            }
            offset += (long)limit;
            if (total == 0L) {
                total = docModels.totalSize();
            }
            session.save();
        } while (offset < total);
    }
}

