/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.modify;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyRequest
extends LdapMessage {
    private static final Logger log = LoggerFactory.getLogger(ModifyRequest.class);
    private LdapDN object;
    private List<ModificationItemImpl> modifications;
    private Attribute currentAttribute;
    private int currentOperation;
    private int modifyRequestLength;
    private int modificationsLength;
    private List<Integer> modificationSequenceLength;
    private List<Integer> modificationLength;
    private List<Integer> valuesLength;

    @Override
    public int getMessageType() {
        return 13;
    }

    public void initModifications() {
        this.modifications = new ArrayList<ModificationItemImpl>();
    }

    public List<ModificationItemImpl> getModifications() {
        return this.modifications;
    }

    public void addModification(int operation) {
        this.currentOperation = operation;
        if (this.currentAttribute == null) {
            this.modifications = new ArrayList<ModificationItemImpl>();
        }
    }

    public void addAttributeTypeAndValues(String type) {
        this.currentAttribute = new AttributeImpl(StringTools.lowerCaseAscii(type));
        int operation = 0;
        switch (this.currentOperation) {
            case 0: {
                operation = 1;
                break;
            }
            case 1: {
                operation = 3;
                break;
            }
            case 2: {
                operation = 2;
            }
        }
        ModificationItemImpl modification = new ModificationItemImpl(operation, this.currentAttribute);
        this.modifications.add(modification);
    }

    public void addAttributeValue(Object value) {
        this.currentAttribute.add(value);
    }

    public String getCurrentAttributeType() {
        return this.currentAttribute.getID();
    }

    public LdapDN getObject() {
        return this.object;
    }

    public void setObject(LdapDN object) {
        this.object = object;
    }

    public int getCurrentOperation() {
        return this.currentOperation;
    }

    public void setCurrentOperation(int currentOperation) {
        this.currentOperation = currentOperation;
    }

    @Override
    public int computeLength() {
        this.modifyRequestLength = 1 + TLV.getNbBytes((int)LdapDN.getNbBytes(this.object)) + LdapDN.getNbBytes(this.object);
        this.modificationsLength = 0;
        if (this.modifications != null && this.modifications.size() != 0) {
            Iterator<ModificationItemImpl> modificationsIterator = this.modifications.iterator();
            this.modificationSequenceLength = new LinkedList<Integer>();
            this.modificationLength = new LinkedList<Integer>();
            this.valuesLength = new LinkedList<Integer>();
            while (modificationsIterator.hasNext()) {
                int localModificationLength;
                int localValuesLength;
                int localModificationSequenceLength;
                block6: {
                    localModificationSequenceLength = 3;
                    localValuesLength = 0;
                    ModificationItemImpl modification = modificationsIterator.next();
                    int typeLength = modification.getAttribute().getID().length();
                    localModificationLength = 1 + TLV.getNbBytes((int)typeLength) + typeLength;
                    try {
                        NamingEnumeration<?> values = modification.getAttribute().getAll();
                        if (!values.hasMoreElements()) break block6;
                        while (values.hasMore()) {
                            Object value = values.next();
                            if (value instanceof String) {
                                int valueLength = StringTools.getBytesUtf8((String)value).length;
                                localValuesLength += 1 + TLV.getNbBytes((int)valueLength) + valueLength;
                                continue;
                            }
                            localValuesLength += 1 + TLV.getNbBytes((int)((byte[])value).length) + ((byte[])value).length;
                        }
                    }
                    catch (NamingException ne) {
                        continue;
                    }
                }
                this.modificationsLength += 1 + TLV.getNbBytes((int)(localModificationSequenceLength += 1 + TLV.getNbBytes((int)(localModificationLength += 1 + TLV.getNbBytes((int)localValuesLength) + localValuesLength)) + localModificationLength)) + localModificationSequenceLength;
                this.valuesLength.add(localValuesLength);
                this.modificationLength.add(localModificationLength);
                this.modificationSequenceLength.add(localModificationSequenceLength);
            }
            this.modifyRequestLength += 1 + TLV.getNbBytes((int)this.modificationsLength) + this.modificationsLength;
        }
        return 1 + TLV.getNbBytes((int)this.modifyRequestLength) + this.modifyRequestLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        block14: {
            if (buffer == null) {
                throw new EncoderException("Cannot put a PDU in a null buffer !");
            }
            try {
                buffer.put((byte)102);
                buffer.put(TLV.getBytes((int)this.modifyRequestLength));
                Value.encode((ByteBuffer)buffer, (byte[])LdapDN.getBytes(this.object));
                buffer.put((byte)48);
                buffer.put(TLV.getBytes((int)this.modificationsLength));
                if (this.modifications == null || this.modifications.size() == 0) break block14;
                Iterator<ModificationItemImpl> modificationIterator = this.modifications.iterator();
                int modificationNumber = 0;
                while (modificationIterator.hasNext()) {
                    ModificationItemImpl modification = modificationIterator.next();
                    buffer.put((byte)48);
                    int localModificationSequenceLength = this.modificationSequenceLength.get(modificationNumber);
                    buffer.put(TLV.getBytes((int)localModificationSequenceLength));
                    buffer.put((byte)10);
                    buffer.put((byte)1);
                    switch (modification.getModificationOp()) {
                        case 1: {
                            buffer.put((byte)0);
                            break;
                        }
                        case 3: {
                            buffer.put((byte)1);
                            break;
                        }
                        case 2: {
                            buffer.put((byte)2);
                        }
                    }
                    buffer.put((byte)48);
                    int localModificationLength = this.modificationLength.get(modificationNumber);
                    buffer.put(TLV.getBytes((int)localModificationLength));
                    Value.encode((ByteBuffer)buffer, (String)modification.getAttribute().getID());
                    buffer.put((byte)49);
                    int localValuesLength = this.valuesLength.get(modificationNumber);
                    buffer.put(TLV.getBytes((int)localValuesLength));
                    try {
                        NamingEnumeration<?> values = modification.getAttribute().getAll();
                        if (values.hasMoreElements()) {
                            while (values.hasMoreElements()) {
                                Object value = values.next();
                                if (value instanceof String) {
                                    Value.encode((ByteBuffer)buffer, (String)((String)value));
                                    continue;
                                }
                                Value.encode((ByteBuffer)buffer, (byte[])((byte[])value));
                            }
                        }
                    }
                    catch (NamingException ne) {
                        throw new EncoderException("Cannot enumerate the values");
                    }
                    ++modificationNumber;
                }
            }
            catch (BufferOverflowException boe) {
                throw new EncoderException("The PDU buffer size is too small !");
            }
        }
        return buffer;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Modify Request\n");
        sb.append("        Object : '").append(this.object).append("'\n");
        if (this.modifications != null) {
            int i = 0;
            for (ModificationItemImpl modification : this.modifications) {
                sb.append("            Modification[").append(i).append("]\n");
                sb.append("                Operation : ");
                if (modification != null) {
                    switch (modification.getModificationOp()) {
                        case 1: {
                            sb.append(" add\n");
                            break;
                        }
                        case 2: {
                            sb.append(" replace\n");
                            break;
                        }
                        case 3: {
                            sb.append(" delete\n");
                        }
                    }
                    sb.append("                Modification\n");
                    Attribute attribute = modification.getAttribute();
                    if (attribute == null) continue;
                    try {
                        sb.append("                    Type : '").append(attribute.getID()).append("'\n");
                        sb.append("                    Vals\n");
                        for (int j = 0; j < attribute.size(); ++j) {
                            Object attributeValue = attribute.get(j);
                            sb.append("                        Val[").append(j).append("] : '");
                            if (attributeValue != null) {
                                if (attributeValue instanceof String) {
                                    sb.append(attributeValue).append("' \n");
                                    continue;
                                }
                                sb.append(StringTools.utf8ToString((byte[])attributeValue)).append("' \n");
                                continue;
                            }
                            sb.append("<null>'\n");
                        }
                        continue;
                    }
                    catch (NamingException ne) {
                        log.error("Naming exception while printing the '{}'", (Object)attribute.getID());
                        continue;
                    }
                }
                sb.append(" unknown modification operation\n");
            }
        }
        return sb.toString();
    }
}

