/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import org.apache.directory.shared.ldap.filter.AbstractExprNode;
import org.apache.directory.shared.ldap.filter.Assertion;
import org.apache.directory.shared.ldap.filter.AssertionEnum;
import org.apache.directory.shared.ldap.filter.FilterVisitor;

public class AssertionNode
extends AbstractExprNode {
    private static final Long MAX = Long.MAX_VALUE;
    private static final String MAX_STR = "[" + MAX.toString() + "]";
    private final Assertion m_assertion;
    private final String m_desc;

    public AssertionNode(Assertion a_assertion) {
        this(a_assertion, "ASSERTION");
    }

    public AssertionNode(Assertion a_assertion, String a_desc) {
        super(AssertionEnum.ASSERTION);
        this.m_desc = a_desc;
        this.m_assertion = a_assertion;
        this.set("count", MAX);
    }

    public Assertion getAssertion() {
        return this.m_assertion;
    }

    public boolean isLeaf() {
        return true;
    }

    public StringBuffer printToBuffer(StringBuffer a_buf) {
        return a_buf.append(this.m_desc).append(MAX_STR);
    }

    public StringBuffer printRefinementToBuffer(StringBuffer a_buf) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("AssertionNode can't be part of a refinement");
    }

    public void accept(FilterVisitor a_visitor) {
        a_visitor.visit(this);
    }
}

