/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.shared.ldap.message.Referral;

public class ReferralImpl
implements Referral {
    static final long serialVersionUID = 2638820668325359096L;
    private final List<String> urls = new ArrayList<String>();

    public Collection getLdapUrls() {
        return Collections.unmodifiableCollection(this.urls);
    }

    public void addLdapUrl(String url) {
        this.urls.add(url);
    }

    public void removeLdapUrl(String url) {
        this.urls.remove(url);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Referral) {
            Collection refs = ((Referral)obj).getLdapUrls();
            if (refs.size() != this.urls.size()) {
                return false;
            }
            Iterator<String> list = this.urls.iterator();
            while (list.hasNext()) {
                if (refs.contains(list.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.urls != null && this.urls.size() != 0) {
            sb.append("            Referrals :\n");
            Object[] urlsArray = this.urls.toArray();
            for (int i = 0; i < urlsArray.length; ++i) {
                String referral = (String)urlsArray[i];
                sb.append("                Referral[").append(i).append("] :").append(referral).append('\n');
            }
        }
        return sb.toString();
    }
}

