/*
 * Decompiled with CFR 0.152.
 */
package org.bson.json;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;

final class DateTimeFormatter {
    static long parse(String dateTimeString) {
        try {
            return java.time.format.DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)dateTimeString, new TemporalQuery<Instant>(){

                @Override
                public Instant queryFrom(TemporalAccessor temporal) {
                    return Instant.from(temporal);
                }
            }).toEpochMilli();
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    static String format(long dateTime) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(dateTime), ZoneId.of("Z")).format(java.time.format.DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    private DateTimeFormatter() {
    }
}

