/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.management;

import java.io.Serializable;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.AbstractResource;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="management/elasticsearch")
@Produces(value={"application/json"})
public class ElasticsearchObject
extends AbstractResource<ResourceTypeImpl> {
    public static final String GET_ALL_DOCUMENTS_QUERY = "SELECT * from Document";

    @POST
    @Path(value="reindex")
    public BulkStatus doIndexing(@QueryParam(value="query") String query) {
        return this.performIndexing(query);
    }

    @POST
    @Path(value="{documentId}/reindex")
    public BulkStatus doIndexingOnDocument(@PathParam(value="documentId") String documentId) {
        String query = String.format("Select * From Document where %s = '%s' or %s = '%s'", "ecm:uuid", documentId, "ecm:ancestorId", documentId);
        return this.performIndexing(query);
    }

    @POST
    @Path(value="flush")
    public void doFlush() {
        Framework.doPrivileged(() -> ((ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class)).flushRepositoryIndex(this.ctx.getCoreSession().getRepositoryName()));
    }

    @POST
    @Path(value="optimize")
    public void doOptimize() {
        Framework.doPrivileged(() -> ((ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class)).optimizeRepositoryIndex(this.ctx.getCoreSession().getRepositoryName()));
    }

    protected BulkStatus performIndexing(String query) {
        String nxql = (String)StringUtils.defaultIfBlank((CharSequence)query, (CharSequence)GET_ALL_DOCUMENTS_QUERY);
        BulkService bulkService = (BulkService)Framework.getService(BulkService.class);
        String commandId = bulkService.submit(new BulkCommand.Builder("index", nxql, "system").repository(this.ctx.getCoreSession().getRepositoryName()).param("updateAlias", (Serializable)Boolean.valueOf(true)).build());
        return (BulkStatus)bulkService.getStatus((Serializable)((Object)commandId));
    }
}

