/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.config.jmx;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.jmx.WroConfigurationMBean;

public class WroConfiguration
implements WroConfigurationMBean {
    private static final Logger LOG = LoggerFactory.getLogger(WroConfiguration.class);
    public static final String DEFAULT_ENCODING = StandardCharsets.UTF_8.name();
    public static final int DEFAULT_CONNECTION_TIMEOUT = 2000;
    private long cacheUpdatePeriod;
    private long modelUpdatePeriod;
    private long resourceWatcherUpdatePeriod;
    private boolean resourceWatcherAsync;
    private boolean gzipEnabled = true;
    private boolean debug = true;
    private boolean ignoreMissingResources = true;
    private boolean cacheGzippedContent = false;
    private boolean jmxEnabled = true;
    private String wroManagerClassName;
    private String encoding = DEFAULT_ENCODING;
    private String mbeanName;
    private String header;
    private int connectionTimeout = 2000;
    private boolean parallelPreprocessing = false;
    private boolean ignoreEmptyGroup = true;
    private boolean ignoreFailingProcessor = false;
    private boolean minimizeEnabled = true;
    private final transient List<PropertyChangeListener> cacheUpdatePeriodListeners = new ArrayList<PropertyChangeListener>(1);
    private final transient List<PropertyChangeListener> modelUpdatePeriodListeners = new ArrayList<PropertyChangeListener>(1);

    public static String getObjectName() {
        return WroConfiguration.class.getPackage().getName() + ".jmx:type=" + WroConfiguration.class.getSimpleName();
    }

    @Override
    public long getCacheUpdatePeriod() {
        return this.cacheUpdatePeriod;
    }

    @Override
    public long getModelUpdatePeriod() {
        return this.modelUpdatePeriod;
    }

    @Override
    public void setCacheUpdatePeriod(long period) {
        if (period != this.cacheUpdatePeriod) {
            this.reloadCacheWithNewValue(period);
        }
        this.cacheUpdatePeriod = period;
    }

    @Override
    public void setModelUpdatePeriod(long period) {
        if (period != this.modelUpdatePeriod) {
            this.reloadModelWithNewValue(period);
        }
        this.modelUpdatePeriod = period;
    }

    @Override
    public boolean isGzipEnabled() {
        return this.gzipEnabled;
    }

    @Override
    public void setGzipEnabled(boolean enable) {
        this.gzipEnabled = enable;
    }

    @Override
    public void reloadCache() {
        this.reloadCacheWithNewValue(null);
    }

    private void reloadCacheWithNewValue(Long newValue) {
        long newValueAsPrimitive = newValue == null ? this.getCacheUpdatePeriod() : newValue.longValue();
        LOG.debug("invoking {} listeners", (Object)this.cacheUpdatePeriodListeners.size());
        for (PropertyChangeListener listener : this.cacheUpdatePeriodListeners) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, "cache", this.getCacheUpdatePeriod(), newValueAsPrimitive);
            listener.propertyChange(event);
        }
    }

    @Override
    public void reloadModel() {
        LOG.debug("reloadModel");
        this.reloadModelWithNewValue(null);
    }

    private void reloadModelWithNewValue(Long newValue) {
        long newValueAsPrimitive = newValue == null ? this.getModelUpdatePeriod() : newValue.longValue();
        for (PropertyChangeListener listener : this.modelUpdatePeriodListeners) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, "model", this.getModelUpdatePeriod(), newValueAsPrimitive);
            listener.propertyChange(event);
        }
    }

    public void registerModelUpdatePeriodChangeListener(PropertyChangeListener listener) {
        this.modelUpdatePeriodListeners.add(listener);
    }

    public void registerCacheUpdatePeriodChangeListener(PropertyChangeListener listener) {
        this.cacheUpdatePeriodListeners.add(listener);
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public boolean isIgnoreMissingResources() {
        return this.ignoreMissingResources;
    }

    @Override
    public void setIgnoreMissingResources(boolean ignoreMissingResources) {
        this.ignoreMissingResources = ignoreMissingResources;
    }

    public boolean isJmxEnabled() {
        return this.jmxEnabled;
    }

    public void setJmxEnabled(boolean jmxEnabled) {
        this.jmxEnabled = jmxEnabled;
    }

    @Override
    public boolean isCacheGzippedContent() {
        return this.cacheGzippedContent;
    }

    @Override
    public void setCacheGzippedContent(boolean cacheGzippedContent) {
        this.cacheGzippedContent = cacheGzippedContent;
    }

    public void destroy() {
        this.cacheUpdatePeriodListeners.clear();
        this.modelUpdatePeriodListeners.clear();
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding == null ? DEFAULT_ENCODING : encoding;
    }

    public String getWroManagerClassName() {
        return this.wroManagerClassName;
    }

    public void setWroManagerClassName(String wroManagerClassName) {
        this.wroManagerClassName = wroManagerClassName;
    }

    public String getMbeanName() {
        return this.mbeanName;
    }

    public void setMbeanName(String mbeanName) {
        this.mbeanName = mbeanName;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public boolean isParallelPreprocessing() {
        return this.parallelPreprocessing;
    }

    public void setParallelPreprocessing(boolean parallelPreprocessing) {
        this.parallelPreprocessing = parallelPreprocessing;
    }

    @Override
    public boolean isIgnoreEmptyGroup() {
        return this.ignoreEmptyGroup;
    }

    @Override
    public void setIgnoreEmptyGroup(boolean ignoreEmptyGroup) {
        this.ignoreEmptyGroup = ignoreEmptyGroup;
    }

    public boolean isIgnoreFailingProcessor() {
        return this.ignoreFailingProcessor;
    }

    public void setIgnoreFailingProcessor(boolean ignoreFailingProcessor) {
        this.ignoreFailingProcessor = ignoreFailingProcessor;
    }

    @Override
    public final long getResourceWatcherUpdatePeriod() {
        return this.resourceWatcherUpdatePeriod;
    }

    @Override
    public final void setResourceWatcherUpdatePeriod(long resourceWatcherUpdatePeriod) {
        this.resourceWatcherUpdatePeriod = resourceWatcherUpdatePeriod;
    }

    @Override
    public boolean isMinimizeEnabled() {
        return this.minimizeEnabled;
    }

    @Override
    public void setMinimizeEnabled(boolean minimizeEnabled) {
        this.minimizeEnabled = minimizeEnabled;
    }

    public boolean isResourceWatcherAsync() {
        return this.resourceWatcherAsync;
    }

    public void setResourceWatcherAsync(boolean resourceWatcherAsync) {
        this.resourceWatcherAsync = resourceWatcherAsync;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (boolean)true);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

