/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.decorator;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.decorator.ProcessorDecorator;

public class ExtensionsAwareProcessorDecorator
extends ProcessorDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionsAwareProcessorDecorator.class);
    private final Set<String> extensions = new HashSet<String>();

    private ExtensionsAwareProcessorDecorator(ResourcePreProcessor preProcessor) {
        super(preProcessor);
    }

    private ExtensionsAwareProcessorDecorator(ResourcePostProcessor postProcessor) {
        super(postProcessor);
    }

    public ExtensionsAwareProcessorDecorator addExtension(String extension) {
        Validate.notBlank((CharSequence)extension);
        this.extensions.add(extension);
        return this;
    }

    public static ExtensionsAwareProcessorDecorator decorate(ResourcePreProcessor preProcessor) {
        return new ExtensionsAwareProcessorDecorator(preProcessor);
    }

    @Override
    protected boolean isEnabled(Resource resource) {
        return super.isEnabled(resource) && this.isApplicable(resource);
    }

    private boolean isApplicable(Resource resource) {
        boolean isApplicable;
        String resourceExtension = resource != null ? FilenameUtils.getExtension((String)resource.getUri()) : "";
        boolean bl = isApplicable = resource == null || this.extensions.contains(resourceExtension);
        if (isApplicable) {
            LOG.debug("[OK] Process resource {} with extension: {}", (Object)(resource != null ? resource.getUri() : "null"), (Object)resourceExtension);
        }
        return isApplicable;
    }
}

