/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.js;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.io.output.ProxyOutputStream;
import org.apache.commons.io.output.WriterOutputStream;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.Minimize;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.support.JSMin;

@Minimize
@SupportedResourceType(value=ResourceType.JS)
public class JSMinProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    public static final String ALIAS = "jsMin";
    @Inject
    private ReadOnlyContext context;
    private String encoding;

    @Override
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        try (ProxyInputStream is = new ProxyInputStream((InputStream)new ReaderInputStream(reader, this.getEncoding())){};
             ProxyOutputStream os = new ProxyOutputStream((OutputStream)new WriterOutputStream(writer, this.getEncoding()));){
            new JSMin((InputStream)is, (OutputStream)os).jsmin();
        }
        catch (Exception e) {
            throw WroRuntimeException.wrap(e);
        }
    }

    @Override
    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    private String getEncoding() {
        if (this.encoding == null) {
            this.encoding = Context.isContextSet() ? this.context.getConfig().getEncoding() : WroConfiguration.DEFAULT_ENCODING;
        }
        return this.encoding;
    }

    public JSMinProcessor setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }
}

