/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.management;

import java.io.Serializable;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.AbstractResource;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="management/pictures")
@Produces(value={"application/json"})
public class PicturesObject
extends AbstractResource<ResourceTypeImpl> {
    public static final String PICTURES_DEFAULT_QUERY = "SELECT * FROM Document WHERE ecm:mixinType = 'Picture' AND picture:views/*/title IS NULL";

    @POST
    @Path(value="recompute")
    public BulkStatus doPostPictures(@FormParam(value="query") String query) {
        String finalQuery = (String)StringUtils.defaultIfBlank((CharSequence)query, (CharSequence)PICTURES_DEFAULT_QUERY);
        BulkService bulkService = (BulkService)Framework.getService(BulkService.class);
        String commandId = bulkService.submit(new BulkCommand.Builder("recomputeViews", finalQuery, "system").repository(this.ctx.getCoreSession().getRepositoryName()).param("xpath", (Serializable)((Object)"file:content")).build());
        return (BulkStatus)bulkService.getStatus((Serializable)((Object)commandId));
    }
}

