/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.query.sql.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.OrderByList;
import org.nuxeo.ecm.core.query.sql.model.Predicate;

public class QueryBuilder {
    protected MultiExpression filter;
    protected OrderByList orders;
    protected long offset;
    protected long limit;
    protected boolean countTotal;

    public QueryBuilder() {
        this.filter = new MultiExpression(Operator.AND, new ArrayList<Predicate>());
        this.orders = new OrderByList();
    }

    public QueryBuilder(QueryBuilder other) {
        this.filter = new MultiExpression(other.filter);
        this.orders = new OrderByList(other.orders);
        this.offset = other.offset;
        this.limit = other.limit;
        this.countTotal = other.countTotal;
    }

    public MultiExpression predicate() {
        return this.filter;
    }

    public QueryBuilder and(Predicate predicate) {
        if (this.filter.predicates.isEmpty()) {
            throw new IllegalStateException("Cannot AND without a first predicate");
        }
        if (this.filter.operator != Operator.AND) {
            if (this.filter.predicates.size() == 1) {
                this.filter = new MultiExpression(Operator.AND, this.filter.predicates);
            } else {
                throw new IllegalStateException("Not an AND MultiExpression");
            }
        }
        return this.predicate(predicate);
    }

    public QueryBuilder or(Predicate predicate) {
        if (this.filter.predicates.isEmpty()) {
            throw new IllegalStateException("Cannot OR without a first predicate");
        }
        if (this.filter.operator != Operator.OR) {
            if (this.filter.predicates.size() == 1) {
                this.filter = new MultiExpression(Operator.OR, this.filter.predicates);
            } else {
                throw new IllegalStateException("Not an OR MultiExpression");
            }
        }
        return this.predicate(predicate);
    }

    public QueryBuilder predicate(Predicate predicate) {
        this.filter.predicates.add(predicate);
        return this;
    }

    public QueryBuilder filter(MultiExpression filter) {
        this.filter = new MultiExpression(filter);
        return this;
    }

    public OrderByList orders() {
        return this.orders;
    }

    public QueryBuilder defaultOrder() {
        return this;
    }

    public QueryBuilder order(OrderByExpr order) {
        this.orders.add(order);
        return this;
    }

    public QueryBuilder orders(OrderByExpr order, OrderByExpr ... orders) {
        return this.orders(Stream.concat(Stream.of(order), Stream.of(orders)).collect(Collectors.toList()));
    }

    public QueryBuilder orders(List<OrderByExpr> orders) {
        this.orders.clear();
        this.orders.addAll(orders);
        return this;
    }

    public long offset() {
        return this.offset;
    }

    public QueryBuilder offset(long offset) {
        this.offset = offset;
        return this;
    }

    public long limit() {
        return this.limit;
    }

    public QueryBuilder limit(long limit) {
        this.limit = limit;
        return this;
    }

    public boolean countTotal() {
        return this.countTotal;
    }

    public QueryBuilder countTotal(boolean countTotal) {
        this.countTotal = countTotal;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

