/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.adapter;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.video.TranscodedVideo;
import org.nuxeo.ecm.platform.video.Video;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.ecm.platform.video.VideoInfo;

public class VideoDocumentAdapter
implements VideoDocument {
    private static final Log log = LogFactory.getLog(VideoDocumentAdapter.class);
    private final DocumentModel doc;
    private final Video video;
    private Map<String, TranscodedVideo> transcodedVideos;

    public VideoDocumentAdapter(DocumentModel doc) {
        if (!doc.hasFacet("Video")) {
            throw new NuxeoException(doc + " is not a Video document.");
        }
        this.doc = doc;
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        Blob blob = bh.getBlob();
        Map videoInfoMap = (Map)((Object)doc.getPropertyValue("vid:info"));
        VideoInfo videoInfo = VideoInfo.fromMap(videoInfoMap);
        this.video = Video.fromBlobAndInfo(blob, videoInfo);
    }

    @Override
    public Video getVideo() {
        return this.video;
    }

    @Override
    public Collection<TranscodedVideo> getTranscodedVideos() {
        if (this.transcodedVideos == null) {
            this.initTranscodedVideos();
        }
        return this.transcodedVideos.values();
    }

    @Override
    public TranscodedVideo getTranscodedVideo(String name) {
        if (this.transcodedVideos == null) {
            this.initTranscodedVideos();
        }
        return this.transcodedVideos.get(name);
    }

    private void initTranscodedVideos() {
        if (this.transcodedVideos == null) {
            List videos = (List)((Object)this.doc.getPropertyValue("vid:transcodedVideos"));
            this.transcodedVideos = Maps.newHashMap();
            for (int i = 0; i < videos.size(); ++i) {
                TranscodedVideo transcodedVideo = TranscodedVideo.fromMapAndPosition((Map)videos.get(i), i);
                this.transcodedVideos.put(transcodedVideo.getName(), transcodedVideo);
            }
        }
    }
}

